/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidFieldTypeException;
import org.makumba.NoSuchFieldException;
import org.makumba.NoSuchLabelException;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.query.FunctionInliner;

public abstract class QueryAnalysisProvider {
    NamedResources inlinedQueries;
    boolean initializedCache;

    protected abstract QueryAnalysis getRawQueryAnalysis(String var1);

    public QueryAnalysis getQueryAnalysis(String query) {
        return this.getRawQueryAnalysis(this.inlineFunctions(query));
    }

    public String inlineFunctions(String query) {
        try {
            return (String)this.inlinedQueries.getResource(query);
        }
        catch (NullPointerException e) {
            this.initializeCache(query, e);
            return (String)this.inlinedQueries.getResource(query);
        }
    }

    public abstract boolean selectGroupOrOrderAsLabels();

    public abstract FieldDefinition getAlternativeField(DataDefinition var1, String var2);

    public abstract String getPrimaryKeyNotation(String var1);

    public Object checkExprSetOrNullable(String from, String expr) {
        if (expr.toLowerCase().indexOf(" from ") != -1) {
            return null;
        }
        String query = "SELECT " + expr + " FROM " + from;
        query = this.inlineFunctions(query);
        expr = query.substring(7);
        expr = expr.substring(0, expr.indexOf("FROM"));
        int n = 0;
        int m = 0;
        while (true) {
            if (n < expr.length() && !QueryAnalysisProvider.isMakId(expr.charAt(n))) {
                ++n;
                continue;
            }
            if (n == expr.length()) {
                return null;
            }
            m = n;
            while (n < expr.length() && QueryAnalysisProvider.isMakId(expr.charAt(n))) {
                ++n;
            }
            Object nl = this.checkLabelSetOrNullable(from, expr.substring(m, n));
            if (nl != null) {
                return nl;
            }
            if (n == expr.length()) break;
        }
        return null;
    }

    static boolean isMakId(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.';
    }

    public Object checkLabelSetOrNullable(String from, String referenceSequence) {
        int dot = referenceSequence.indexOf(".");
        if (dot == -1) {
            return null;
        }
        String substring = referenceSequence.substring(0, dot);
        try {
            Integer.parseInt(substring);
            return null;
        }
        catch (NumberFormatException e) {
            DataDefinition dd = this.getQueryAnalysis("SELECT 1 FROM " + from).getLabelType(substring);
            if (dd == null) {
                throw new NoSuchLabelException("no such label '" + substring + "'.");
            }
            while (true) {
                int dot1;
                if ((dot1 = referenceSequence.indexOf(".", dot + 1)) == -1) {
                    String fn = referenceSequence.substring(dot + 1);
                    FieldDefinition fd = dd.getFieldDefinition(fn);
                    if (fd == null && (fd = this.getAlternativeField(dd, fn)) == null) {
                        throw new NoSuchFieldException(dd, fn);
                    }
                    if (fd.getType().equals("set")) {
                        return fd;
                    }
                    return null;
                }
                FieldDefinition fd = dd.getFieldDefinition(referenceSequence.substring(dot + 1, dot1));
                if (fd == null) {
                    throw new NoSuchFieldException(dd, referenceSequence.substring(dot + 1, dot1));
                }
                if (!fd.getType().startsWith("ptr")) {
                    throw new InvalidFieldTypeException(fd, "pointer");
                }
                if (!fd.isNotNull()) {
                    return referenceSequence.substring(0, dot1);
                }
                dd = fd.getPointedType();
                dot = dot1;
            }
        }
    }

    private synchronized void initializeCache(String query, NullPointerException e) {
        if (this.inlinedQueries == null) {
            this.inlinedQueries = NamedResources.getStaticCache(NamedResources.makeStaticCache("Inlined queries by " + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1), new NamedResourceFactory(){
                private static final long serialVersionUID = 1L;

                protected Object makeResource(Object nm, Object hashName) throws Exception {
                    return FunctionInliner.inline((String)nm, QueryAnalysisProvider.this);
                }
            }, true));
            this.initializedCache = true;
        } else if (!this.initializedCache) {
            throw e;
        }
    }

    public abstract String getParameterSyntax();
}

