/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.makumba.validation;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.ValidationDefinitionParseError;
import org.makumba.commons.RegExpUtils;
import org.makumba.forms.html.dateEditor;
import org.makumba.providers.datadefinition.makumba.validation.BasicValidationRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonValidationRule
extends BasicValidationRule {
    private static final String operator = "compare";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd. MMM yyyy HH:mm:ss");
    private static final long serialVersionUID = 1L;
    public static final String now = "$now";
    public static final String today = "$today";
    public static final String dateFunction = "date(";
    public static final String dateFunctionParamExpression = "[\\s]*(\\$now[\\s]*(\\+[\\s]*\\d+|-[\\s]*\\d+)?|\\d+)[\\s]*";
    public static final String dateFunctionExpression = "date\\(([\\s]*(\\$now[\\s]*(\\+[\\s]*\\d+|-[\\s]*\\d+)?|\\d+)[\\s]*,){0,5}([\\s]*(\\$now[\\s]*(\\+[\\s]*\\d+|-[\\s]*\\d+)?|\\d+)[\\s]*)?\\)";
    public static final String compareTo = RegExpUtils.or(new String[]{"[a-zA-Z]\\w*(?:\\.\\w+)?", "\\$now", "\\$today", "date\\(([\\s]*(\\$now[\\s]*(\\+[\\s]*\\d+|-[\\s]*\\d+)?|\\d+)[\\s]*,){0,5}([\\s]*(\\$now[\\s]*(\\+[\\s]*\\d+|-[\\s]*\\d+)?|\\d+)[\\s]*)?\\)"});
    public static final String dateExpression = RegExpUtils.or(new String[]{"\\$now", "\\$today", "date\\(([\\s]*(\\$now[\\s]*(\\+[\\s]*\\d+|-[\\s]*\\d+)?|\\d+)[\\s]*,){0,5}([\\s]*(\\$now[\\s]*(\\+[\\s]*\\d+|-[\\s]*\\d+)?|\\d+)[\\s]*)?\\)"});
    public static final String comparisonOperators = "(<|>|=|>=|<=|!=)";
    public static final String rule = "([a-zA-Z]\\w*(?:\\.\\w+)?|lower\\([a-zA-Z]\\w*(?:\\.\\w+)?\\))[ \\t]*(<|>|=|>=|<=|!=)[ \\t]*" + compareTo;
    private static final Pattern pattern = Pattern.compile(rule);
    private static final Pattern dateExpressionPattern = Pattern.compile(dateExpression);
    private FieldDefinition otherFd;
    private String otherFieldName;
    private String compareOperator;
    private String compareToExpression;
    private String functionName;

    public ComparisonValidationRule(FieldDefinition fd, String fieldName, String functionName, FieldDefinition otherFd, String otherFieldName, String ruleName, String errorMessage, String compareOperator) throws ValidationDefinitionParseError {
        super(fd, fieldName, errorMessage, ruleName, NUMBER_TYPES);
        this.otherFd = otherFd;
        this.otherFieldName = otherFieldName;
        this.compareOperator = compareOperator;
        this.functionName = functionName;
    }

    public ComparisonValidationRule(FieldDefinition fd, String fieldName, String compareToExpression, String ruleName, String errorMessage, String compareOperator) {
        super(fd, fieldName, errorMessage, ruleName, NUMBER_TYPES);
        this.compareOperator = compareOperator;
        this.compareToExpression = compareToExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validate(Object value) throws InvalidValueException {
        int compare;
        boolean stringComparison;
        Object o2;
        Object o1;
        boolean validateAgaintsField;
        boolean validateAgainstExpression = value instanceof Date && this.compareToExpression != null;
        boolean bl = validateAgaintsField = value instanceof Object[] && ((Object[])value).length == 2;
        if (!validateAgainstExpression && !validateAgaintsField) {
            return false;
        }
        if (validateAgainstExpression) {
            o1 = value;
            o2 = this.evaluateExpression();
        } else {
            o1 = ((Object[])value)[0];
            o2 = ((Object[])value)[1];
        }
        if (this.functionName != null) {
            o1 = this.applyFunction(o1, this.functionName);
        }
        boolean numberComparison = o1 instanceof Number && o2 instanceof Number;
        boolean dateComparison = o1 instanceof Date && o2 instanceof Date;
        boolean bl2 = stringComparison = o1 instanceof String && o2 instanceof String;
        if (!(numberComparison || dateComparison || stringComparison)) {
            return false;
        }
        if (numberComparison) {
            compare = Double.compare(((Number)o1).doubleValue(), ((Number)o2).doubleValue());
        } else if (stringComparison) {
            if (((String)o1).length() <= 0 || ((String)o2).length() <= 0) return true;
            compare = ((String)o1).compareTo((String)o2);
        } else {
            compare = ((Date)o1).compareTo((Date)o2);
        }
        if (this.compareOperator.equals("<")) {
            return this.throwException(compare < 0);
        }
        if (this.compareOperator.equals("<=")) {
            return this.throwException(compare < 0 || compare == 0);
        }
        if (this.compareOperator.equals("=")) {
            return this.throwException(compare == 0);
        }
        if (this.compareOperator.equals(">")) {
            return this.throwException(compare > 0);
        }
        if (this.compareOperator.equals(">=")) {
            return this.throwException(compare > 0 || compare == 0);
        }
        if (!this.compareOperator.equals("!=")) return false;
        return this.throwException(compare != 0);
    }

    public String toString() {
        String to = this.compareToExpression != null ? this.compareToExpression + " [ = " + dateFormat.format(this.evaluateExpression()) + "]" : this.otherFieldName;
        String field = this.functionName != null ? this.functionName + "(" + this.fieldName + ")" : this.fieldName;
        return field + " " + this.compareOperator + " " + to;
    }

    public String getOtherFieldName() {
        return this.otherFieldName;
    }

    public FieldDefinition getOtherFd() {
        return this.otherFd;
    }

    public String getCompareOperator() {
        return this.compareOperator;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    protected boolean throwException(boolean b) throws InvalidValueException {
        if (!b) {
            throw new InvalidValueException(this.fieldName, this.getErrorMessage());
        }
        return b;
    }

    public boolean isCompareToExpression() {
        return this.compareToExpression != null;
    }

    public Date evaluateExpression() throws ValidationDefinitionParseError {
        GregorianCalendar c = new GregorianCalendar();
        c.set(14, 0);
        String expr = this.compareToExpression.replaceAll("\\s", "");
        if (!expr.equals(now)) {
            if (expr.equals(today)) {
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
            } else if (expr.startsWith(dateFunction)) {
                expr = ComparisonValidationRule.extractFunctionArgument(expr);
                String[] split = expr.split(",");
                for (int i = 0; i < split.length; ++i) {
                    if (split[i].equals(now)) continue;
                    if (split[i].startsWith(now)) {
                        String operator = split[i].substring(now.length(), now.length() + 1);
                        int summand = Integer.parseInt(split[i].substring(now.length() + 1));
                        int val = c.get(dateEditor.components[i]);
                        if (operator.trim().equals("-")) {
                            c.set(dateEditor.components[i], val - summand);
                            continue;
                        }
                        if (!operator.trim().equals("+")) continue;
                        c.set(dateEditor.components[i], val + summand);
                        continue;
                    }
                    c.set(dateEditor.components[i], Integer.parseInt(split[i]));
                }
            }
        }
        return c.getTime();
    }

    public static boolean matches(String rule) {
        return ComparisonValidationRule.getMatcher(rule).matches();
    }

    public static Matcher getMatcher(String rule) {
        return pattern.matcher(rule);
    }

    public static Matcher getDateExpressionMatcher(String rule) {
        return dateExpressionPattern.matcher(rule);
    }

    public static boolean matchesDateExpression(String rule) {
        return ComparisonValidationRule.getDateExpressionMatcher(rule).matches();
    }

    public static List<String> getOperators() {
        return Arrays.asList("<", "=", ">", "!=", ">=", "<=");
    }

    public static void main(String[] args) {
        String[] rules = new String[]{"someField > $now", "someField = $today", "someField > someOtherField", "someField = $now", "someField >= other", "lower(x)=y", "someField<=$today", "birthdate <= date($now, $now, $now + 105, 0, 0, 0)", "birthdate <= date($now, $now, $now + 105, 0, 0, 0)", " beginDate >= date($now,$now,$now - 5)", "beginDate >= date($now-5,$now,$now - 5)", "birthdate >= date($now, $now, $now - 15, 0, 0, 0)", "lower(indiv.name) != indiv.name"};
        RegExpUtils.evaluate(pattern, rules, false);
        rules = new String[]{"birthdate <= date($now, $now, $now - 15, 0, 0, 0)", "lower(indiv.name) != indiv.name"};
        RegExpUtils.evaluate(pattern, rules, false);
    }

    public static String getOperator() {
        return operator;
    }
}

