/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.ASTFactory;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import java.io.PrintWriter;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.commons.NameResolver;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.query.mql.ASTUtil;
import org.makumba.providers.query.mql.MqlDotNode;
import org.makumba.providers.query.mql.MqlIdentNode;
import org.makumba.providers.query.mql.MqlNode;
import org.makumba.providers.query.mql.MqlQueryAnalysis;
import org.makumba.providers.query.mql.MqlSqlASTFactory;
import org.makumba.providers.query.mql.MqlSqlBaseWalker;
import org.makumba.providers.query.mql.QueryContext;

public class MqlSqlWalker
extends MqlSqlBaseWalker {
    ASTFactory fact;
    RecognitionException error;
    QueryContext currentContext;
    private boolean fromEnded;
    static PrintWriter pw = new PrintWriter(System.out);
    DataDefinition paramInfo;
    private AST select;
    QueryContext rootContext;
    boolean hasSubqueries;
    String query;
    boolean optimizeJoins;

    public MqlSqlWalker(String query, DataDefinition paramInfo, boolean optimizeJoins) {
        this.query = query;
        this.optimizeJoins = optimizeJoins;
        this.fact = new MqlSqlASTFactory(this);
        this.setASTFactory(this.fact);
        this.paramInfo = paramInfo;
    }

    public void reportError(RecognitionException e) {
        if (this.error == null) {
            this.error = e;
        }
    }

    public void reportError(String s) {
        if (this.error == null) {
            this.error = new RecognitionException(s);
        }
    }

    public void reportWarning(String s) {
        System.out.println(s);
    }

    protected void pushFromClause(AST fromClause, AST inputFromNode) {
        QueryContext c = new QueryContext(this);
        c.setParent(this.currentContext);
        if (this.currentContext == null) {
            this.rootContext = c;
        } else {
            this.hasSubqueries = true;
        }
        this.currentContext = c;
    }

    protected void setFromEnded() throws SemanticException {
        this.fromEnded = true;
    }

    protected void processQuery(AST select, AST query) throws SemanticException {
        if (this.error != null) {
            return;
        }
        if (select == null) {
            this.addDefaultProjections(query);
        }
        this.select = query.getFirstChild();
        this.currentContext.close();
        if (!this.currentContext.filters.isEmpty()) {
            this.addFilters(query);
        }
        this.currentContext = this.currentContext.getParent();
    }

    private void addDefaultProjections(AST query) throws SemanticException {
        AST clause = ASTUtil.create(this.fact, 131, "");
        clause.setNextSibling(query.getFirstChild());
        MqlIdentNode lastProjection = null;
        for (String label : this.currentContext.explicitLabels) {
            MqlIdentNode proj = (MqlIdentNode)ASTUtil.create(this.fact, 120, label);
            proj.resolve();
            if (lastProjection == null) {
                clause.setFirstChild((AST)proj);
            } else {
                lastProjection.setNextSibling((AST)proj);
            }
            lastProjection = proj;
        }
        query.setFirstChild(clause);
    }

    private void addFilters(AST query) {
        AST a;
        AST from = query.getFirstChild();
        while (from.getType() != 22) {
            from = from.getNextSibling();
        }
        AST where = from.getNextSibling();
        if (where == null || where.getType() != 53) {
            a = where;
            where = ASTUtil.create(this.fact, 53, "");
            from.setNextSibling(where);
            where.setNextSibling(a);
        }
        a = where.getFirstChild();
        AST filters = ASTUtil.create(this.fact, 140, "");
        where.setFirstChild(filters);
        filters.setNextSibling(a);
        MqlNode lastCond = null;
        for (NameResolver.TextList f : this.currentContext.filters) {
            MqlNode sqlToken = (MqlNode)ASTUtil.create(this.fact, 136, "");
            if (lastCond != null) {
                lastCond.setNextSibling((AST)sqlToken);
            } else {
                filters.setFirstChild((AST)sqlToken);
            }
            lastCond = sqlToken;
            sqlToken.setTextList(f);
        }
    }

    protected AST createFromElement(String path, AST alias, AST propertyFetch) throws SemanticException {
        return this.currentContext.createFromElement(path, alias, 28);
    }

    protected void createFromJoinElement(AST path, AST alias, int joinType, AST fetch, AST propertyFetch, AST with) throws SemanticException {
        if (this.error != null) {
            return;
        }
        if (!(path instanceof MqlDotNode)) {
            throw new SemanticException("can only support dot froms " + path, "", path.getLine(), path.getColumn());
        }
        ((MqlDotNode)path).processInFrom();
        this.currentContext.createFromElement(path.getText(), alias, joinType);
    }

    protected AST lookupProperty(AST dot, boolean root, boolean inSelect) throws SemanticException {
        if (this.error != null || !this.fromEnded) {
            return dot;
        }
        MqlDotNode dotNode = (MqlDotNode)dot;
        dotNode.processInExpression();
        return dot;
    }

    protected void resolve(AST node) throws SemanticException {
        if (this.error != null || !this.fromEnded) {
            return;
        }
        if (node.getType() == 120) {
            ((MqlIdentNode)node).resolve();
        }
    }

    protected void setAlias(AST selectExpr, AST ident) {
        if (this.error != null) {
            return;
        }
        MqlNode as = (MqlNode)ASTUtil.create(this.fact, 134, ident.getText());
        selectExpr.setNextSibling((AST)as);
        as.setText(" AS " + as.getText());
        this.currentContext.projectionLabelSearch.put(ident.getText(), (MqlNode)selectExpr);
    }

    protected AST generateNamedParameter(AST delimiterNode, AST nameNode) throws SemanticException {
        MqlNode para = (MqlNode)ASTUtil.create(this.fact, 142, nameNode.getText());
        para.setText("?");
        return para;
    }

    protected AST generatePositionalParameter(AST inputNode) throws SemanticException {
        return ASTUtil.create(this.fact, 117, "?");
    }

    void setParameterType(MqlNode param, MqlNode likewise) {
        String paramName = "param" + this.paramInfo.getFieldNames().size();
        FieldDefinition fd = DataDefinitionProvider.getInstance().makeFieldWithName(paramName, likewise.getMakType());
        param.setMakType(fd);
        this.paramInfo.addField(fd);
    }

    void setProjectionTypes(DataDefinition proj) {
        if (this.select == null) {
            return;
        }
        int i = 0;
        for (AST a = this.select.getFirstChild(); a != null; a = a.getNextSibling()) {
            FieldDefinition makType;
            if (a.getType() == 134) continue;
            String name = "col" + (i + 1);
            if (a.getNextSibling() != null && a.getNextSibling().getType() == 134) {
                name = ((MqlNode)a.getNextSibling()).getOriginalText();
            }
            if ((makType = ((MqlNode)a).getMakType()) == null) {
                throw new IllegalStateException("no type set for projection " + name + " " + MqlQueryAnalysis.showAst(a));
            }
            proj.addField(DataDefinitionProvider.getInstance().makeFieldWithName(name, makType));
            ++i;
        }
    }

    public boolean isAnalysisQuery() {
        if (this.select == null || this.select.getFirstChild() == null) {
            return false;
        }
        return this.select.getFirstChild().getNextSibling() == null && this.select.getFirstChild().getType() == 118;
    }
}

