/*
 * Decompiled with CFR 0.152.
 */
package net.mark_malakanov.sdg2;

import antlr.collections.AST;
import edu.usfca.syndiag.DefaultSyntaxDiagramGenerator;
import edu.usfca.syndiag.Draw;
import edu.usfca.syndiag.GrammarAST;
import edu.usfca.syndiag.SwingEngine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import net.mark_malakanov.sdg2.CanonicSyntaxDiagramGenerator;
import net.mark_malakanov.sdg2.SvgEngine;

public class DrawDemo
extends JPanel {
    AST t = null;
    SwingEngine swing;
    DefaultSyntaxDiagramGenerator diagramGen;
    Draw draw;

    public void init() {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.swing = new SwingEngine();
        this.diagramGen = new CanonicSyntaxDiagramGenerator(this.swing);
        this.draw = new Draw();
        this.draw.setDiagGen(this.diagramGen);
    }

    public void setDiagramStyle(String dg) {
        if (dg.equalsIgnoreCase("Heretical")) {
            this.diagramGen = new DefaultSyntaxDiagramGenerator(this.swing);
            this.draw.setDiagGen(this.diagramGen);
        } else if (dg.equalsIgnoreCase("Canonical")) {
            this.diagramGen = new CanonicSyntaxDiagramGenerator(this.swing);
            this.draw.setDiagGen(this.diagramGen);
        }
    }

    public void setAST(AST t) {
        this.t = t;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.getSize();
        g2.setBackground(this.getBackground());
        g2.setPaint(this.getBackground());
        g2.fillRect(0, 0, d.width, d.height);
        g2.setPaint(this.getForeground());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.swing == null) {
            return;
        }
        this.swing.setGraphics2D(g2);
        if (this.t == null) {
            return;
        }
        try {
            this.draw.grammar(this.t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int width = ((GrammarAST)this.t).getWidth();
        int height = ((GrammarAST)this.t).getHeight();
        this.setPreferredSize(new Dimension(width, height));
        this.revalidate();
    }

    public void paintSvg(String fileName) {
        int width = ((GrammarAST)this.t).getWidth();
        int height = ((GrammarAST)this.t).getHeight();
        SvgEngine svg = new SvgEngine();
        svg.setColor("black");
        svg.setBgColor("none");
        svg.setWriter(fileName);
        svg.beginDraw(new Rectangle(0, 0, width, height));
        DefaultSyntaxDiagramGenerator diagramGen = new DefaultSyntaxDiagramGenerator(svg);
        Draw draw = new Draw();
        draw.setDiagGen(diagramGen);
        if (this.t == null) {
            return;
        }
        try {
            draw.grammar(this.t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        svg.endDraw();
    }
}

