/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.eviction.SortedEvictionQueue;

public abstract class BaseSortedEvictionAlgorithm
extends BaseEvictionAlgorithm
implements EvictionAlgorithm {
    private static final Log log = LogFactory.getLog((Class)(class$org$jboss$cache$eviction$BaseSortedEvictionAlgorithm == null ? (class$org$jboss$cache$eviction$BaseSortedEvictionAlgorithm = BaseSortedEvictionAlgorithm.class$("org.jboss.cache.eviction.BaseSortedEvictionAlgorithm")) : class$org$jboss$cache$eviction$BaseSortedEvictionAlgorithm));
    static /* synthetic */ Class class$org$jboss$cache$eviction$BaseSortedEvictionAlgorithm;

    public void process(Region region) throws EvictionException {
        super.process(region);
    }

    protected void processQueues(Region region) throws EvictionException {
        EvictedEventNode node;
        boolean evictionNodesModified = false;
        int count = 0;
        block5: while ((node = region.takeLastEventNode()) != null) {
            int eventType = node.getEvent();
            Fqn fqn = node.getFqn();
            ++count;
            switch (eventType) {
                case 0: {
                    this.processAddedNodes(fqn);
                    evictionNodesModified = true;
                    continue block5;
                }
                case 1: {
                    this.processRemovedNodes(fqn);
                    continue block5;
                }
                case 2: {
                    this.processVisitedNodes(fqn);
                    evictionNodesModified = true;
                    continue block5;
                }
            }
            throw new RuntimeException("Illegal Eviction Event type " + eventType);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Eviction nodes visited or added requires resort of queue " + evictionNodesModified));
        }
        this.resortEvictionQueue(evictionNodesModified);
        if (log.isTraceEnabled()) {
            log.trace((Object)("processed " + count + " node events"));
        }
    }

    protected void resortEvictionQueue(boolean evictionQueueModified) {
        long begin = System.currentTimeMillis();
        ((SortedEvictionQueue)this.evictionQueue).resortEvictionQueue();
        long end = System.currentTimeMillis();
        if (log.isTraceEnabled()) {
            long diff = end - begin;
            log.trace((Object)("Took " + diff + "ms to sort queue with " + this.getEvictionQueue().size() + " elements"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

