/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class TLD2Forest {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Arguments needed: [path to the TLD file] [path to the output directory of XMLs]  (absolute paths");
        }
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(new File(args[0]));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element root = document.getRootElement();
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (!e.getName().equals("tag")) continue;
            Element name = e.element("name");
            String tagName = name.getText();
            Document tagXML = DocumentHelper.createDocument();
            Element docElement = tagXML.addElement("document");
            Element headerElement = docElement.addElement("header");
            Element titleElement = headerElement.addElement("title");
            titleElement.setText("mak:" + tagName + " tag documentation");
            Element bodyElement = docElement.addElement("body");
            bodyElement.addAttribute("id", "attributes");
            Element titleElement2 = bodyElement.addElement("title");
            titleElement2.setText("Attributes");
            tagXML.addDocType("document", "-//APACHE//DTD Documentation V2.0//EN", "http://forrest.apache.org/dtd/document-v20.dtd");
            String path = args[1] + File.separator + "mak" + tagName + ".xml";
            System.out.println("Writing XML for tag " + tagName + " at path " + path);
            try {
                XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(path)), new OutputFormat("  ", true));
                output.write(tagXML);
                output.close();
            }
            catch (IOException e1) {
                System.out.println(e1.getMessage());
            }
        }
    }
}

