/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.makumba.Attributes;
import org.makumba.CompositeValidationException;
import org.makumba.DataDefinition;
import org.makumba.Database;
import org.makumba.LogicException;
import org.makumba.LogicInvocationError;
import org.makumba.LogicNotFoundException;
import org.makumba.MakumbaError;
import org.makumba.Pointer;
import org.makumba.ProgrammerError;
import org.makumba.Transaction;
import org.makumba.UnauthenticatedException;
import org.makumba.UnauthorizedException;
import org.makumba.commons.ClassResource;
import org.makumba.commons.DbConnectionProvider;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.controller.MakumbaActorHashMap;
import org.makumba.providers.Configuration;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryAnalysisProvider;
import org.makumba.providers.QueryProvider;
import org.makumba.providers.TransactionProviderInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logic {
    static Properties controllerConfig;
    static URL controllerURL;
    static HashMap<String, Object> nameToObject;
    static Configuration configuration;
    private static final String HANDLER_METHOD_HEAD = "public void ";
    private static final String HANDLER_METHOD_END = " throws LogicException {}";
    private static DataDefinitionProvider ddp;
    static int logix;
    static int authConstraints;
    static String[] separators;
    static Class<?>[] argDb;
    static Class<?>[] editArgs;
    static Class<?>[] opArgs;
    static Class<?>[] noClassArgs;
    static Object[] noObjectArgs;
    static Class<?>[] deleteArgs;
    static Class<?>[] newArgs;

    public static String getSearchMessage(String cls) {
        return (String)((Hashtable)NamedResources.getStaticCache(logix).getSupplementary()).get(cls);
    }

    public static Object getController(String className) {
        if (nameToObject.get(className) == null) {
            try {
                Object controller = Class.forName(className).newInstance();
                nameToObject.put(className, controller);
                return controller;
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger("org.makumba.controller").log(Level.SEVERE, "Error while trying to load controller class " + className, e);
            }
            catch (InstantiationException e) {
                Logger.getLogger("org.makumba.controller").log(Level.SEVERE, "Error while trying to load controller class " + className, e);
            }
            catch (IllegalAccessException e) {
                Logger.getLogger("org.makumba.controller").log(Level.SEVERE, "Error while trying to load controller class " + className, e);
            }
        }
        return nameToObject.get(className);
    }

    public static String findPackageName(String directory) {
        String packageName = "";
        String defaultPackage = "";
        String longestKey = "";
        if (controllerConfig != null) {
            Enumeration<Object> e = controllerConfig.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                if (k.equals("default") && longestKey.length() == 0) {
                    defaultPackage = controllerConfig.getProperty(k);
                    continue;
                }
                if (!directory.startsWith(k) || k.length() <= longestKey.length()) continue;
                longestKey = k;
                packageName = controllerConfig.getProperty(k);
            }
            if (longestKey.length() == 0 && defaultPackage.length() > 0) {
                packageName = defaultPackage;
            }
        }
        return packageName;
    }

    public static Object getAuthorizationConstraint(String path) {
        return NamedResources.getStaticCache(authConstraints).getResource(path);
    }

    public static String upperCase(String a) {
        String ret = "";
        while (true) {
            int minimum = a.length();
            int imin = -1;
            for (int i = 0; i < separators.length; ++i) {
                int j = a.indexOf(separators[i]);
                if (j == -1 || j >= minimum) continue;
                minimum = j;
                imin = i;
            }
            ret = ret + Logic.firstUpper(a.substring(0, minimum));
            if (imin == -1) {
                return ret;
            }
            a = a.substring(minimum + separators[imin].length());
        }
    }

    static String firstUpper(String a) {
        char f = Character.toUpperCase(a.charAt(0));
        if (a.length() > 1) {
            return f + a.substring(1);
        }
        return "" + f;
    }

    public static Object getLogic(String path) {
        return NamedResources.getStaticCache(logix).getResource(path);
    }

    public static Object getAttribute(Object controller, String attname, Attributes a, String db, DbConnectionProvider dbcp) throws NoSuchMethodException, LogicException {
        if (attname.startsWith("actor_")) {
            return Logic.computeActor(attname, a, db, dbcp);
        }
        if (controller instanceof LogicNotFoundException) {
            throw new NoSuchMethodException("no controller=> no attribute method");
        }
        Method m = controller.getClass().getMethod("find" + Logic.firstUpper(attname), argDb);
        Transaction d = dbcp.getConnectionTo(db);
        Object[] args = new Object[]{a, d};
        try {
            return m.invoke(controller, args);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchMethodException(e.getMessage());
        }
        catch (InvocationTargetException f) {
            d.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            throw new LogicInvocationError(g);
        }
    }

    public static Object computeActor(String attname, Attributes a, String db, DbConnectionProvider dbcp) throws LogicException {
        Vector<Dictionary<String, Object>> v;
        String type = attname.substring(6).replace('_', '.');
        DataDefinition dd = ddp.getDataDefinition(type);
        String field = null;
        if (dd == null) {
            int lastDot = type.lastIndexOf(46);
            if (lastDot == -1) {
                throw new ProgrammerError("Unknown actor: " + type);
            }
            type = type.substring(0, lastDot);
            field = type.substring(lastDot + 1);
            dd = ddp.getDataDefinition(type);
            if (dd == null) {
                throw new ProgrammerError("Unknown actor: " + type + "." + field);
            }
        }
        DataDefinition.QueryFragmentFunction match = null;
        MakumbaActorHashMap matchValues = null;
        QueryAnalysisProvider qap = QueryProvider.getQueryAnalzyer(dbcp.getTransactionProvider().getQueryLanguage());
        block6: for (DataDefinition.QueryFragmentFunction f : dd.getActorFunctions()) {
            MakumbaActorHashMap values = new MakumbaActorHashMap();
            DataDefinition params = f.getParameters();
            if (match != null && match.getParameters().getFieldNames().size() > params.getFieldNames().size()) continue;
            for (String para : params.getFieldNames()) {
                try {
                    values.put(para, a.getAttribute(para));
                }
                catch (LogicException ae) {
                    continue block6;
                }
            }
            match = f;
            matchValues = values;
        }
        if (match == null) {
            if (dd.getActorFunctions().size() == 0) {
                throw new ProgrammerError("No fitting actor() function was found in " + type);
            }
            throw new UnauthenticatedException("Please provide username and password");
        }
        Logger.getLogger("org.makumba.db.query.inline").fine(match + " \n" + a);
        StringBuffer funcCall = new StringBuffer();
        funcCall.append("SELECT ").append(qap.getPrimaryKeyNotation("x")).append(" AS col1 FROM ").append(type).append(" x WHERE x.").append(match.getName());
        funcCall.append("(");
        String separator = "";
        DataDefinition params = match.getParameters();
        for (String para : params.getFieldNames()) {
            funcCall.append(separator);
            separator = ", ";
            funcCall.append(qap.getParameterSyntax()).append(para);
        }
        funcCall.append(")");
        Transaction connection = dbcp.getConnectionTo(db);
        try {
            v = connection.executeQuery(funcCall.toString(), matchValues);
        }
        catch (MakumbaError e) {
            throw new ProgrammerError("Error while computing actor " + attname + " during execution of query " + funcCall.toString() + " " + e.getMessage());
        }
        if (v.size() == 0) {
            if (match.getErrorMessage().trim().length() > 0) {
                throw new UnauthenticatedException(match.getErrorMessage().trim());
            }
            throw new UnauthenticatedException("Could not instantiate actor of type " + type);
        }
        if (v.size() > 1) {
            throw new LogicException("Multiple " + type + " objects fit the actor function " + match);
        }
        Pointer p = (Pointer)v.elementAt(0).get("col1");
        Dictionary<String, Object> obj = connection.read(p, null);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String att = Logic.actorPrefix(dd);
        ret.put(att, p);
        Enumeration<String> e = obj.keys();
        while (e.hasMoreElements()) {
            String k = e.nextElement();
            ret.put(att + "_" + k, obj.get(k));
        }
        HashMap<String, Pointer> param = new HashMap<String, Pointer>();
        param.put("x", p);
        for (DataDefinition.QueryFragmentFunction g : dd.getSessionFunctions()) {
            Object result;
            StringBuffer fc = new StringBuffer();
            fc.append("SELECT x.").append(g.getName()).append("()").append(" AS col1 FROM ").append(type).append(" x WHERE x=").append(qap.getParameterSyntax()).append("x");
            try {
                result = connection.executeQuery(fc.toString(), param).elementAt(0).get("col1");
            }
            catch (MakumbaError e2) {
                throw new ProgrammerError("Error while computing function " + g.getName() + " of actor " + attname + " during execution of query " + fc.toString() + " " + e2.getMessage());
            }
            ret.put(att + "_" + g.getName(), result);
            if (g.getSessionVariableName() == null) continue;
            ret.put(g.getSessionVariableName(), result);
        }
        return ret;
    }

    private static String actorPrefix(DataDefinition dd) {
        return "actor_" + dd.getName().replace(".", "_");
    }

    public static Set<String> logoutActor(DataDefinition dd) {
        HashSet<String> ret = new HashSet<String>();
        String att = Logic.actorPrefix(dd);
        ret.add(att);
        for (String s : dd.getFieldNames()) {
            ret.add(att + "_" + s);
        }
        for (DataDefinition.QueryFragmentFunction g : dd.getSessionFunctions()) {
            ret.add(att + "_" + g.getName());
        }
        return ret;
    }

    public static String getControllerFile(Object controller) {
        String ctrlClass = controller.getClass().getName();
        URL u = ClassResource.get(ctrlClass.replace('.', '/') + ".java");
        if (u != null) {
            return Logic.getFilePath(u);
        }
        return ClassResource.get(ctrlClass.replace('.', '/') + ".class").toString();
    }

    public static String getFilePath(URL u) {
        try {
            return new File(u.getFile()).getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new RuntimeWrappedException(ioe);
        }
    }

    public static Method getMethod(String name, Class<?>[] args, Object controller) {
        try {
            Method m = null;
            m = args != null ? controller.getClass().getMethod(name, args) : controller.getClass().getMethod(name, new Class[0]);
            if (!Modifier.isPublic(m.getModifiers())) {
                return null;
            }
            return m;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static void doInit(String path, Attributes a, String dbName, DbConnectionProvider dbcp) throws LogicException {
        Object o = Logic.getAuthorizationConstraint(path);
        if (!(o instanceof AuthorizationConstraint)) {
            return;
        }
        AuthorizationConstraint constraint = (AuthorizationConstraint)o;
        QueryAnalysisProvider qap = QueryProvider.getQueryAnalzyer(dbcp.getTransactionProvider().getQueryLanguage());
        Object result = null;
        if (constraint.fromWhere == null) {
            String q1;
            try {
                q1 = qap.inlineFunctions(constraint.rule).trim();
            }
            catch (MakumbaError e) {
                throw new ProgrammerError("Error while checking authorization constraint " + constraint.key + " during inlining of query " + constraint.rule + " " + e.getMessage());
            }
            if (q1.startsWith(qap.getParameterSyntax()) && q1.substring(1).matches("[a-zA-Z]\\w*")) {
                result = a.getAttribute(q1.substring(1));
            }
            if (result == null) {
                try {
                    result = Double.parseDouble(q1);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (result == null && q1.startsWith("(") && q1.endsWith(")")) {
                result = q1;
            }
        }
        if (result == null) {
            Vector<Dictionary<String, Object>> v;
            String query = "SELECT " + constraint.rule + " AS col1 ";
            if (constraint.fromWhere != null) {
                query = query + constraint.fromWhere;
            }
            query = qap.inlineFunctions(query);
            try {
                v = dbcp.getConnectionTo(dbName).executeQuery(query, null);
            }
            catch (MakumbaError e) {
                throw new ProgrammerError("Error while checking authorization constraint " + constraint.key + " during execution of query " + query + " " + e.getMessage());
            }
            if (v.size() > 1) {
                throw new ProgrammerError("Authorization constraint returned multiple values: " + constraint.key + "=" + constraint.value);
            }
            if (v.size() == 0) {
                throw new UnauthorizedException(constraint.message);
            }
            result = v.elementAt(0).get("col1");
        }
        if (result == null || result.equals(Pointer.Null) || result.equals(0) || result.equals(false)) {
            throw new UnauthorizedException(constraint.message);
        }
    }

    public static void doInit(Object controller, Attributes a, String dbName, DbConnectionProvider dbcp) throws LogicException {
        if (controller instanceof LogicNotFoundException) {
            return;
        }
        Transaction db = dbcp.getConnectionTo(dbName);
        Method init = Logic.getMethod("checkAttributes", argDb, controller);
        Method oldInit = Logic.getMethod("requiredAttributes", noClassArgs, controller);
        if (init == null && oldInit == null) {
            return;
        }
        if (init != null) {
            Object[] args = new Object[]{a, db};
            try {
                init.invoke(controller, args);
            }
            catch (IllegalAccessException g) {
                throw new LogicInvocationError(g);
            }
            catch (InvocationTargetException f) {
                db.rollback();
                Throwable g = f.getTargetException();
                if (g instanceof LogicException) {
                    throw (LogicException)g;
                }
                throw new LogicInvocationError(g);
            }
        }
        Logger.getLogger("org.makumba.controller").warning("requiredAttributes() is deprecated. Use checkAttributes(Attributes a, Database db) instead");
        Object attrs = null;
        try {
            attrs = oldInit.invoke(controller, noObjectArgs);
        }
        catch (IllegalAccessException g) {
            throw new LogicInvocationError(g);
        }
        catch (InvocationTargetException f) {
            db.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            throw new LogicInvocationError(g);
        }
        if (attrs == null) {
            return;
        }
        if (attrs instanceof String) {
            a.getAttribute((String)attrs);
            return;
        }
        if (attrs instanceof String[]) {
            for (int i = 0; i < ((String[])attrs).length; ++i) {
                a.getAttribute(((String[])attrs)[i]);
            }
            return;
        }
        return;
    }

    public static TransactionProviderInterface getTransactionProvider(Object controller) throws LogicInvocationError {
        Method connectionProvider = null;
        if (controller != null) {
            connectionProvider = Logic.getMethod("getTransactionProvider", null, controller);
        }
        String transactionProviderClass = null;
        try {
            if (connectionProvider != null) {
                transactionProviderClass = (String)connectionProvider.invoke(controller, new Object[0]);
            }
            if (transactionProviderClass == null) {
                transactionProviderClass = configuration.getDefaultTransactionProviderClass();
            }
            return (TransactionProviderInterface)Class.forName(transactionProviderClass).newInstance();
        }
        catch (Throwable e) {
            LogicException le = new LogicException("Could not instantiate transaction provider " + transactionProviderClass != null ? transactionProviderClass : "");
            throw new LogicInvocationError(le);
        }
    }

    public static Object doOp(Object controller, String opName, Dictionary<String, Object> data, Attributes a, String dbName, DbConnectionProvider dbcp) throws LogicException {
        if (opName == null) {
            return null;
        }
        if (controller instanceof LogicNotFoundException) {
            throw new ProgrammerError("there is no controller object to look for the Form handler method " + opName);
        }
        Transaction db = dbcp.getConnectionTo(dbName);
        Object[] editArg = new Object[]{data, a, db};
        Method op = null;
        op = Logic.getMethod(opName, opArgs, controller);
        if (op == null) {
            return null;
        }
        try {
            return op.invoke(controller, editArg);
        }
        catch (IllegalAccessException g) {
            throw new LogicInvocationError(g);
        }
        catch (InvocationTargetException f) {
            db.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            if (g instanceof CompositeValidationException) {
                throw (CompositeValidationException)g;
            }
            throw new LogicInvocationError(g);
        }
    }

    public static Pointer doEdit(Object controller, String handlerName, String afterHandlerName, String typename, Pointer p, Dictionary<String, Object> data, Attributes a, String dbName, DbConnectionProvider dbcp) throws LogicException {
        Transaction db = dbcp.getConnectionTo(dbName);
        Object[] editArg = new Object[]{p, data, a, db};
        Method edit = null;
        Method afterEdit = null;
        if (!(controller instanceof LogicNotFoundException)) {
            edit = Logic.getMethod(handlerName, editArgs, controller);
            afterEdit = Logic.getMethod(afterHandlerName, editArgs, controller);
        }
        try {
            if (edit != null) {
                edit.invoke(controller, editArg);
            }
            db.update(p, data);
            if (afterEdit != null) {
                afterEdit.invoke(controller, editArg);
            }
            return p;
        }
        catch (IllegalAccessException g) {
            throw new LogicInvocationError(g);
        }
        catch (InvocationTargetException f) {
            db.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            throw new LogicInvocationError(g);
        }
    }

    public static Pointer doDelete(Object controller, String typename, Pointer p, Attributes a, String dbName, DbConnectionProvider dbcp) throws LogicException {
        Transaction db = dbcp.getConnectionTo(dbName);
        Object[] deleteArg = new Object[]{p, a, db};
        Method delete2 = null;
        Method afterDelete = null;
        String upper = Logic.upperCase(typename);
        if (!(controller instanceof LogicNotFoundException)) {
            delete2 = Logic.getMethod("on_delete" + upper, deleteArgs, controller);
            afterDelete = Logic.getMethod("after_delete" + upper, deleteArgs, controller);
        }
        try {
            if (delete2 != null) {
                delete2.invoke(controller, deleteArg);
            }
            db.delete(p);
            if (afterDelete != null) {
                afterDelete.invoke(controller, deleteArg);
            }
            return null;
        }
        catch (IllegalAccessException g) {
            throw new LogicInvocationError(g);
        }
        catch (InvocationTargetException f) {
            db.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            throw new LogicInvocationError(g);
        }
    }

    public static Pointer doAdd(Object controller, String handlerName, String afterHandlerName, String typename, Pointer p, Dictionary<String, Object> data, Attributes a, String dbName, DbConnectionProvider dbcp) throws LogicException {
        Transaction db = dbcp.getConnectionTo(dbName);
        Object[] addArg = new Object[]{p, data, a, db};
        Method on = null;
        Method after = null;
        int n = typename.lastIndexOf("->");
        String field = typename.substring(n + 2);
        typename = typename.substring(0, n);
        if (!(controller instanceof LogicNotFoundException)) {
            on = Logic.getMethod(handlerName, editArgs, controller);
            after = Logic.getMethod(afterHandlerName, editArgs, controller);
        }
        try {
            if (on != null) {
                on.invoke(controller, addArg);
            }
            addArg[0] = db.insert(p, field, data);
            if (after != null) {
                after.invoke(controller, addArg);
            }
            return (Pointer)addArg[0];
        }
        catch (IllegalAccessException g) {
            throw new LogicInvocationError(g);
        }
        catch (InvocationTargetException f) {
            db.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            throw new LogicInvocationError(g);
        }
    }

    public static Pointer doNew(Object controller, String handlerName, String afterHandlerName, String typename, Dictionary<String, Object> data, Attributes a, String dbName, DbConnectionProvider dbcp) throws LogicException {
        Transaction db = dbcp.getConnectionTo(dbName);
        Object[] onArgs = new Object[]{data, a, db};
        Object[] afterArgs = new Object[]{null, data, a, db};
        Method on = null;
        Method after = null;
        if (!(controller instanceof LogicNotFoundException)) {
            on = Logic.getMethod(handlerName, newArgs, controller);
            after = Logic.getMethod(afterHandlerName, editArgs, controller);
        }
        try {
            if (on != null) {
                on.invoke(controller, onArgs);
            }
            afterArgs[0] = db.insert(typename, data);
            if (after != null) {
                after.invoke(controller, afterArgs);
            }
            return (Pointer)afterArgs[0];
        }
        catch (IllegalAccessException g) {
            throw new LogicInvocationError(g);
        }
        catch (InvocationTargetException f) {
            db.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            throw new LogicInvocationError(g);
        }
    }

    static {
        nameToObject = new HashMap();
        configuration = new Configuration();
        ddp = DataDefinitionProvider.getInstance();
        controllerConfig = new Properties();
        try {
            controllerURL = ClassResource.get("MakumbaController.properties");
            controllerConfig.load(controllerURL.openStream());
        }
        catch (Exception e) {
            controllerConfig = null;
        }
        logix = NamedResources.makeStaticCache("Business logic classes", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;
            {
                this.supplementary = new Hashtable();
            }

            protected Object makeResource(Object p) {
                String path = (String)p;
                String msg = "Searching for business logic for " + path + ":";
                String className = "";
                int n = path.lastIndexOf(".");
                if (n != -1) {
                    path = path.substring(0, n);
                }
                String defa = "";
                String maxKey = "";
                if (controllerConfig != null) {
                    msg = msg + "\nfollowing rules from MakumbaController.properties found at:\n\t" + Logic.getFilePath(controllerURL);
                    Enumeration<Object> e = controllerConfig.keys();
                    while (e.hasMoreElements()) {
                        String k = (String)e.nextElement();
                        if (k.equals("default") && maxKey.length() == 0) {
                            defa = controllerConfig.getProperty(k);
                            continue;
                        }
                        if (!path.startsWith(k) || k.length() <= maxKey.length()) continue;
                        maxKey = k;
                        className = controllerConfig.getProperty(k);
                        if (className.length() <= 0 || className.lastIndexOf(".") == className.length() - 1) continue;
                        className = className + ".";
                    }
                    if (maxKey.length() == 0 && defa.length() > 0) {
                        msg = msg + "\nfollowing default rule from MakumbaController.properties";
                        className = defa + ".";
                    } else if (maxKey.length() > 0) {
                        msg = msg + "\nfollowing rule based on longest matching key from MakumbaController.properties\n\tkey is: \"" + maxKey + "\"";
                    }
                    path = path.substring(maxKey.length());
                } else {
                    msg = msg + "\ncould not find MakumbaController.properties in CLASSPATH";
                }
                msg = msg + "\ndetermined base: \"" + className + "\"";
                StringTokenizer st = new StringTokenizer(path, "/");
                Object lastFound = null;
                String dir = " ";
                block5: while (true) {
                    String base = className;
                    for (int i = 1; i <= dir.length(); ++i) {
                        if (i != dir.length() && !Character.isUpperCase(dir.charAt(i))) continue;
                        className = base + dir.substring(0, i).trim();
                        try {
                            msg = msg + "\ntrying \"" + className + "Logic\"";
                            lastFound = Class.forName(className + "Logic").newInstance();
                            msg = msg + "... found.";
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            msg = msg + "... not found";
                            continue;
                        }
                        catch (IllegalAccessException f) {
                            msg = msg + "... no public constructor";
                            continue;
                        }
                        catch (InstantiationException f) {
                            msg = msg + "... abstract class";
                        }
                    }
                    while (st.hasMoreTokens()) {
                        dir = st.nextToken();
                        if (dir.length() == 0) continue;
                        dir = Logic.firstUpper(dir);
                        continue block5;
                    }
                    break;
                }
                if (lastFound == null) {
                    msg = msg + "\nNo matching class found for " + p + "!";
                    lastFound = new LogicNotFoundException(msg);
                } else {
                    msg = msg + "\nFound class " + lastFound.getClass().getName();
                }
                Logger.getLogger("org.makumba.controller").info(msg);
                ((Hashtable)this.supplementary).put(p, msg);
                Object foundClass = nameToObject.get(lastFound.getClass().getName());
                if (foundClass != null) {
                    return foundClass;
                }
                return lastFound;
            }
        }, false);
        authConstraints = NamedResources.makeStaticCache("Authorization constraints", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            protected Object makeResource(Object p) {
                if (controllerConfig == null) {
                    return "none";
                }
                String path = (String)p;
                int n = path.lastIndexOf(".");
                if (n != -1) {
                    path = path.substring(0, n);
                }
                String maxKey = "";
                String rule = "none";
                String params = "";
                Enumeration<Object> e = controllerConfig.keys();
                while (e.hasMoreElements()) {
                    String k1;
                    String k = (String)e.nextElement();
                    if (!k.startsWith("authorize%") || !path.startsWith(k1 = k.substring("authorize%".length())) || k1.length() <= maxKey.length()) continue;
                    maxKey = k1;
                    rule = controllerConfig.getProperty(k);
                }
                String originalRule = rule;
                if (rule.equals("none")) {
                    return rule;
                }
                AuthorizationConstraint ac = new AuthorizationConstraint();
                ac.key = maxKey;
                ac.value = rule;
                rule = rule.trim();
                params = "";
                int lpar = rule.indexOf("(");
                if (lpar == 0) {
                    int rpar = rule.indexOf(")");
                    if (rpar == -1) {
                        throw new ProgrammerError("Parameter list should end with ) in authorization constraint " + maxKey);
                    }
                    params = rule.substring(1, rpar);
                    rule = rule.substring(rpar + 1).trim();
                    if (params.trim().length() == 0) {
                        throw new ProgrammerError("Parameter list should not be empty in authorization constraint " + maxKey);
                    }
                }
                int ms = rule.indexOf("}");
                if (!rule.startsWith("{") || ms < 2) {
                    throw new ProgrammerError("body not found for authorization constraint " + maxKey);
                }
                ac.message = rule.substring(ms + 1);
                rule = rule.substring(1, ms);
                ac.rule = rule.trim();
                if (rule.trim().length() == 0) {
                    throw new ProgrammerError("empty body for authorization constraint " + maxKey);
                }
                if (params.length() > 0) {
                    QueryAnalysisProvider qap = QueryProvider.getQueryAnalzyer(Logic.getTransactionProvider(Logic.getLogic(path)).getQueryLanguage());
                    Map<String, DataDefinition> m = qap.getQueryAnalysis("SELECT 1 FROM " + params).getLabelTypes();
                    StringBuffer where = new StringBuffer();
                    String separator = "";
                    for (String label : m.keySet()) {
                        where.append(separator).append(label).append("=").append(qap.getParameterSyntax()).append(label);
                        separator = " AND ";
                    }
                    ac.fromWhere = " FROM " + params + " WHERE " + where;
                }
                ac.check();
                return ac;
            }
        }, false);
        separators = new String[]{".", "->"};
        argDb = new Class[]{Attributes.class, Database.class};
        editArgs = new Class[]{Pointer.class, Dictionary.class, Attributes.class, Database.class};
        opArgs = new Class[]{Dictionary.class, Attributes.class, Database.class};
        noClassArgs = new Class[0];
        noObjectArgs = new Object[0];
        deleteArgs = new Class[]{Pointer.class, Attributes.class, Database.class};
        newArgs = new Class[]{Dictionary.class, Attributes.class, Database.class};
    }

    static class AuthorizationConstraint {
        String key;
        String value;
        String rule;
        String fromWhere;
        String message;

        AuthorizationConstraint() {
        }

        void check() {
            if (this.message == null || this.message.length() == 0) {
                this.message = "Authorization constraint failed: " + this.key + "= " + this.value;
            }
        }
    }
}

