/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.makumba.commons.ClassResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Serializable {
    public static final String PLACEHOLDER_CONTEXT_PATH = "_CONTEXT_PATH_";
    public static String defaultClientSideValidation = "live";
    public static boolean defaultReloadFormOnError = true;
    private static final long serialVersionUID = 1L;
    private static final String defaultDataDefinitionProvider = "org.makumba.providers.datadefinition.makumba.MakumbaDataDefinitionFactory";
    private String defaultTransactionProvider = "org.makumba.db.makumba.MakumbaTransactionProvider";
    private static Properties controllerConfig;
    private static final String KEY_CALENDAR_EDITOR = "calendarEditor";
    private static final String KEY_CALENDAR_EDITOR_LINK = "calendarEditorLink";
    public static final String KEY_MDD_VIEWER = "mddViewer";
    public static final String KEY_BL_METHODS = "blMethods";
    public static final String KEY_JAVA_VIEWER = "javaViewer";
    private static final String KEY_LOGIC_DISCOVERY = "logicDiscovery";
    private static final String KEY_CODE_GENERATOR = "codeGenerator";
    public static final String KEY_DATA_QUERY_TOOL = "dataQueryTool";
    private static final String KEY_DATA_OBJECT_VIEWER = "dataObjectViewer";
    public static final String KEY_DATA_LISTER = "dataLister";
    public static final String KEY_OBJECT_ID_CONVERTER = "objectIdConverter";
    public static final String KEY_REFERENCE_CHECKER = "referenceChecker";
    private static final String KEY_REPOSITORY_URL = "repositoryURL";
    private static final String KEY_REPOSITORY_LINK_TEXT = "repositoryLinkText";
    private static final String KEY_MAKUMBA_VALUE_EDITOR = "makumbaValueEditor";
    private static final String KEY_MAKUMBA_UNIQUENESS_VALIDATOR = "makumbaUniquenessValidator";
    private static final String KEY_MAKUMBA_RESOURCES = "makumbaResources";
    private static final String KEY_MAKUMBA_DOWNLOAD = "makumbaDownload";
    private static Properties makumbaDefaults;
    private static final Hashtable<String, String> allGenericDeveloperToolsMap;
    private String dataDefinitionProvider = null;

    public static Hashtable<String, String> getAllGenericDeveloperToolsMap() {
        return allGenericDeveloperToolsMap;
    }

    public Configuration() {
        if (controllerConfig != null) {
            this.defaultTransactionProvider = controllerConfig.getProperty("defaultTransactionProvider", this.defaultTransactionProvider);
        }
    }

    private String getDefaultDataDefinitionProviderClass() {
        return defaultDataDefinitionProvider;
    }

    public String getDataDefinitionProviderClass() {
        return this.dataDefinitionProvider == null ? this.getDefaultDataDefinitionProviderClass() : this.dataDefinitionProvider;
    }

    public String getDefaultTransactionProviderClass() {
        return this.defaultTransactionProvider;
    }

    public void setDataDefinitionProvider(String ddp) {
        this.dataDefinitionProvider = ddp;
    }

    public void setDefaultTransactionProvider(String defaultTransactionProvider) {
        this.defaultTransactionProvider = defaultTransactionProvider;
    }

    public static String getClientSideValidationDefault() {
        return defaultClientSideValidation;
    }

    public static boolean getReloadFormOnErrorDefault() {
        return defaultReloadFormOnError;
    }

    public static boolean getCalendarEditorDefault() {
        return makumbaDefaults.getProperty(KEY_CALENDAR_EDITOR).equals("true");
    }

    public static String getDefaultCalendarEditorLink(String contextPath) {
        return makumbaDefaults.getProperty(KEY_CALENDAR_EDITOR_LINK).replaceAll(PLACEHOLDER_CONTEXT_PATH, contextPath);
    }

    public static String getMddViewerLocation() {
        return makumbaDefaults.getProperty(KEY_MDD_VIEWER);
    }

    public static String getBLMethodsLocation() {
        return makumbaDefaults.getProperty(KEY_BL_METHODS);
    }

    public static String getJavaViewerLocation() {
        return makumbaDefaults.getProperty(KEY_JAVA_VIEWER);
    }

    public static String getLogicDiscoveryViewerLocation() {
        return makumbaDefaults.getProperty(KEY_LOGIC_DISCOVERY);
    }

    public static String getDataViewerLocation() {
        return makumbaDefaults.getProperty(KEY_DATA_OBJECT_VIEWER);
    }

    public static String getDataListerLocation() {
        return makumbaDefaults.getProperty(KEY_DATA_LISTER);
    }

    public static String getDataQueryLocation() {
        return makumbaDefaults.getProperty(KEY_DATA_QUERY_TOOL);
    }

    public static String getObjectIdConverterLocation() {
        return makumbaDefaults.getProperty(KEY_OBJECT_ID_CONVERTER);
    }

    public static String getReferenceCheckerLocation() {
        return makumbaDefaults.getProperty(KEY_REFERENCE_CHECKER);
    }

    public static String getCodeGeneratorLocation() {
        return makumbaDefaults.getProperty(KEY_CODE_GENERATOR);
    }

    public static String getRepositoryURL() {
        return makumbaDefaults.getProperty(KEY_REPOSITORY_URL);
    }

    public static String getRepositoryLinkText() {
        return makumbaDefaults.getProperty(KEY_REPOSITORY_LINK_TEXT);
    }

    public static String getMakumbaValueEditorLocation() {
        return makumbaDefaults.getProperty(KEY_MAKUMBA_VALUE_EDITOR);
    }

    public static String getMakumbaUniqueLocation() {
        return makumbaDefaults.getProperty(KEY_MAKUMBA_UNIQUENESS_VALIDATOR);
    }

    public static String getMakumbaResourcesLocation() {
        return makumbaDefaults.getProperty(KEY_MAKUMBA_RESOURCES);
    }

    public static String getMakumbaDownloadLocation() {
        return makumbaDefaults.getProperty(KEY_MAKUMBA_DOWNLOAD);
    }

    public static String getConfigProperty(String key) {
        return makumbaDefaults.getProperty(key);
    }

    static {
        makumbaDefaults = new Properties();
        allGenericDeveloperToolsMap = new Hashtable();
        controllerConfig = new Properties();
        try {
            URL controllerURL = ClassResource.get("MakumbaController.properties");
            controllerConfig.load(controllerURL.openStream());
            defaultClientSideValidation = controllerConfig.getProperty("defaultClientSideValidation", defaultClientSideValidation);
            defaultReloadFormOnError = Boolean.parseBoolean(controllerConfig.getProperty("defaultReloadFormOnError", String.valueOf(defaultReloadFormOnError)));
        }
        catch (Exception e) {
            controllerConfig = null;
        }
        try {
            URL urlMakumbaDefaults = ClassResource.get("internalDefaultMakumbaDefaults.properties");
            makumbaDefaults.load(urlMakumbaDefaults.openStream());
            Properties appMakumbaDefaults = new Properties();
            URL urlAppMakumbaDefaults = ClassResource.get("MakumbaDefaults.properties");
            if (urlAppMakumbaDefaults != null) {
                appMakumbaDefaults.load(urlAppMakumbaDefaults.openStream());
                for (Object keyObject : makumbaDefaults.keySet()) {
                    String key = (String)keyObject;
                    if (!StringUtils.isNotBlank((String)appMakumbaDefaults.getProperty(key))) continue;
                    makumbaDefaults.setProperty(key, appMakumbaDefaults.getProperty(key));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        allGenericDeveloperToolsMap.put(KEY_MDD_VIEWER, "Mdd viewer");
        allGenericDeveloperToolsMap.put(KEY_JAVA_VIEWER, "Business logics viewer");
        allGenericDeveloperToolsMap.put(KEY_DATA_LISTER, "Data browser");
        allGenericDeveloperToolsMap.put(KEY_DATA_QUERY_TOOL, "Data query");
        allGenericDeveloperToolsMap.put(KEY_OBJECT_ID_CONVERTER, "Pointer value converter");
        allGenericDeveloperToolsMap.put(KEY_REFERENCE_CHECKER, "Reference checker");
    }
}

