/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;

public class TLD2Forest {
    static final String EXAMPLES_FOLDER = "examples";
    static final String TAGS_FOLDER = "tags";
    static final int CREATE = 1;
    static final int UPDATE = 2;
    static final String EXAMPLE_SECTION_ID = "example";

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Arguments needed: [path to the TLD file] [path to the output directory of XMLs]  (absolute paths");
        }
        String tldFilePath = args[0];
        String outputDirectory = args[1];
        int action = 1;
        if (args.length == 3) {
            String s = args[2];
            try {
                int parsedAction = Integer.parseInt(s);
                if (!s.equals("create") && !s.equals("update") && parsedAction != 1 && parsedAction != 2) {
                    System.err.println("args[2] must be 'create', 'update', '1' or '2'");
                    return;
                }
                action = s.equals("create") ? 1 : (s.equals("update") ? 2 : parsedAction);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("continuing with creating new files");
            }
        }
        switch (action) {
            case 1: {
                System.out.println("doing STEP 1");
                TLD2Forest.generateAllTagFiles(tldFilePath, outputDirectory);
                TLD2Forest.generateAllTagExampleFiles(tldFilePath, outputDirectory);
                break;
            }
            case 2: {
                System.out.println("doing STEP 2");
                TLD2Forest.generateAllTagsWithExampleFile2(tldFilePath, outputDirectory);
                break;
            }
        }
    }

    public static void generateAllTagFiles(String tldFileDirectory, String outputDirectory) {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(new File(tldFileDirectory));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element root = document.getRootElement();
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (!e.getName().equals("tag")) continue;
            TLD2Forest.generateTagFile(outputDirectory, e);
        }
    }

    public static void generateAllTagExampleFiles(String tldFileDirectory, String outputDirectory) {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(new File(tldFileDirectory));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element root = document.getRootElement();
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (!e.getName().equals("tag")) continue;
            TLD2Forest.generateTagExampleFile(outputDirectory, e.elementText("name"));
        }
    }

    public static String generateTagFile(String outputDirectory, Element tag) {
        String tagName = tag.elementText("name");
        String tagFilePath = outputDirectory + File.separator + TAGS_FOLDER + File.separator + "mak" + tagName + ".xml";
        System.out.println("TLD2Forest.generateTagFile(): file name -" + tagFilePath);
        Document tagXML = DocumentHelper.createDocument();
        Element docElement = tagXML.addElement("document");
        Element headerElement = docElement.addElement("header");
        Element titleElement = headerElement.addElement("title");
        titleElement.setText("mak:" + tagName + " tag documentation");
        Element bodyElement = docElement.addElement("body");
        Element sectionElement = bodyElement.addElement("section");
        sectionElement.addAttribute("id", "attributes");
        Element titleElement2 = sectionElement.addElement("title");
        titleElement2.setText("Attributes");
        Element table = sectionElement.addElement("table");
        Element headerRow = table.addElement("tr");
        Element nameTh = headerRow.addElement("th");
        nameTh.setText("Name");
        Element requiredTh = headerRow.addElement("th");
        requiredTh.setText("Required");
        Element rtexprvalueTh = headerRow.addElement("th");
        rtexprvalueTh.setText("rt expression value");
        Element descriptionTh = headerRow.addElement("th");
        descriptionTh.setText("Description");
        String[] attributeTags = new String[]{"name", "required", "rtexprvalue", "description"};
        Iterator tagElementIter = tag.elementIterator();
        while (tagElementIter.hasNext()) {
            Element tagElement = (Element)tagElementIter.next();
            if (!tagElement.getName().equals("attribute")) continue;
            int cellAddedCount = 0;
            Element tr = table.addElement("tr");
            Iterator tagElementAttributeIter = tagElement.elementIterator();
            while (tagElementAttributeIter.hasNext()) {
                Element dataElement = (Element)tagElementAttributeIter.next();
                String tagElementAttributeName = dataElement.getName();
                for (String attributeName : attributeTags) {
                    if (!tagElementAttributeName.equals(attributeName)) continue;
                    String elementText = dataElement.getText();
                    elementText = elementText != null ? elementText : "";
                    Element td = tr.addElement("td");
                    td.setText(elementText);
                    ++cellAddedCount;
                }
            }
            for (int j = cellAddedCount; j < attributeTags.length; ++j) {
                Element td = tr.addElement("td");
                td.setText("");
            }
        }
        Element exampleSection = bodyElement.addElement("section");
        exampleSection.addAttribute("id", EXAMPLE_SECTION_ID);
        exampleSection.addElement("title");
        tagXML.addDocType("document", "-//APACHE//DTD Documentation V2.0//EN", "http://forrest.apache.org/dtd/document-v20.dtd");
        System.out.println("Writing XML for tag " + tagName + " at path " + tagFilePath);
        try {
            boolean success;
            String tagsDir = outputDirectory + File.separator + TAGS_FOLDER;
            if (!new File(tagsDir).exists() && (success = new File(tagsDir).mkdir())) {
                System.out.println("Directory: " + tagsDir + " created");
            }
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(tagFilePath)), new OutputFormat("  ", true));
            output.write(tagXML);
            output.close();
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
        return tagFilePath;
    }

    public static String generateTagExampleFile(String outputDirectory, String tagName) {
        String exampleFilePath = outputDirectory + File.separator + EXAMPLES_FOLDER + File.separator + "mak" + tagName + "Example" + ".xml";
        File f = new File(exampleFilePath);
        if (!f.exists()) {
            Document exampleXML = DocumentHelper.createDocument();
            Element exampleSection = exampleXML.addElement("section");
            exampleSection.addAttribute("id", EXAMPLE_SECTION_ID);
            Element exampleTitle = exampleSection.addElement("title");
            exampleTitle.setText("Example");
            Element exampleTextParagraph = exampleSection.addElement("p");
            exampleTextParagraph.setText("");
            Element exampleCodeParagraph = exampleSection.addElement("p");
            Element exampleCode = exampleCodeParagraph.addElement("code");
            exampleCode.setText("");
            try {
                boolean success;
                String exampleDir = outputDirectory + File.separator + EXAMPLES_FOLDER;
                if (!new File(exampleDir).exists() && (success = new File(exampleDir).mkdir())) {
                    System.out.println("Directory: " + exampleDir + " created");
                }
                XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(exampleFilePath)), new OutputFormat("  ", true));
                output.write(exampleXML);
                output.close();
            }
            catch (IOException e1) {
                System.out.println(e1.getMessage());
            }
        }
        return exampleFilePath;
    }

    public static String generateAllTagsWithExampleFile2(String tldFilePath, String outputDirectory) {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(new File(tldFilePath));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element root = document.getRootElement();
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (!e.getName().equals("tag")) continue;
            TLD2Forest.generateTagWithExampleFile(outputDirectory, e);
        }
        return null;
    }

    public static void generateTagWithExampleFile(String outputDirectory, Element tag) {
        String tagName = tag.elementText("name");
        SAXReader saxReader = new SAXReader();
        String tagsDir = outputDirectory + File.separator + TAGS_FOLDER;
        String tagFileName = "mak" + tagName + ".xml";
        String tagFilePath = tagsDir + File.separator + tagFileName;
        String exampleDir = outputDirectory + File.separator + EXAMPLES_FOLDER;
        String exampleFileName = "mak" + tagName + "Example" + ".xml";
        String exampleFilePath = exampleDir + File.separator + exampleFileName;
        String tagWithExampleFilePath = outputDirectory + File.separator + tagFileName;
        File exampleFile = new File(exampleFilePath);
        if (exampleFile.exists()) {
            try {
                Document exampleXML = saxReader.read(exampleFile);
                DefaultElement exampleSection = (DefaultElement)exampleXML.getRootElement().selectObject("//section");
                Document tagXML = saxReader.read(new File(tagFilePath));
                Element tagRoot = tagXML.getRootElement();
                Element tagExampleSection = null;
                List l = (List)tagRoot.selectObject("//document//body//section");
                if (l.size() > 0) {
                    for (Element el : l) {
                        if (!EXAMPLE_SECTION_ID.equals(el.attributeValue("id"))) continue;
                        System.out.println("writing file " + tagWithExampleFilePath);
                        tagExampleSection = el;
                        Element parent = tagExampleSection.getParent();
                        parent.remove(tagExampleSection);
                        parent.add((Element)exampleSection);
                        XMLWriter writer = new XMLWriter((Writer)new FileWriter(new File(tagWithExampleFilePath)), new OutputFormat("  ", true));
                        writer.write(tagXML);
                        writer.close();
                    }
                    if (tagExampleSection == null) {
                        System.err.println("There was no section with ID=example");
                    }
                } else {
                    System.err.println("Couldn't find elementById example from file " + tagFilePath);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

