/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.hibernate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.hibernate.cfg.Configuration;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.commons.NameResolver;
import org.makumba.providers.DataDefinitionProvider;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MddToMapping {
    private Set<String> mddsDone = new HashSet<String>();
    private LinkedList<DataDefinition> mddsToDo = new LinkedList();
    private String generatedMappingPath = "";
    private String prefix = "";
    private DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
    private NameResolver nr;
    SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    Set takenColumnNames;
    Map columnNames;

    public MddToMapping(Vector v, Configuration cfg, String generationPath, String prefix, NameResolver nr) throws TransformerConfigurationException, SAXException {
        this.managePaths(generationPath, prefix);
        this.nr = nr;
        for (int i = 0; i < v.size(); ++i) {
            this.generateMapping(this.ddp.getDataDefinition((String)v.elementAt(i)), cfg);
        }
        while (!this.mddsToDo.isEmpty()) {
            this.generateMapping(this.mddsToDo.removeFirst(), cfg);
        }
    }

    public MddToMapping(DataDefinition dd, Configuration cfg, String generationPath, String prefix) throws TransformerConfigurationException, SAXException {
        this.managePaths(generationPath, prefix);
        this.generatedMappingPath = generationPath;
        this.generateMapping(dd, cfg);
        while (!this.mddsToDo.isEmpty()) {
            this.generateMapping(this.mddsToDo.removeFirst(), cfg);
        }
    }

    private void managePaths(String generationPath, String prefix) {
        this.generatedMappingPath = generationPath + File.separator + prefix;
        this.prefix = prefix;
        new File(this.generatedMappingPath).mkdirs();
    }

    public void generateMapping(DataDefinition dd, Configuration cfg) throws TransformerConfigurationException, SAXException {
        if (this.mddsDone.contains(dd.getName())) {
            return;
        }
        this.mddsDone.add(dd.getName());
        this.takenColumnNames = new HashSet();
        this.columnNames = new HashMap();
        String filename = this.nr.arrowToDoubleUnderscore(dd.getName()) + ".hbm.xml";
        FileWriter w = null;
        try {
            w = new FileWriter(this.generatedMappingPath + File.separator + filename);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        StreamResult streamResult = new StreamResult(w);
        TransformerHandler hd = this.tf.newTransformerHandler();
        Transformer serializer = hd.getTransformer();
        serializer.setOutputProperty("doctype-public", "-//Hibernate/Hibernate Mapping DTD 3.0//EN");
        serializer.setOutputProperty("doctype-system", "http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd");
        serializer.setOutputProperty("indent", "yes");
        hd.setResult(streamResult);
        hd.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "auto-import", "", "false");
        hd.startElement("", "", "hibernate-mapping", atts);
        atts.clear();
        atts.addAttribute("", "", "name", "", this.nr.arrowToDoubleUnderscore(dd.getName()));
        atts.addAttribute("", "", "table", "", this.nr.resolveTypeName(dd));
        hd.startElement("", "", "class", atts);
        block19: for (int i = 0; i < dd.getFieldNames().size(); ++i) {
            FieldDefinition fd = dd.getFieldDefinition(i);
            atts.clear();
            switch (fd.getIntegerType()) {
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 15: {
                    atts.addAttribute("", "", "name", "", this.nr.checkReserved(fd.getName()));
                    atts.addAttribute("", "", "column", "", this.columnName(dd, fd.getName()));
                    hd.startElement("", "", "property", atts);
                    hd.endElement("", "", "property");
                    continue block19;
                }
                case 6: {
                    atts.addAttribute("", "", "name", "", this.nr.checkReserved(fd.getName()));
                    hd.startElement("", "", "property", atts);
                    atts.clear();
                    atts.addAttribute("", "", "name", "", this.columnName(dd, fd.getName()));
                    atts.addAttribute("", "", "length", "", String.valueOf(fd.getWidth()));
                    hd.startElement("", "", "column", atts);
                    hd.endElement("", "", "column");
                    hd.endElement("", "", "property");
                    continue block19;
                }
                case 0: {
                    atts.addAttribute("", "", "name", "", this.nr.checkReserved(fd.getName()));
                    atts.addAttribute("", "", "column", "", this.columnName(dd, fd.getName()));
                    atts.addAttribute("", "", "cascade", "", "all");
                    atts.addAttribute("", "", "class", "", this.nr.arrowToDoubleUnderscore(fd.getPointedType().getName()));
                    hd.startElement("", "", "many-to-one", atts);
                    hd.endElement("", "", "many-to-one");
                    this.mddsToDo.add(fd.getPointedType());
                    continue block19;
                }
                case 2: {
                    atts.addAttribute("", "", "name", "", this.nr.checkReserved(fd.getName()));
                    atts.addAttribute("", "", "column", "", this.columnName(dd, fd.getName()));
                    atts.addAttribute("", "", "cascade", "", "all");
                    atts.addAttribute("", "", "unique", "", "true");
                    hd.startElement("", "", "many-to-one", atts);
                    hd.endElement("", "", "many-to-one");
                    this.mddsToDo.add(fd.getPointedType());
                    continue block19;
                }
                case 3: {
                    atts.addAttribute("", "", "name", "", "primaryKey");
                    atts.addAttribute("", "", "column", "", this.nr.resolveFieldName(dd, fd.getName()));
                    hd.startElement("", "", "id", atts);
                    atts.clear();
                    atts.addAttribute("", "", "class", "", "identity");
                    hd.startElement("", "", "generator", atts);
                    hd.endElement("", "", "generator");
                    hd.endElement("", "", "id");
                    continue block19;
                }
                case 8: {
                    atts.addAttribute("", "", "name", "", this.nr.checkReserved(fd.getName()));
                    atts.addAttribute("", "", "type", "", "org.makumba.db.hibernate.TextUserType");
                    hd.startElement("", "", "property", atts);
                    atts.clear();
                    atts.addAttribute("", "", "name", "", this.columnName(dd, fd.getName()));
                    atts.addAttribute("", "", "sql-type", "", "longtext");
                    hd.startElement("", "", "column", atts);
                    hd.endElement("", "", "column");
                    hd.endElement("", "", "property");
                    continue block19;
                }
                case 18: {
                    atts.addAttribute("", "", "name", "", this.nr.checkReserved(fd.getName()));
                    atts.addAttribute("", "", "type", "", "org.makumba.db.hibernate.TextUserType");
                    hd.startElement("", "", "property", atts);
                    atts.clear();
                    atts.addAttribute("", "", "name", "", this.columnName(dd, fd.getName()));
                    atts.addAttribute("", "", "sql-type", "", "longblob");
                    hd.startElement("", "", "column", atts);
                    hd.endElement("", "", "column");
                    hd.endElement("", "", "property");
                    continue block19;
                }
                case 19: {
                    atts.addAttribute("", "", "name", "", this.nr.checkReserved(fd.getName()));
                    hd.startElement("", "", "property", atts);
                    atts.clear();
                    atts.addAttribute("", "", "name", "", this.columnName(dd, fd.getName()));
                    hd.startElement("", "", "column", atts);
                    hd.endElement("", "", "column");
                    hd.endElement("", "", "property");
                    continue block19;
                }
                case 12: {
                    atts.addAttribute("", "", "name", "", this.nr.checkReserved(fd.getName()));
                    atts.addAttribute("", "", "table", "", this.nr.resolveTypeName(fd.getSubtable()));
                    atts.addAttribute("", "", "cascade", "", "all");
                    atts.addAttribute("", "", "inverse", "", "false");
                    hd.startElement("", "", "bag", atts);
                    atts.clear();
                    atts.addAttribute("", "", "column", "", this.columnName(dd, dd.getIndexPointerFieldName()));
                    hd.startElement("", "", "key", atts);
                    hd.endElement("", "", "key");
                    atts.clear();
                    atts.addAttribute("", "", "class", "", this.nr.arrowToDoubleUnderscore(fd.getPointedType().getName()));
                    DataDefinition set = fd.getSubtable();
                    atts.addAttribute("", "", "column", "", this.columnName(set, set.getSetMemberFieldName()));
                    hd.startElement("", "", "many-to-many", atts);
                    hd.endElement("", "", "many-to-many");
                    hd.endElement("", "", "bag");
                    this.mddsToDo.add(fd.getPointedType());
                    this.mddsToDo.add(set);
                    continue block19;
                }
                case 13: 
                case 16: 
                case 17: {
                    atts.addAttribute("", "", "name", "", this.nr.checkReserved(fd.getName()));
                    atts.addAttribute("", "", "inverse", "", "true");
                    atts.addAttribute("", "", "cascade", "", "none");
                    hd.startElement("", "", "bag", atts);
                    atts.clear();
                    atts.addAttribute("", "", "column", "", this.columnName(dd, dd.getIndexPointerFieldName()));
                    hd.startElement("", "", "key", atts);
                    hd.endElement("", "", "key");
                    atts.clear();
                    atts.addAttribute("", "", "class", "", this.nr.arrowToDoubleUnderscore(fd.getPointedType().getName()));
                    hd.startElement("", "", "one-to-many", atts);
                    hd.endElement("", "", "one-to-many");
                    hd.endElement("", "", "bag");
                    this.mddsToDo.add(fd.getSubtable());
                    continue block19;
                }
                case 1: {
                    atts.clear();
                    atts.addAttribute("", "", "name", "", this.nr.checkReserved(fd.getName()));
                    atts.addAttribute("", "", "column", "", this.columnName(dd, fd.getName()));
                    atts.addAttribute("", "", "class", "", this.nr.arrowToDoubleUnderscore(fd.getPointedType().getName()));
                    hd.startElement("", "", "many-to-one", atts);
                    hd.endElement("", "", "many-to-one");
                    continue block19;
                }
                default: {
                    try {
                        throw new Exception("Unmapped type: " + fd.getName() + "-" + fd.getType());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        hd.endElement("", "", "class");
        hd.endElement("", "", "hibernate-mapping");
        hd.endDocument();
        try {
            ((Writer)w).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        cfg.addResource(this.prefix + File.separator + filename);
    }

    private String columnName(DataDefinition dd, String name) {
        return this.nr.resolveFieldName(dd, name);
    }
}

