/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel.relations;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.commons.FileUtils;
import org.makumba.commons.NamedResources;
import org.makumba.commons.ReadableFormatter;
import org.makumba.devel.relations.RelationCrawler;
import org.makumba.providers.TransactionProvider;
import org.makumba.providers.datadefinition.makumba.RecordInfo;

public class RelationCrawlerTool
extends HttpServlet {
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String webappRoot = req.getSession().getServletContext().getRealPath("/");
        if (webappRoot.endsWith("/")) {
            webappRoot = webappRoot.substring(0, webappRoot.length() - 1);
        }
        RelationCrawler rc = RelationCrawler.getRelationCrawler(webappRoot, TransactionProvider.getInstance().getDefaultDataSourceName(), false, "file://", req.getContextPath().startsWith("/") ? req.getContextPath() : "root", false);
        Date beginDate = new Date();
        Logger.getLogger("org.makumba.devel.relations").info("\nCrawling starts at " + beginDate + "\n");
        ArrayList<String> allFilesInDirectory = FileUtils.getAllFilesInDirectory(webappRoot, new String[0], new RelationCrawler.MakumbaRelatedFileFilter());
        Collections.sort(allFilesInDirectory);
        String[] files = allFilesInDirectory.toArray(new String[allFilesInDirectory.size()]);
        RecordInfo.setWebappRoot(webappRoot);
        for (int i = 0; i < files.length; ++i) {
            rc.crawl(files[i]);
        }
        RecordInfo.setWebappRoot(null);
        NamedResources.cleanStaticCache(RecordInfo.infos);
        Logger.getLogger("org.makumba.devel.relations").info("\n\nCrawling finished, took: " + ReadableFormatter.readableAge(System.currentTimeMillis() - beginDate.getTime()));
        RelationCrawler.writeJSPAnalysisError(webappRoot + File.separator + "analysis-errors.txt", rc.getJSPAnalysisErrors(), rc.getJSPCrawlCount());
        Logger.getLogger("org.makumba.devel.relations").info("\n\nWriting to database finished, total time: " + ReadableFormatter.readableAge(System.currentTimeMillis() - beginDate.getTime()));
        rc.writeRelationsToDb();
        resp.sendRedirect(req.getHeader("referer"));
    }
}

