/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.makumba;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.NoSuchFieldException;
import org.makumba.ValidationDefinition;
import org.makumba.ValidationRule;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.providers.datadefinition.makumba.FieldInfo;
import org.makumba.providers.datadefinition.makumba.RecordParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordInfo
implements Serializable,
DataDefinition,
ValidationDefinition {
    private static final long serialVersionUID = 1L;
    protected static String webappRoot;
    URL origin;
    String name;
    Properties templateValues;
    Vector<String> fieldOrder = new Vector();
    HashMap<String, DataDefinition.QueryFragmentFunction> functionNames = new HashMap();
    String title;
    String indexName;
    static final String createName = "TS_create";
    static final String modifyName = "TS_modify";
    String mainPtr;
    String setField;
    int relations = 0;
    HashMap<String, FieldDefinition> fields = new HashMap();
    String subfield;
    String ptrSubfield = "";
    String subfieldPtr = "";
    RecordInfo papa;
    private HashMap<String, ValidationRule> validationRuleNames = new HashMap();
    private HashMap<Object, DataDefinition.MultipleUniqueKeyDefinition> multiFieldUniqueList = new HashMap();
    public static int infos;

    public static void setWebappRoot(String s) {
        webappRoot = s;
    }

    void addStandardFields(String name) {
        this.indexName = name;
        FieldInfo fi = new FieldInfo(this, this.indexName);
        fi.type = "ptrIndex";
        fi.description = "Unique index";
        fi.fixed = true;
        fi.notNull = true;
        fi.unique = true;
        this.addField1(fi);
        fi = new FieldInfo(this, modifyName);
        fi.type = "dateModify";
        fi.notNull = true;
        fi.description = "Last modification date";
        this.addField1(fi);
        fi = new FieldInfo(this, createName);
        fi.type = "dateCreate";
        fi.description = "Creation date";
        fi.fixed = true;
        fi.notNull = true;
        this.addField1(fi);
    }

    @Override
    public boolean isTemporary() {
        return this.origin == null;
    }

    RecordInfo() {
        this.name = "temp" + this.hashCode();
    }

    public RecordInfo(String name) {
        this.name = name;
        this.origin = null;
    }

    protected void addField1(FieldDefinition fi) {
        this.fieldOrder.addElement(fi.getName());
        this.fields.put(fi.getName(), fi);
        ((FieldInfo)fi).dd = this;
    }

    @Override
    public void addField(FieldDefinition fi) {
        if (!this.isTemporary()) {
            throw new RuntimeException("can't add field to non-temporary type");
        }
        this.addField1(fi);
    }

    RecordInfo(URL origin, String path) {
        this.name = path;
        this.origin = origin;
    }

    RecordInfo(RecordInfo ri, String subfield) {
        this.name = ri.name;
        this.origin = ri.origin;
        this.subfield = subfield;
        this.papa = ri;
        this.ptrSubfield = this.papa.ptrSubfield + "->" + subfield;
        this.subfieldPtr = this.papa.subfieldPtr + subfield + "->";
    }

    public static DataDefinition getRecordInfo(String name) {
        int n = name.indexOf("->");
        if (n == -1) {
            try {
                return RecordInfo.getSimpleRecordInfo(name);
            }
            catch (DataDefinitionNotFoundError e) {
                n = name.lastIndexOf(".");
                if (n == -1) {
                    throw e;
                }
                try {
                    return RecordInfo.getRecordInfo(name.substring(0, n) + "->" + name.substring(n + 1));
                }
                catch (DataDefinitionParseError f) {
                    throw e;
                }
            }
        }
        DataDefinition ri = RecordInfo.getRecordInfo(name.substring(0, n));
        while ((n = (name = name.substring(n + 2)).indexOf("->")) != -1) {
            ri = ri.getFieldDefinition(name.substring(0, n)).getSubtable();
        }
        ri = ri.getFieldDefinition(name).getSubtable();
        return ri;
    }

    public static synchronized DataDefinition getSimpleRecordInfo(String path) {
        boolean dot = false;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '.') {
                if (dot) {
                    throw new DataDefinitionParseError("two consecutive dots not allowed in type name");
                }
                dot = true;
            } else {
                dot = false;
            }
            if (path.charAt(i) == '/' || path.charAt(i) == '.' || (i != 0 || Character.isJavaIdentifierStart(path.charAt(i))) && (i <= 0 || Character.isJavaIdentifierPart(path.charAt(i)))) continue;
            throw new DataDefinitionParseError("Invalid character \"" + path.charAt(i) + "\" in type name \"" + path + "\"");
        }
        if (path.indexOf(47) != -1 && (path = path.replace('/', '.')).charAt(0) == '.') {
            path = path.substring(1);
        }
        DataDefinition ri = null;
        try {
            ri = (DataDefinition)NamedResources.getStaticCache(infos).getResource(path);
        }
        catch (RuntimeWrappedException e) {
            if (e.getCause() instanceof DataDefinitionParseError) {
                throw (DataDefinitionParseError)e.getCause();
            }
            if (e.getCause() instanceof DataDefinitionNotFoundError) {
                throw (DataDefinitionNotFoundError)e.getCause();
            }
            if (e.getCause() instanceof MakumbaError) {
                throw (MakumbaError)e.getCause();
            }
            throw e;
        }
        if (path.indexOf("./") == -1) {
            ((RecordInfo)ri).name = path;
        } else {
            Logger.getLogger("org.makumba.debug.abstr").severe("shit happens: " + path);
        }
        return ri;
    }

    @Override
    public Vector<String> getFieldNames() {
        return new Vector<String>(this.fieldOrder);
    }

    @Override
    public Vector<FieldDefinition> getReferenceFields() {
        Vector<FieldDefinition> v = new Vector<FieldDefinition>();
        for (FieldDefinition fieldDefinition : this.fields.values()) {
            FieldDefinition fd = fieldDefinition;
            if (!fd.isPointer() && !fd.isExternalSet() && !fd.isComplexSet()) continue;
            v.add(fd);
        }
        return v;
    }

    @Override
    public FieldDefinition getFieldDefinition(String nm) {
        return this.fields.get(nm);
    }

    @Override
    public FieldDefinition getFieldOrPointedFieldDefinition(String nm) {
        if (this.getFieldDefinition(nm) != null) {
            return this.getFieldDefinition(nm);
        }
        String fieldName = nm;
        DataDefinition dd = this;
        int indexOf = -1;
        while ((indexOf = fieldName.indexOf(".")) != -1) {
            String subFieldName = fieldName.substring(0, indexOf);
            fieldName = fieldName.substring(indexOf + 1);
            FieldDefinition fieldDefinition = dd.getFieldDefinition(subFieldName);
            dd = fieldDefinition.getPointedType();
        }
        return dd.getFieldDefinition(fieldName);
    }

    @Override
    public FieldDefinition getFieldDefinition(int n) {
        if (n < 0 || n >= this.fieldOrder.size()) {
            return null;
        }
        return this.getFieldDefinition(this.fieldOrder.elementAt(n));
    }

    @Override
    public DataDefinition.QueryFragmentFunction getFunction(String name) {
        return this.functionNames.get(name);
    }

    @Override
    public void addFunction(String name, DataDefinition.QueryFragmentFunction function) {
        this.functionNames.put(name, function);
    }

    @Override
    public Collection<DataDefinition.QueryFragmentFunction> getFunctions() {
        return this.functionNames.values();
    }

    @Override
    public Collection<DataDefinition.QueryFragmentFunction> getActorFunctions() {
        ArrayList<DataDefinition.QueryFragmentFunction> actorFunctions = new ArrayList<DataDefinition.QueryFragmentFunction>();
        for (DataDefinition.QueryFragmentFunction function : this.functionNames.values()) {
            if (!function.isActorFunction()) continue;
            actorFunctions.add(function);
        }
        return actorFunctions;
    }

    @Override
    public Collection<DataDefinition.QueryFragmentFunction> getSessionFunctions() {
        ArrayList<DataDefinition.QueryFragmentFunction> sessionFunctions = new ArrayList<DataDefinition.QueryFragmentFunction>();
        for (DataDefinition.QueryFragmentFunction function : this.functionNames.values()) {
            if (!function.isSessionFunction()) continue;
            sessionFunctions.add(function);
        }
        return sessionFunctions;
    }

    @Override
    public String getName() {
        return this.name + this.ptrSubfield;
    }

    String getBaseName() {
        return this.name;
    }

    public String fieldPrefix() {
        return this.subfieldPtr;
    }

    RecordInfo makeSubtable(String name) {
        return new RecordInfo(this, name);
    }

    @Override
    public String getIndexPointerFieldName() {
        return this.indexName;
    }

    @Override
    public String getSetOwnerFieldName() {
        return this.mainPtr;
    }

    @Override
    public String getTitleFieldName() {
        return this.title;
    }

    @Override
    public String getCreationDateFieldName() {
        return createName;
    }

    @Override
    public String getLastModificationDateFieldName() {
        return modifyName;
    }

    @Override
    public FieldDefinition getParentField() {
        if (this.papa == null) {
            return null;
        }
        return this.papa.getFieldDefinition(this.subfield);
    }

    @Override
    public String getSetMemberFieldName() {
        return this.setField;
    }

    @Override
    public void checkFieldNames(Dictionary d) {
        Enumeration e = d.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof String)) {
                throw new NoSuchFieldException(this, "Dictionaries passed to makumba DB operations should have String keys. Key <" + o + "> is of type " + o.getClass() + this.getName());
            }
            if (this.getFieldDefinition((String)o) != null) continue;
            throw new NoSuchFieldException(this, (String)o);
        }
    }

    public String toString() {
        return this.getName();
    }

    public URL getOrigin() {
        return this.origin;
    }

    @Override
    public long lastModified() {
        return new File(this.getOrigin().getFile()).lastModified();
    }

    @Override
    public DataDefinition getDataDefinition() {
        return this;
    }

    public void addValidationRule(ValidationRule rule) {
        this.validationRuleNames.put(rule.getRuleName(), rule);
    }

    @Override
    public ValidationRule getValidationRule(String ruleName) {
        return this.validationRuleNames.get(ruleName);
    }

    @Override
    public void addRule(String fieldName, Collection<ValidationRule> rules) {
        this.getFieldDefinition(fieldName).addValidationRule(rules);
    }

    @Override
    public void addRule(String fieldName, ValidationRule rule) {
        this.getFieldDefinition(fieldName).addValidationRule(rule);
    }

    @Override
    public Collection<ValidationRule> getValidationRules(String fieldName) {
        return this.getFieldDefinition(fieldName).getValidationRules();
    }

    @Override
    public ValidationDefinition getValidationDefinition() {
        return this;
    }

    @Override
    public boolean hasValidationRules() {
        return this.validationRuleNames.size() > 0;
    }

    @Override
    public DataDefinition.MultipleUniqueKeyDefinition[] getMultiFieldUniqueKeys() {
        return this.multiFieldUniqueList.values().toArray(new DataDefinition.MultipleUniqueKeyDefinition[this.multiFieldUniqueList.values().size()]);
    }

    @Override
    public void addMultiUniqueKey(DataDefinition.MultipleUniqueKeyDefinition definition) {
        this.multiFieldUniqueList.put(definition.getFields(), definition);
    }

    @Override
    public boolean hasMultiUniqueKey(String[] fieldNames) {
        return this.multiFieldUniqueList.get(fieldNames) != null;
    }

    @Override
    public void checkUpdate(String fieldName, Dictionary d) {
        Object o = d.get(fieldName);
        if (o != null) {
            switch (this.getFieldDefinition(fieldName).getIntegerType()) {
                case 10: {
                    throw new InvalidValueException(this.getFieldDefinition(fieldName), "you cannot update a creation date");
                }
                case 11: {
                    throw new InvalidValueException(this.getFieldDefinition(fieldName), "you cannot update a modification date");
                }
                case 3: {
                    throw new InvalidValueException(this.getFieldDefinition(fieldName), "you cannot update an index pointer");
                }
            }
            this.base_checkUpdate(fieldName, d);
        }
    }

    private void base_checkUpdate(String fieldName, Dictionary d) {
        this.getFieldDefinition(fieldName).checkUpdate(d);
    }

    static {
        infos = NamedResources.makeStaticCache("Data definitions parsed", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            protected Object getHashObject(Object name) {
                URL u = RecordParser.findDataDefinition((String)name, "mdd");
                if (u == null) {
                    throw new DataDefinitionNotFoundError((String)name);
                }
                return u;
            }

            protected Object makeResource(Object name, Object hashName) {
                String nm = (String)name;
                if (nm.indexOf(47) != -1) {
                    nm = nm.replace('/', '.').substring(1);
                }
                return new RecordInfo((URL)hashName, nm);
            }

            protected void configureResource(Object name, Object hashName, Object resource) {
                new RecordParser().parse((RecordInfo)resource);
            }
        });
    }
}

