/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.animate;

import prefuse.action.ItemAction;
import prefuse.util.ColorLib;
import prefuse.util.PrefuseLib;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.visual.VisualItem;

public class ColorAnimator
extends ItemAction {
    private static final String[] DEFAULTS = new String[]{VisualItem.STROKECOLOR, VisualItem.FILLCOLOR, VisualItem.TEXTCOLOR};
    private CopyOnWriteArrayList m_colorFields;

    public ColorAnimator() {
        this.setColorFields(DEFAULTS);
    }

    public ColorAnimator(String group) {
        super(group);
        this.setColorFields(DEFAULTS);
    }

    public ColorAnimator(String group, String field) {
        super(group);
        this.setColorFields(new String[]{field});
    }

    public ColorAnimator(String group, String[] fields) {
        super(group);
        this.setColorFields(fields);
    }

    public void setColorFields(String[] fields) {
        if (fields == null) {
            throw new IllegalArgumentException();
        }
        if (this.m_colorFields == null) {
            this.m_colorFields = new CopyOnWriteArrayList();
        } else {
            this.m_colorFields.clear();
        }
        for (int i = 0; i < fields.length; ++i) {
            this.m_colorFields.add(fields[i]);
            this.m_colorFields.add(PrefuseLib.getStartField(fields[i]));
            this.m_colorFields.add(PrefuseLib.getEndField(fields[i]));
        }
    }

    public void process(VisualItem item, double frac) {
        if (this.m_colorFields == null) {
            return;
        }
        Object[] fields = this.m_colorFields.getArray();
        for (int i = 0; i < fields.length; i += 3) {
            String f = (String)fields[i];
            String sf = (String)fields[i + 1];
            String ef = (String)fields[i + 2];
            int sc = item.getInt(sf);
            int ec = item.getInt(ef);
            int cc = ColorLib.interp(sc, ec, frac);
            item.setInt(f, cc);
        }
    }
}

