/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import java.util.Comparator;
import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.BinaryExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.util.TypeLib;
import prefuse.util.collections.DefaultLiteralComparator;
import prefuse.util.collections.LiteralComparator;

public class ComparisonPredicate
extends BinaryExpression
implements Predicate {
    public static final int LT = 0;
    public static final int GT = 1;
    public static final int EQ = 2;
    public static final int NEQ = 3;
    public static final int LTEQ = 4;
    public static final int GTEQ = 5;
    private Comparator m_cmp;

    public ComparisonPredicate(int operation, Expression left, Expression right) {
        this(operation, left, right, DefaultLiteralComparator.getInstance());
    }

    public ComparisonPredicate(int operation, Expression left, Expression right, Comparator cmp) {
        super(operation, 0, 5, left, right);
        this.m_cmp = cmp;
    }

    public Comparator getComparator() {
        return this.m_cmp;
    }

    public Class getType(Schema s) {
        return Boolean.TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(Tuple t) {
        Class lType = this.m_left.getType(t.getSchema());
        Class rType = this.m_right.getType(t.getSchema());
        int c = 0;
        if (TypeLib.isNumericType(lType) && TypeLib.isNumericType(rType)) {
            Class type = TypeLib.getNumericType(lType, rType);
            if (type == Integer.TYPE || type == Byte.TYPE) {
                int x = this.m_left.getInt(t);
                int y = this.m_right.getInt(t);
                c = ((LiteralComparator)this.m_cmp).compare(x, y);
            } else if (type == Long.TYPE) {
                long x = this.m_left.getLong(t);
                long y = this.m_right.getLong(t);
                c = ((LiteralComparator)this.m_cmp).compare(x, y);
            } else if (type == Float.TYPE) {
                float x = this.m_left.getFloat(t);
                float y = this.m_right.getFloat(t);
                c = ((LiteralComparator)this.m_cmp).compare(x, y);
            } else {
                if (type != Double.TYPE) throw new IllegalStateException();
                double x = this.m_left.getDouble(t);
                double y = this.m_right.getDouble(t);
                c = ((LiteralComparator)this.m_cmp).compare(x, y);
            }
        } else {
            c = this.m_cmp.compare(this.m_left.get(t), this.m_right.get(t));
        }
        switch (this.m_op) {
            case 0: {
                if (c != -1) return false;
                return true;
            }
            case 1: {
                if (c != 1) return false;
                return true;
            }
            case 2: {
                if (c != 0) return false;
                return true;
            }
            case 3: {
                if (c == 0) return false;
                return true;
            }
            case 4: {
                if (c > 0) return false;
                return true;
            }
            case 5: {
                if (c < 0) return false;
                return true;
            }
        }
        throw new IllegalStateException("Unknown operation.");
    }

    public Object get(Tuple t) {
        return this.getBoolean(t) ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toString() {
        String op = "?";
        switch (this.m_op) {
            case 0: {
                op = "<";
                break;
            }
            case 1: {
                op = ">";
                break;
            }
            case 2: {
                op = "=";
                break;
            }
            case 3: {
                op = "!=";
                break;
            }
            case 4: {
                op = "<=";
                break;
            }
            case 5: {
                op = ">=";
            }
        }
        return this.m_left.toString() + ' ' + op + ' ' + this.m_right.toString();
    }
}

