/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.commons.SQLPointer;
import org.makumba.devel.DataServlet;
import org.makumba.devel.DevelUtils;
import org.makumba.providers.Configuration;
import org.makumba.providers.TransactionProvider;

public class DataPointerValueConverter
extends DataServlet {
    private static final long serialVersionUID = 1L;
    public static final int FROM_DB = 10;
    public static final int FROM_EXTERNAL = 20;

    public DataPointerValueConverter() {
        this.toolLocation = Configuration.getObjectIdConverterLocation();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doGet(request, response);
        this.browsePath = this.contextPath + Configuration.getObjectIdConverterLocation();
        String paramDataType = request.getParameter("dataType");
        String paramValue = request.getParameter("value");
        if (paramValue == null) {
            paramValue = "";
        }
        String paramFromType = request.getParameter("fromType");
        int mode = 20;
        if (paramFromType != null && paramFromType.equals("db")) {
            mode = 10;
        }
        PrintWriter writer = response.getWriter();
        DevelUtils.writePageBegin(writer);
        DevelUtils.writeStylesAndScripts(writer, this.contextPath);
        DevelUtils.writeTitleAndHeaderEnd(writer, "Value Converter");
        this.writePageContentHeader(this.type, writer, TransactionProvider.getInstance().getDefaultDataSourceName(), 40);
        writer.println("<form>");
        writer.println("<table>");
        writer.println("  <tr>");
        writer.println("    <th>From</th>");
        writer.println("    <td>");
        writer.print("      Database value <input type=\"radio\" name=\"fromType\" value=\"db\"" + (mode == 10 ? " checked" : "") + ">");
        writer.println("      External form <input type=\"radio\" name=\"fromType\" value=\"external\"" + (mode == 20 ? " checked" : "") + ">");
        writer.println("    </td>");
        writer.println("  </tr>");
        writer.println("  <tr>");
        writer.println("    <th>Data type</th>");
        writer.println("    <td>");
        writer.println("      <select name=\"dataType\">");
        Vector<String> v = MakumbaSystem.mddsInDirectory("dataDefinitions");
        Collections.sort(v);
        for (int i = 0; i < v.size(); ++i) {
            String selected = v.get(i).equals(paramDataType) ? " selected" : "";
            writer.println("        <option name=\"" + v.get(i) + "\"" + selected + ">" + v.get(i) + "</option>");
        }
        writer.println("      </select>");
        writer.println("    </td>");
        writer.println("  </tr>");
        writer.println("  <tr>");
        writer.println("    <th>Value</th>");
        writer.println("    <td><input type=\"text\" name=\"value\" style=\"width: 100%\" value=\"" + paramValue + "\"></td>");
        writer.println("  </tr>");
        writer.println("  <tr>");
        writer.println("    <td colspan=\"2\" align=\"center\"><input type=\"submit\" value=\"convert\" ></td>");
        writer.println("  </tr>");
        writer.println("</table>");
        writer.println("</form>");
        if (paramValue != null && !paramValue.equals("")) {
            Pointer pointer = null;
            if (paramFromType == null || paramFromType.equals("external")) {
                try {
                    pointer = new Pointer(paramDataType, paramValue);
                }
                catch (InvalidValueException e) {
                    writer.println("<span style=\"color: red;\">" + e.getMessage() + "</span>");
                }
            } else {
                try {
                    pointer = new SQLPointer(paramDataType, Long.parseLong(paramValue));
                }
                catch (NumberFormatException e) {
                    writer.println("<span style=\"color: red;\">The Database Pointer value given is not a number!</span>");
                    e.printStackTrace();
                }
            }
            if (pointer != null) {
                writer.println("<hr/>");
                writer.println("<table>");
                writer.println("  <tr>");
                writer.println("    <th>External Value</th>");
                writer.println("    <th>Database Value</th>");
                writer.println("    <th>DBSV:UID</th>");
                writer.println("  </tr>");
                writer.println("  <tr>");
                writer.println("    <td>" + pointer.toExternalForm() + "</td>");
                writer.println("    <td>" + pointer.longValue() + "</td>");
                writer.println("    <td>" + pointer.getDbsv() + ":" + pointer.getUid() + "</td>");
                writer.println("  </tr>");
                writer.println("</table>");
            }
        }
        DevelUtils.writePageEnd(writer);
    }
}

