/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.DataDefinition;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.Transaction;
import org.makumba.commons.ClassResource;
import org.makumba.providers.DataDefinitionProvider;

public class ObjectImporter {
    Properties markers = new Properties();
    protected DataDefinition dd;
    protected boolean ignored;
    protected boolean ignoreNotFound;
    protected String begin;
    protected String end;
    MakumbaError configError;
    Properties replaceFile;
    boolean canError = true;
    boolean noWarning = false;
    String nothing;
    Vector formats = new Vector();
    String joinField;
    String select;
    int index = -1;
    int nchar = -1;
    boolean noMarkers = false;
    static String[][] htmlEscape = new String[][]{{"&quot;", "&amp;", "<br>"}, {"\"", "&", "\n"}};

    public String getMarker(String s) {
        return this.markers.getProperty(s);
    }

    public ObjectImporter(DataDefinition type) {
        this(type, false);
    }

    public ObjectImporter(DataDefinition type, boolean noMarkers) {
        this.dd = type;
        this.noMarkers = noMarkers;
        String nm = type.getName().replace('.', '/') + ".mark";
        URL u = null;
        try {
            u = ClassResource.get("dataDefinitions/" + nm);
            this.markers.load(u.openStream());
        }
        catch (Exception e) {
            try {
                u = ClassResource.get(nm);
                this.markers.load(u.openStream());
            }
            catch (Exception f) {
                throw new MakumbaError(f);
            }
        }
        Enumeration<String> e = this.dd.getFieldNames().elements();
        while (e.hasMoreElements()) {
            String fieldName = e.nextElement();
            this.configureField(fieldName, this.markers);
        }
        Vector<String> notMarked = new Vector<String>();
        Enumeration<String> e2 = this.dd.getFieldNames().elements();
        while (e2.hasMoreElements()) {
            String fieldName = e2.nextElement();
            if (this.isMarked(fieldName) || this.isIgnored(fieldName)) continue;
            notMarked.addElement(fieldName);
        }
        if (notMarked.size() > 0) {
            Logger.getLogger("org.makumba.import").warning("marker file " + u + " does not contain markers for:\n " + notMarked + "\nUse \"<fieldname>.ignore=true\" in the marked file if you are shure you don't want the field to be imported");
        }
        boolean hasErrors = false;
        Enumeration<String> e3 = this.dd.getFieldNames().elements();
        while (e3.hasMoreElements()) {
            String fieldName = e3.nextElement();
            if (this.configError == null || this.isIgnored(fieldName)) continue;
            if (!hasErrors) {
                hasErrors = true;
                Logger.getLogger("org.makumba.import").warning("marker file " + u + " contains errors. Erroneous fields will be ignored.");
            }
            this.ignored = true;
            Logger.getLogger("org.makumba.import").severe(this.configError.toString());
        }
    }

    Object getValue(String fieldName, String s, Transaction db, Pointer[] indexes) {
        if (this.isIgnored(fieldName)) {
            return null;
        }
        return this.getFieldValue(fieldName, this.replaceField(fieldName, s), db, indexes);
    }

    protected boolean isMarked(String fieldName) {
        if (this.isFieldMarked(fieldName)) {
            return true;
        }
        if (this.noMarkers) {
            String s = this.begin;
            this.begin = "x";
            boolean b = this.isFieldMarked(fieldName);
            this.begin = s;
            return b;
        }
        return false;
    }

    protected boolean usesHidden() {
        return true;
    }

    public Dictionary importFrom(String s, Transaction db, Pointer[] indexes) {
        Hashtable ht = new Hashtable();
        Enumeration<String> e = this.dd.getFieldNames().elements();
        while (e.hasMoreElements()) {
            String fieldName = e.nextElement();
            this.importFieldTo(fieldName, ht, s, db, indexes);
        }
        return ht;
    }

    public static void main(String[] argv) throws Throwable {
        ObjectImporter ri = new ObjectImporter(DataDefinitionProvider.getInstance().getDataDefinition(argv[0]));
        File dir = new File(argv[1]);
        String[] lst = dir.list();
        char[] buffer = new char[8196];
        for (int i = 0; i < lst.length; ++i) {
            int n;
            Logger.getLogger("org.makumba.import").finest(lst[i]);
            FileReader r = new FileReader(new File(dir, lst[i]));
            StringWriter sw = new StringWriter();
            while ((n = r.read(buffer)) != -1) {
                sw.write(buffer, 0, n);
            }
            String content = sw.toString().toString();
            Logger.getLogger("org.makumba.import").finest(ri.importFrom(content, null, null).toString());
        }
    }

    public Object getFieldValue(String fieldName, String s, Transaction db, Pointer[] indexes) {
        switch (this.dd.getFieldDefinition(fieldName).getIntegerType()) {
            case 0: {
                return this.get_ptr_FieldValue(fieldName, s, db, indexes);
            }
        }
        return this.base_getFieldValue(fieldName, s, db, indexes);
    }

    public Object base_getFieldValue(String fieldName, String s, Transaction db, Pointer[] indexes) {
        return this.getFieldValue(fieldName, s);
    }

    public Object get_ptr_FieldValue(String fieldName, String s, Transaction db, Pointer[] indexes) {
        if (this.index != -1) {
            return indexes[this.index];
        }
        if (s.length() == 0) {
            return null;
        }
        String arg = s;
        if (this.select != null) {
            Vector<Dictionary<String, Object>> v = db.executeQuery(this.select, arg);
            if (v.size() > 1) {
                this.warningField(fieldName, "too many join results for \"" + s + "\": " + v);
                return null;
            }
            if (v.size() == 1) {
                return (Pointer)v.elementAt(0).get("col1");
            }
            this.warningField(fieldName, "no join results for \"" + s + "\"");
            return null;
        }
        String query = null;
        query = "SELECT p, p." + this.joinField + " FROM " + this.dd.getFieldDefinition(fieldName).getForeignTable().getName() + " p WHERE p." + this.joinField + "=$1";
        Vector<Dictionary<String, Object>> v = db.executeQuery(query, arg);
        if (v.size() > 1) {
            this.warningField(fieldName, "too many join results for \"" + s + "\": " + v);
            return null;
        }
        if (v.size() == 1) {
            return (Pointer)v.elementAt(0).get("col1");
        }
        if (this.nchar == -1) {
            this.warningField(fieldName, "no join results for \"" + s + "\"");
            return null;
        }
        query = "SELECT p, p." + this.joinField + " FROM " + this.dd.getFieldDefinition(fieldName).getForeignTable().getName() + " p WHERE p." + this.joinField + " like $1";
        v = db.executeQuery(query, arg = s.length() < this.nchar ? s : s.substring(0, this.nchar) + "%");
        if (v.size() > 1) {
            this.warningField(fieldName, "too many join results for \"" + s + "\": " + v);
            return null;
        }
        if (v.size() == 0) {
            this.warningField(fieldName, "no join results for \"" + s + "\"");
            return null;
        }
        return (Pointer)v.elementAt(0).get("col1");
    }

    public Object getFieldValue(String fieldName, String s) {
        switch (this.dd.getFieldDefinition(fieldName).getIntegerType()) {
            case 9: 
            case 10: 
            case 11: {
                return this.get_date_FieldValue(fieldName, s);
            }
            case 4: {
                return this.get_int_FieldValue(fieldName, s);
            }
            case 5: {
                return this.get_intEnum_FieldValue(fieldName, s);
            }
        }
        return this.base_getFieldValue(fieldName, s);
    }

    public Object base_getFieldValue(String fieldName, String s) {
        return s;
    }

    public Object get_date_FieldValue(String fieldName, String s) {
        if (s.trim().length() == 0) {
            return null;
        }
        ParseException lastpe = null;
        Enumeration e = this.formats.elements();
        while (e.hasMoreElements()) {
            SimpleDateFormat f = (SimpleDateFormat)e.nextElement();
            try {
                return f.parse(s);
            }
            catch (ParseException pe) {
                lastpe = pe;
            }
        }
        this.warningField(fieldName, lastpe);
        return null;
    }

    public Object get_intEnum_FieldValue(String fieldName, String s) {
        if ((s = (String)this.base_getFieldValue(fieldName, s)).trim().length() == 0) {
            return null;
        }
        Enumeration f = this.dd.getFieldDefinition(fieldName).getValues();
        Enumeration e = this.dd.getFieldDefinition(fieldName).getNames();
        while (e.hasMoreElements()) {
            String v = (String)e.nextElement();
            Integer i = (Integer)f.nextElement();
            if (!v.equals(s)) continue;
            return i;
        }
        this.warningField(fieldName, "illegal value: \"" + s + "\"");
        return null;
    }

    public Object get_int_FieldValue(String fieldName, String s) {
        if ((s = (String)this.base_getFieldValue(fieldName, s)).trim().length() == 0) {
            return null;
        }
        try {
            return new Integer(Integer.parseInt((String)this.base_getFieldValue(fieldName, s)));
        }
        catch (Exception e) {
            this.warningField(fieldName, e);
            return null;
        }
    }

    public boolean isIgnored(String fieldName) {
        if (this.dd.getFieldDefinition(fieldName).getType().startsWith("set")) {
            return true;
        }
        switch (this.dd.getFieldDefinition(fieldName).getIntegerType()) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return this.ignored;
    }

    public boolean isFieldMarked(String fieldName) {
        switch (this.dd.getFieldDefinition(fieldName).getIntegerType()) {
            case 0: {
                return this.joinField != null || this.index != -1 || this.select != null;
            }
        }
        return this.begin != null;
    }

    String replaceField(String fieldName, String val) {
        if (val != null) {
            String transf = this.getFieldMarker(fieldName, "replace." + val);
            if (transf != null) {
                val = transf;
            } else {
                String val1 = val.replace(' ', '_').replace('=', '_');
                transf = this.getFieldMarker(fieldName, "replace." + val1);
                if (transf != null) {
                    val = transf;
                } else if (this.replaceFile != null) {
                    transf = this.replaceFile.getProperty(val);
                    if (transf != null) {
                        val = transf;
                    } else {
                        transf = this.replaceFile.getProperty(val1);
                        if (transf != null) {
                            val = transf;
                        }
                    }
                }
            }
        }
        return val;
    }

    String getFieldMarker(String fieldName, String m) {
        String s = this.markers.getProperty(fieldName + "." + m);
        if (s != null) {
            return s.trim();
        }
        return null;
    }

    public String canonicalFieldName(String fieldName) {
        return this.dd.getName() + "#" + fieldName;
    }

    void warningField(String fieldName, String s) {
        String err = this.canonicalFieldName(fieldName) + " " + s;
        if (!this.canError) {
            throw new MakumbaError(err);
        }
        Logger.getLogger("org.makumba.import").warning(err);
    }

    void warningField(String fieldName, Throwable t) {
        String err = this.canonicalFieldName(fieldName);
        if (!this.canError) {
            throw new MakumbaError(t, err);
        }
        Logger.getLogger("org.makumba.import").warning(err + " " + t.toString());
    }

    MakumbaError makeFieldError(String fieldName, String s) {
        return new MakumbaError(this.canonicalFieldName(fieldName) + " " + s);
    }

    MakumbaError makeFieldError(String fieldName, Throwable t) {
        return new MakumbaError(t, this.canonicalFieldName(fieldName));
    }

    static String escapeField(String fieldName, String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        block0: for (int i = 0; i < s.length(); ++i) {
            for (int j = 0; j < htmlEscape[0].length; ++j) {
                if (s.length() - i < htmlEscape[0][j].length() || !s.substring(i, i + htmlEscape[0][j].length()).toLowerCase().equals(htmlEscape[0][j])) continue;
                sb.append(htmlEscape[1][j]);
                i += htmlEscape[0][j].length() - 1;
                continue block0;
            }
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public boolean shouldEscapeField(String fieldName) {
        switch (this.dd.getFieldDefinition(fieldName).getIntegerType()) {
            case 4: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    public boolean shouldDecomposeURL(String fieldName) {
        return this.dd.getFieldDefinition(fieldName).getType().equals("char");
    }

    static String decomposeURL(String fieldName, String s) {
        if (s == null) {
            return null;
        }
        if (!s.startsWith("<a")) {
            return s;
        }
        int n = s.indexOf(34);
        if (n == -1 || s.length() == n + 1) {
            return s;
        }
        int n1 = s.indexOf(34, n + 1);
        if (n1 == -1 || s.length() == n1 + 1) {
            return s;
        }
        String s1 = s.substring(n + 1, n1);
        n = s.indexOf(">");
        if (n == -1 || s.length() == n + 1) {
            return s;
        }
        n1 = s.indexOf("</a>");
        if (n1 == -1) {
            return s;
        }
        try {
            if (!s1.equals(s.substring(n + 1, n1))) {
                return s;
            }
        }
        catch (StringIndexOutOfBoundsException aio) {
            Logger.getLogger("org.makumba.import").severe("EEEE " + s + " " + s1);
            return s;
        }
        if (!s1.startsWith("http")) {
            s1 = "http://" + s1;
        }
        return s1;
    }

    /*
     * Unable to fully structure code
     */
    public void importFieldTo(String fieldName, Dictionary d, String s, Transaction db, Pointer[] indexes) {
        try {
            if (this.isIgnored(fieldName) || !this.isFieldMarked(fieldName)) {
                return;
            }
            val = null;
            if (this.begin != null) {
                beg = s.indexOf(this.begin);
                if (beg != -1) {
                    beg += this.begin.length();
                    try {
                        val = s.substring(beg, s.indexOf(this.end, beg));
                        if (!this.noWarning) ** GOTO lbl19
                        this.warningField(fieldName, " found value for unfrequent field: " + val);
                    }
                    catch (Exception e) {
                        this.warningField(fieldName, "no end found");
                        return;
                    }
                } else if (!this.ignoreNotFound && !this.noWarning) {
                    this.warningField(fieldName, "begin not found");
                }
            }
lbl19:
            // 7 sources

            o = null;
            if (this.shouldEscapeField(fieldName)) {
                val = ObjectImporter.escapeField(fieldName, val);
            }
            val = this.replaceField(fieldName, val);
            if (this.shouldDecomposeURL(fieldName)) {
                val = ObjectImporter.decomposeURL(fieldName, val);
            }
            if (this.begin == null || val != null) {
                o = this.getValue(fieldName, val, db, indexes);
            }
            if (o != null) {
                if (this.nothing != null && o.equals(this.getFieldValue(fieldName, this.nothing))) {
                    return;
                }
                d.put(fieldName, o);
            }
        }
        catch (RuntimeException e) {
            throw this.makeFieldError(fieldName, e);
        }
    }

    public void configureField(String fieldName, Properties markers) {
        if (this.dd.getFieldDefinition(fieldName).getType().startsWith("set")) {
            this.configure_none_Field(fieldName, markers);
        } else {
            switch (this.dd.getFieldDefinition(fieldName).getIntegerType()) {
                case 0: {
                    this.configure_ptr_Field(fieldName, markers);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.configure_date_Field(fieldName, markers);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.configure_none_Field(fieldName, markers);
                    break;
                }
                default: {
                    this.base_configureField(fieldName, markers);
                }
            }
        }
    }

    public void base_configureField(String fieldName, Properties markers) {
        this.markers = markers;
        String s = this.getFieldMarker(fieldName, "ignore");
        boolean bl = this.ignored = s != null && s.equals("true");
        if (this.ignored) {
            return;
        }
        s = this.getFieldMarker(fieldName, "ignoreNotFound");
        this.ignoreNotFound = s != null && s.equals("true");
        this.begin = this.getFieldMarker(fieldName, "begin");
        this.nothing = this.getFieldMarker(fieldName, "nothing");
        String cf = this.getFieldMarker(fieldName, "replaceFile");
        if (cf != null) {
            this.replaceFile = new Properties();
            try {
                this.replaceFile.load(new FileInputStream(cf));
            }
            catch (IOException e) {
                this.configError = new MakumbaError(e);
            }
        }
        this.noWarning = this.getFieldMarker(fieldName, "noWarning") != null;
        this.end = this.getFieldMarker(fieldName, "end");
        if (this.end == null) {
            this.end = markers.getProperty("end");
        }
    }

    public void configure_date_Field(String fieldName, Properties markers) {
        this.base_configureField(fieldName, markers);
        Enumeration<Object> e = markers.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!s.startsWith(fieldName + ".format")) continue;
            SimpleDateFormat dateFormat = new SimpleDateFormat(markers.getProperty(s).trim(), MakumbaSystem.getLocale());
            dateFormat.setTimeZone(MakumbaSystem.getTimeZone());
            dateFormat.setLenient(false);
            this.formats.addElement(dateFormat);
        }
        if (this.formats.size() == 0) {
            this.configError = this.makeFieldError(fieldName, "has no format indicated. Use \"" + fieldName + ".format=MM yy dd\" in the marker file.\nSee the class java.text.SimpleDateFormat to see how to compose the formatter");
        }
    }

    public void configure_none_Field(String fieldName, Properties markers) {
        this.base_configureField(fieldName, markers);
        if (this.begin != null) {
            throw new MakumbaError("You cannot have markers for fields of type " + this.dd.getFieldDefinition(fieldName).getType());
        }
    }

    public void configure_ptr_Field(String fieldName, Properties markers) {
        this.base_configureField(fieldName, markers);
        if (this.ignored) {
            return;
        }
        this.joinField = this.getFieldMarker(fieldName, "joinField");
        this.select = this.getFieldMarker(fieldName, "select");
        try {
            this.index = Integer.parseInt(this.getFieldMarker(fieldName, "index"));
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        if (this.index != -1) {
            if (this.begin != null || this.joinField != null || this.select != null) {
                this.configError = this.makeFieldError(fieldName, "if pointer index is indicated, begin, end or joinfield are not needed");
            }
        } else if (this.joinField != null) {
            String s;
            if (this.index != -1 || this.select != null) {
                this.configError = this.makeFieldError(fieldName, "if join field is indicated, begin and end are needed, index not");
            }
            if ((s = this.getFieldMarker(fieldName, "joinChars")) != null) {
                this.nchar = Integer.parseInt(s);
            }
        } else if (this.select != null) {
            if (this.index != -1 || this.joinField != null) {
                this.configError = this.makeFieldError(fieldName, "if select is indicated, begin and end are needed, index not");
            }
        } else {
            this.configError = this.makeFieldError(fieldName, "join field or pointer index must be indicated for pointers");
        }
    }
}

