/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.makumba;

import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.providers.datadefinition.makumba.FieldInfo;
import org.makumba.providers.datadefinition.makumba.RecordInfo;
import org.makumba.providers.datadefinition.makumba.RecordParser;

public class FieldCursor {
    String toParse;
    int index = 0;
    RecordParser rp;

    public FieldCursor(RecordParser rp, String definition) {
        this.rp = rp;
        this.toParse = definition;
        this.index = definition.indexOf(61) + 1;
    }

    public DataDefinitionParseError fail(String reason) {
        return new DataDefinitionParseError(this.rp.dd.getName(), reason, this.toParse, this.index);
    }

    void skipBlank() {
        try {
            while (Character.isWhitespace(this.toParse.charAt(this.index))) {
                ++this.index;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean lookup(String s) {
        this.skipBlank();
        int end = s.length() + this.index;
        try {
            if (this.toParse.substring(this.index, end).equals(s)) {
                this.index = end;
                return true;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public void expect(String s) throws DataDefinitionParseError {
        if (!this.lookup(s)) {
            throw this.fail(s + " expected");
        }
    }

    public void expectWhitespace() throws DataDefinitionParseError {
        int indexBefore = this.index;
        this.skipBlank();
        if (indexBefore == this.index) {
            throw this.fail("some whitespace expected");
        }
    }

    public String lookupTypeLiteral() {
        return this.lookupIdentifier();
    }

    public String expectTypeLiteral() throws DataDefinitionParseError {
        String ret = this.lookupTypeLiteral();
        if (ret == null) {
            throw this.fail("type expected");
        }
        return ret;
    }

    public String lookupEnumName() throws DataDefinitionParseError {
        this.skipBlank();
        if (!this.lookup("\"")) {
            throw this.fail("\"expected");
        }
        return this.upToExpect("\"");
    }

    public String expectEnumName() throws DataDefinitionParseError {
        String ret = this.lookupEnumName();
        if (ret == null) {
            throw this.fail("enumerator name expected");
        }
        return ret;
    }

    public String lookupTableName() throws DataDefinitionParseError {
        this.skipBlank();
        int end = this.index;
        try {
            char c;
            while (Character.isLetter(c = this.toParse.charAt(end)) || Character.isDigit(c) || c == '_' || c == '-' || c == '.' || c == '/' || c == '>') {
                ++end;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        if (end == this.index) {
            return null;
        }
        return this.upTo(end);
    }

    public String lookupLetters() {
        this.skipBlank();
        int end = this.index;
        try {
            while (Character.isLetter(this.toParse.charAt(end))) {
                ++end;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        if (end == this.index) {
            return null;
        }
        return this.upTo(end);
    }

    public Integer lookupInteger() {
        this.skipBlank();
        int end = this.index;
        try {
            if (this.toParse.charAt(end) == '-') {
                ++end;
            }
            while (Character.isDigit(this.toParse.charAt(end))) {
                ++end;
            }
        }
        catch (StringIndexOutOfBoundsException siob) {
            // empty catch block
        }
        if (end == this.index) {
            return null;
        }
        try {
            return new Integer(this.upTo(end));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Integer expectInteger() throws DataDefinitionParseError {
        Integer i = this.lookupInteger();
        if (i == null) {
            throw this.fail("Integer expected");
        }
        return i;
    }

    String lookupIdentifier() {
        this.skipBlank();
        int end = this.index;
        try {
            char c;
            if (!Character.isLetter(this.toParse.charAt(end))) {
                return null;
            }
            ++end;
            while (Character.isDigit(c = this.toParse.charAt(end)) || Character.isLetter(c) || c == '_' || c == '-') {
                ++end;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        if (end == this.index) {
            return null;
        }
        return this.upTo(end);
    }

    String upToExpect(String s) throws DataDefinitionParseError {
        int beg = this.index;
        int end = s.length() + this.index;
        try {
            while (!this.toParse.substring(this.index, end).equals(s)) {
                ++this.index;
                ++end;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw this.fail(s + " expected");
        }
        s = this.toParse.substring(beg, this.index);
        this.index = end;
        return s;
    }

    DataDefinition lookupTableSpecifier() throws DataDefinitionParseError {
        int beg = this.index;
        String path = this.lookupTableName();
        if (path == null) {
            return null;
        }
        DataDefinition ri = null;
        try {
            ri = RecordInfo.getRecordInfo(path);
        }
        catch (DataDefinitionNotFoundError e) {
            // empty catch block
        }
        if (ri == null) {
            this.index = beg;
            return null;
        }
        return ri;
    }

    void expectCharEnum(FieldInfo fi) throws DataDefinitionParseError {
        Vector<String> valueset;
        fi.extra1 = valueset = new Vector<String>();
        int len = 0;
        String s = this.lookupEnumName();
        if (s != null) {
            while (true) {
                int ln = s.length();
                if (valueset.contains(s)) {
                    throw this.fail("repeated name: " + s);
                }
                valueset.addElement(s);
                if (ln > len) {
                    len = ln;
                }
                if (!this.lookup(",")) break;
                s = this.expectEnumName();
            }
        }
        if (this.lookup("}")) {
            fi.extra2 = new Integer(len);
            return;
        }
        throw this.fail(" , or } epxected");
    }

    void expectIntEnum(FieldInfo fi) throws DataDefinitionParseError {
        Vector<Integer> valueset = new Vector<Integer>();
        Vector<String> nameset = new Vector<String>();
        Vector<Integer> deprset = new Vector<Integer>();
        fi.extra1 = valueset;
        fi.extra2 = nameset;
        fi.extra3 = deprset;
        String s = this.lookupEnumName();
        if (s != null) {
            while (true) {
                if (nameset.contains(s)) {
                    throw this.fail("repeated name: " + s);
                }
                nameset.addElement(s);
                this.expect("=");
                Integer val = this.expectInteger();
                valueset.addElement(val);
                if (this.lookup("deprecated")) {
                    deprset.addElement(val);
                }
                if (!this.lookup(",")) break;
                s = this.expectEnumName();
            }
        }
        if (!this.lookup("}")) {
            throw this.fail("deprecated or , or } epxected");
        }
    }

    public String lookupDescription() throws DataDefinitionParseError {
        if (this.lookup(";")) {
            try {
                return this.toParse.substring(this.index);
            }
            catch (StringIndexOutOfBoundsException siobe) {
                return null;
            }
        }
        try {
            if (this.toParse.substring(this.index).trim().length() != 0) {
                throw this.fail("end of definition expected");
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    String upTo(int end) {
        String ret = this.toParse.substring(this.index, end);
        this.index = end;
        return ret;
    }

    public void substitute(int l, String s) {
        this.index -= l;
        this.toParse = this.toParse.substring(0, this.index) + s + this.toParse.substring(this.index + l);
    }
}

