/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.makumba.commons.ControllerHandler;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.commons.ServletObjects;

public class ControllerFilter
implements Filter {
    private FilterConfig conf;
    private String handlerClasses = "org.makumba.devel.SourceViewControllerHandler,org.makumba.devel.DataToolsControllerHandler,org.makumba.commons.MakumbaToolsControllerHandler,org.makumba.devel.ErrorControllerHandler,org.makumba.analyser.AnalysisInitControllerHandler,org.makumba.controller.FilterConditionControllerHandler,org.makumba.commons.attributes.DatabaseConnectionControllerHandler,org.makumba.commons.attributes.AttributesControllerHandler,org.makumba.forms.responder.ResponseControllerHandler";
    private ArrayList<ControllerHandler> handlers = new ArrayList();

    public void init(FilterConfig c) {
        this.conf = c;
        String handlerParam = c.getInitParameter("handlerClasses");
        if (handlerParam == null) {
            handlerParam = this.handlerClasses;
        }
        StringTokenizer str = new StringTokenizer(handlerParam, ",");
        while (str.hasMoreTokens()) {
            try {
                this.handlers.add((ControllerHandler)Class.forName(str.nextToken().trim()).newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws ServletException, IOException {
        int i;
        int imax = -1;
        ServletObjects servletObjects = new ServletObjects(req, resp);
        try {
            for (i = 0; i < this.handlers.size(); ++i) {
                imax = i;
                if (!this.handlers.get(i).beforeFilter(req, resp, this.conf, servletObjects)) break;
            }
            for (i = imax; i >= 0; --i) {
                this.handlers.get(i).afterBeforeFilter(req, resp, this.conf);
            }
            if (imax == this.handlers.size() - 1) {
                chain.doFilter(servletObjects.getRequest(), servletObjects.getResponse());
            }
            for (i = imax; i >= 0; --i) {
                this.handlers.get(i).afterFilter(req, resp, this.conf);
            }
        }
        catch (Throwable t) {
            for (i = imax; i >= 0; --i) {
                if (this.handlers.get(i).onError(req, resp, t, this.conf)) continue;
                return;
            }
            throw new RuntimeWrappedException(t);
        }
        finally {
            for (i = this.handlers.size() - 1; i >= 0; --i) {
                try {
                    this.handlers.get(i).finalize(req, resp);
                    continue;
                }
                catch (Throwable t) {
                    throw new RuntimeWrappedException(t);
                }
            }
        }
    }

    public void destroy() {
    }
}

