/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list.html;

import java.util.Dictionary;
import org.makumba.HtmlUtils;
import org.makumba.commons.formatters.FieldFormatter;
import org.makumba.commons.formatters.RecordFormatter;

public class FieldViewer
extends FieldFormatter {
    static final String defaultEllipsis = "...";

    protected FieldViewer() {
    }

    public static FieldFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    public String formatMaxLengthEllipsis(RecordFormatter rf, int fieldIndex, String s, Dictionary formatParams) {
        String addTitle;
        int ellipsisLen;
        String prefix = "";
        String postfix = "";
        String sOut = s;
        int maxLen = this.getIntParam(rf, fieldIndex, formatParams, "maxLength");
        String ellipsis = (String)formatParams.get("ellipsis");
        if (ellipsis == null) {
            ellipsis = defaultEllipsis;
        }
        if ((ellipsisLen = this.getIntParam(rf, fieldIndex, formatParams, "ellipsisLength")) == -1) {
            ellipsisLen = ellipsis.length();
        }
        if ((addTitle = (String)formatParams.get("addTitle")) == null) {
            addTitle = "false";
        }
        if (maxLen != -1 && s.length() > maxLen) {
            int cutAt = maxLen - ellipsisLen;
            if (cutAt < 0) {
                cutAt = 0;
            }
            sOut = sOut.substring(0, cutAt);
            postfix = ellipsis;
        }
        if (addTitle.equals("true") || addTitle.equals("auto") && maxLen != -1 && s.length() > maxLen) {
            prefix = "<span title=\"" + s.replace('\"', '\'') + "\">";
            postfix = postfix + "</span>";
        }
        return prefix + HtmlUtils.string2html(sOut) + postfix;
    }

    private static final class SingletonHolder {
        static final FieldFormatter singleton = new FieldViewer();

        private SingletonHolder() {
        }
    }
}

