/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Properties;
import org.makumba.ConfigFileError;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.OQLParseError;
import org.makumba.commons.ClassResource;
import org.makumba.commons.NameResolver;
import org.makumba.providers.QueryAnalysisProvider;
import org.makumba.providers.query.hql.HQLQueryAnalysisProvider;
import org.makumba.providers.query.mql.MqlQueryAnalysis;
import org.makumba.providers.query.oql.QueryAST;

public class ParserTest {
    private static QueryAnalysisProvider qap = new HQLQueryAnalysisProvider();
    private static PrintWriter pw = new PrintWriter(System.out);
    private static NameResolver nr;

    public static void main(String[] argv) {
        boolean automaticLeftJoin = false;
        int line = 1;
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)ClassResource.get("org/makumba/providers/query/mql/queries.txt").getContent()));
            String query = null;
            while ((query = rd.readLine()) != null) {
                if (query.startsWith("#automaticLeftJoin")) {
                    automaticLeftJoin = true;
                }
                if (!query.trim().startsWith("#")) {
                    ParserTest.analyseQuery(line, query, automaticLeftJoin);
                }
                ++line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("analyzed " + line + " queries");
    }

    static String cleanUp(String s, String toRemove) {
        StringBuffer ret = new StringBuffer();
        char lastNonSpace = '\u0000';
        boolean prevSpace = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (toRemove.indexOf(c) == -1) {
                if (prevSpace && Character.isJavaIdentifierStart(c) && Character.isJavaIdentifierPart(lastNonSpace)) {
                    ret.append(' ');
                }
                lastNonSpace = c;
                ret.append(c);
                prevSpace = false;
                continue;
            }
            prevSpace = true;
        }
        return ret.toString();
    }

    private static void analyseQuery(int line, String query, boolean automaticLeftJoin) {
        Object hql_sql = null;
        boolean passedMql = false;
        Object thr = null;
        String oql_sql = null;
        String mql_sql = null;
        MqlQueryAnalysis mq = null;
        Throwable mqlThr = null;
        try {
            mq = new MqlQueryAnalysis(query, false, automaticLeftJoin);
            mql_sql = mq.writeInSQLQuery(nr).toLowerCase();
        }
        catch (Throwable t) {
            mqlThr = t;
        }
        try {
            QueryAST oq = (QueryAST)QueryAST.parseQueryFundamental(query);
            oql_sql = oq.writeInSQLQuery(nr).toLowerCase();
            if (mqlThr == null) {
                String mqLabels;
                if (!(oql_sql = ParserTest.cleanUp(oql_sql, " ").replace('\"', '\'')).equals(mql_sql = ParserTest.cleanUp(mql_sql, " ")) && !ParserTest.cleanUp(oql_sql, "()").equals(ParserTest.cleanUp(mql_sql, "()"))) {
                    System.out.println(line + ": MQL!=OQL: " + query + "\n\t" + mql_sql + "\n\t" + oql_sql);
                }
                StringBuffer sb = new StringBuffer();
                ParserTest.compareMdds("parameter", sb, mq.getParameterTypes(), oq.getParameterTypes());
                if (sb.length() > 0) {
                    System.out.println(line + ": " + sb + " " + query);
                }
                sb = new StringBuffer();
                ParserTest.compareMdds("projection", sb, mq.getProjectionType(), oq.getProjectionType());
                if (sb.length() > 0) {
                    System.out.println(line + ": " + sb + " " + query);
                }
                if (!(mqLabels = mq.getLabelTypes().toString()).equals(oq.getLabelTypes().toString()) && !mqLabels.equals("{c=org.makumba.db.makumba.Catalog}")) {
                    System.out.println(line + ": " + query + "\n\t" + mq.getLabelTypes() + "\n\t" + oq.getLabelTypes());
                }
            }
        }
        catch (Throwable t) {
            if (mqlThr != null) {
                System.err.println(line + ": MQL: " + mqlThr.getMessage() + " " + query);
            }
            System.err.println(line + ":" + (mqlThr == null ? " only in" : "") + " OQL: " + t.getMessage() + " " + query);
            if (mqlThr == null) {
                System.out.println(line + ": MQL SQL: " + mql_sql);
            }
            return;
        }
        if (mqlThr != null) {
            System.err.println(line + ": only in MQL: " + mqlThr.getMessage() + " " + query);
            System.out.println(line + ": OQL SQL: " + oql_sql);
            if (!(mqlThr instanceof OQLParseError)) {
                mqlThr.printStackTrace();
            }
        }
    }

    private static void compareMdds(String what, StringBuffer sb, DataDefinition mdd1, DataDefinition mdd2) {
        HashSet<String> fieldsDone = new HashSet<String>();
        for (String s : mdd1.getFieldNames()) {
            FieldDefinition fd1 = mdd1.getFieldDefinition(s);
            FieldDefinition fd2 = mdd2.getFieldDefinition(s);
            if (fd2 == null) {
                sb.append("extra MQL ").append(what).append(": ");
                ParserTest.appendFieldDefinition(sb, fd1);
                sb.append("\n");
                continue;
            }
            if (!(fd1.isAssignableFrom(fd2) || fd1.getType().equals("boolean") && fd2.getType().equals("int"))) {
                sb.append(what).append(" ").append(s).append(" MQL: ");
                ParserTest.appendFieldDefinition(sb, fd1);
                sb.append(" OQL: ");
                ParserTest.appendFieldDefinition(sb, fd2);
                sb.append("\n");
            }
            fieldsDone.add(s);
        }
        if (mdd2 != null) {
            for (String s : mdd2.getFieldNames()) {
                if (fieldsDone.contains(s)) continue;
                FieldDefinition fd2 = mdd2.getFieldDefinition(s);
                sb.append("extra OQL ").append(what).append(": ");
                ParserTest.appendFieldDefinition(sb, fd2);
                sb.append("\n");
            }
        }
    }

    private static void appendFieldDefinition(StringBuffer sb, FieldDefinition fd) {
        sb.append(fd.getName()).append("=").append(fd.getType());
    }

    static {
        String databaseProperties = "test/localhost_mysql_makumba.properties";
        Properties p = new Properties();
        try {
            p.load(ClassResource.get(databaseProperties).openStream());
        }
        catch (Exception e) {
            throw new ConfigFileError(databaseProperties);
        }
        nr = new NameResolver();
    }
}

