/*
 * Decompiled with CFR 0.152.
 */
package org.securityfilter.authenticator;

import javax.servlet.FilterConfig;
import org.securityfilter.authenticator.Authenticator;
import org.securityfilter.authenticator.BasicAuthenticator;
import org.securityfilter.authenticator.FormAuthenticator;
import org.securityfilter.config.SecurityConfig;

public class AuthenticatorFactory {
    public static Authenticator createAuthenticator(FilterConfig filterConfig, SecurityConfig securityConfig) throws Exception {
        Authenticator authenticator = null;
        String authMethod = securityConfig.getAuthMethod();
        if ("FORM".equals(authMethod)) {
            authenticator = new FormAuthenticator();
        } else if ("BASIC".equals(authMethod)) {
            authenticator = new BasicAuthenticator();
        } else {
            throw new Exception("No Authenticator available for auth method: " + authMethod);
        }
        authenticator.init(filterConfig, securityConfig);
        return authenticator;
    }
}

