/*
 * Decompiled with CFR 0.152.
 */
package org.securityfilter.filter;

import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.securityfilter.authenticator.Authenticator;
import org.securityfilter.authenticator.AuthenticatorFactory;
import org.securityfilter.config.AuthConstraint;
import org.securityfilter.config.SecurityConfig;
import org.securityfilter.config.SecurityConstraint;
import org.securityfilter.config.WebResourceCollection;
import org.securityfilter.filter.SavedRequest;
import org.securityfilter.filter.SecurityRequestWrapper;
import org.securityfilter.filter.URLPattern;
import org.securityfilter.filter.URLPatternFactory;
import org.securityfilter.filter.URLPatternMatcher;
import org.securityfilter.realm.SecurityRealmInterface;
import org.xml.sax.SAXException;

public class SecurityFilter
implements Filter {
    public static final String CONFIG_FILE_KEY = "config";
    public static final String DEFAULT_CONFIG_FILE = "/WEB-INF/securityfilter-config.xml";
    public static final String VALIDATE_KEY = "validate";
    public static final String TRUE = "true";
    public static final String ALREADY_PROCESSED = (class$org$securityfilter$filter$SecurityFilter == null ? (class$org$securityfilter$filter$SecurityFilter = SecurityFilter.class$("org.securityfilter.filter.SecurityFilter")) : class$org$securityfilter$filter$SecurityFilter).getName() + ".ALREADY_PROCESSED";
    public static final String SAVED_REQUEST_URL = (class$org$securityfilter$filter$SecurityFilter == null ? (class$org$securityfilter$filter$SecurityFilter = SecurityFilter.class$("org.securityfilter.filter.SecurityFilter")) : class$org$securityfilter$filter$SecurityFilter).getName() + ".SAVED_REQUEST_URL";
    public static final String SAVED_REQUEST = (class$org$securityfilter$filter$SecurityFilter == null ? (class$org$securityfilter$filter$SecurityFilter = SecurityFilter.class$("org.securityfilter.filter.SecurityFilter")) : class$org$securityfilter$filter$SecurityFilter).getName() + ".SAVED_REQUEST";
    protected FilterConfig config;
    protected SecurityRealmInterface realm;
    protected List patternList;
    protected URLPatternFactory patternFactory;
    protected Authenticator authenticator;
    static /* synthetic */ Class class$org$securityfilter$filter$SecurityFilter;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hReq = (HttpServletRequest)request;
        HttpServletResponse hRes = (HttpServletResponse)response;
        if (!TRUE.equals(request.getAttribute(ALREADY_PROCESSED))) {
            AuthConstraint authConstraint;
            request.setAttribute(ALREADY_PROCESSED, (Object)TRUE);
            URLPatternMatcher patternMatcher = this.patternFactory.createURLPatternMatcher();
            SavedRequest savedRequest = this.getSavedRequest(hReq);
            SecurityRequestWrapper wrappedRequest = new SecurityRequestWrapper(hReq, savedRequest, this.realm, this.authenticator.getAuthMethod());
            URLPattern match = null;
            try {
                if (this.authenticator.processLogout(wrappedRequest, hRes, patternMatcher)) {
                    hReq.getSession().invalidate();
                    hReq.getSession(true);
                }
                if (this.authenticator.processLogin(wrappedRequest, hRes)) {
                    return;
                }
                if (!this.authenticator.bypassSecurityForThisRequest(wrappedRequest, patternMatcher)) {
                    match = this.matchPattern(wrappedRequest.getMatchableURL(), wrappedRequest.getMethod(), patternMatcher);
                }
            }
            catch (Exception e) {
                throw new ServletException("Error matching patterns", (Throwable)e);
            }
            if (match != null && (authConstraint = match.getSecurityConstraint().getAuthConstraint()) != null) {
                Collection roles = authConstraint.getRoles();
                Principal principal = wrappedRequest.getUserPrincipal();
                if (!roles.isEmpty() && principal == null) {
                    this.authenticator.showLogin(hReq, hRes);
                    return;
                }
                boolean authorized = false;
                Iterator i = roles.iterator();
                while (i.hasNext() && !authorized) {
                    String role = (String)i.next();
                    if (!"*".equals(role) && !this.realm.isUserInRole(principal, role)) continue;
                    authorized = true;
                }
                if (!authorized) {
                    hRes.sendError(403);
                    return;
                }
            }
            request = wrappedRequest;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        try {
            String configFile = config.getInitParameter(CONFIG_FILE_KEY);
            if (configFile == null) {
                configFile = DEFAULT_CONFIG_FILE;
            }
            URL configURL = config.getServletContext().getResource(configFile);
            boolean validate = TRUE.equalsIgnoreCase(config.getInitParameter(VALIDATE_KEY));
            SecurityConfig securityConfig = new SecurityConfig(validate);
            securityConfig.loadConfig(configURL);
            this.realm = securityConfig.getRealm();
            this.authenticator = AuthenticatorFactory.createAuthenticator(config, securityConfig);
            this.patternFactory = new URLPatternFactory();
            this.patternList = new ArrayList();
            int order = 1;
            List constraints = securityConfig.getSecurityConstraints();
            Iterator cIter = constraints.iterator();
            while (cIter.hasNext()) {
                SecurityConstraint constraint = (SecurityConstraint)cIter.next();
                Iterator rIter = constraint.getWebResourceCollections().iterator();
                while (rIter.hasNext()) {
                    WebResourceCollection resourceCollection = (WebResourceCollection)rIter.next();
                    Iterator pIter = resourceCollection.getURLPatterns().iterator();
                    while (pIter.hasNext()) {
                        URLPattern pattern = this.patternFactory.createURLPattern((String)pIter.next(), constraint, resourceCollection, order++);
                        this.patternList.add(pattern);
                    }
                }
            }
            Collections.sort(this.patternList);
        }
        catch (IOException ioe) {
            System.err.println("unable to parse input: " + ioe);
        }
        catch (SAXException se) {
            System.err.println("unable to parse input: " + se);
        }
        catch (Exception e) {
            System.err.println("error: " + e);
            e.printStackTrace();
        }
    }

    public void destroy() {
    }

    protected URLPattern matchPattern(String pattern, String httpMethod, URLPatternMatcher matcher) throws Exception {
        Iterator i = this.patternList.iterator();
        while (i.hasNext()) {
            URLPattern urlPattern = (URLPattern)i.next();
            if (!matcher.match(pattern, httpMethod, urlPattern)) continue;
            return urlPattern;
        }
        return null;
    }

    protected SavedRequest getSavedRequest(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String savedURL = (String)session.getAttribute(SAVED_REQUEST_URL);
        if (savedURL != null && savedURL.equals(SecurityFilter.getSaveableURL(request))) {
            SavedRequest saved = (SavedRequest)session.getAttribute(SAVED_REQUEST);
            session.removeAttribute(SAVED_REQUEST_URL);
            session.removeAttribute(SAVED_REQUEST);
            return saved;
        }
        return null;
    }

    public static String getContinueToURL(HttpServletRequest request) {
        return (String)request.getSession().getAttribute(SAVED_REQUEST_URL);
    }

    public static void saveRequestInformation(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.setAttribute(SAVED_REQUEST_URL, (Object)SecurityFilter.getSaveableURL(request));
        session.setAttribute(SAVED_REQUEST, (Object)new SavedRequest(request));
    }

    private static String getSaveableURL(HttpServletRequest request) {
        StringBuffer saveableURL = null;
        try {
            saveableURL = request.getRequestURL();
        }
        catch (NoSuchMethodError e) {
            saveableURL = SecurityFilter.getRequestURL(request);
        }
        SecurityFilter.fixProtocol(saveableURL, request);
        String queryString = request.getQueryString();
        if (queryString != null) {
            saveableURL.append("?" + queryString);
        }
        return saveableURL.toString();
    }

    public void setFilterConfig(FilterConfig config) throws ServletException {
        this.init(config);
    }

    public FilterConfig getFilterConfig() {
        return this.config;
    }

    private static StringBuffer getRequestURL(HttpServletRequest request) {
        String protocol = request.getProtocol();
        int port = request.getServerPort();
        String portString = ":" + port;
        if (protocol.equals("HTTP/1.1")) {
            if (!request.isSecure()) {
                if (port == 80) {
                    portString = "";
                }
            } else if (port == 443) {
                portString = "";
            }
        }
        return new StringBuffer(protocol + request.getServerName() + portString + request.getRequestURI());
    }

    private static void fixProtocol(StringBuffer url, HttpServletRequest request) {
        if (request.getProtocol().equals("HTTP/1.1") && request.isSecure() && url.toString().startsWith("http://")) {
            url.replace(0, 4, "https");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

