/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.util.Collection;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.util.JBossInterface;

public class JBossObject
implements JBossInterface {
    protected Logger log;
    protected transient String toString;
    protected transient int hashCode = Integer.MIN_VALUE;

    public static boolean equals(Object one, Object two) {
        if (one == null && two != null) {
            return false;
        }
        return one == null || one.equals(two);
    }

    public static boolean notEqual(Object one, Object two) {
        return !JBossObject.equals(one, two);
    }

    public static void list(StringBuffer buffer, Collection objects) {
        if (objects == null) {
            return;
        }
        buffer.append('[');
        if (!objects.isEmpty()) {
            Iterator i = objects.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                if (object instanceof JBossObject) {
                    ((JBossObject)object).toShortString(buffer);
                } else {
                    buffer.append(object.toString());
                }
                if (!i.hasNext()) continue;
                buffer.append(", ");
            }
        }
        buffer.append(']');
    }

    public JBossObject() {
        this.log = Logger.getLogger(this.getClass());
    }

    public JBossObject(Logger log) {
        this.log = log != null ? log : Logger.getLogger(this.getClass());
    }

    public String toString() {
        if (this.toString == null || !this.cacheToString()) {
            this.toString = this.toStringImplementation();
        }
        return this.toString;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE || !this.cacheGetHashCode()) {
            this.hashCode = this.getHashCode();
        }
        return this.hashCode;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toShortString() {
        StringBuffer buffer = new StringBuffer();
        this.toShortString(buffer);
        return buffer.toString();
    }

    public void toShortString(StringBuffer buffer) {
    }

    public String getClassShortName() {
        String longName = this.getClass().getName();
        int dot = longName.lastIndexOf(46);
        if (dot != -1) {
            return longName.substring(dot + 1);
        }
        return longName;
    }

    protected String toStringImplementation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClassShortName()).append('@');
        buffer.append(Integer.toHexString(System.identityHashCode(this)));
        buffer.append('{');
        this.toString(buffer);
        buffer.append('}');
        return buffer.toString();
    }

    protected void flushJBossObjectCache() {
        this.toString = null;
        this.hashCode = Integer.MIN_VALUE;
    }

    protected void toString(StringBuffer buffer) {
    }

    protected int getHashCode() {
        return super.hashCode();
    }

    protected boolean cacheToString() {
        return true;
    }

    protected boolean cacheGetHashCode() {
        return true;
    }
}

