/*
 * Decompiled with CFR 0.152.
 */
package ch.ubique.inieditor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class IniEditor {
    private static boolean DEFAULT_CASE_SENSITIVITY = false;
    private Map sections = new HashMap();
    private List sectionOrder = new LinkedList();
    private String commonName;
    private char[] commentDelims;
    private boolean isCaseSensitive;
    private OptionFormat optionFormat;
    private static final Line BLANK_LINE = new Line(){

        public String toString() {
            return "";
        }
    };

    public IniEditor() {
        this(null, null);
    }

    public IniEditor(boolean bl) {
        this(null, null, bl);
    }

    public IniEditor(String string) {
        this(string, null);
    }

    public IniEditor(String string, boolean bl) {
        this(string, null, bl);
    }

    public IniEditor(char[] cArray) {
        this(null, cArray);
    }

    public IniEditor(char[] cArray, boolean bl) {
        this(null, cArray, bl);
    }

    public IniEditor(String string, char[] cArray) {
        this(string, cArray, DEFAULT_CASE_SENSITIVITY);
    }

    public IniEditor(String string, char[] cArray, boolean bl) {
        this.isCaseSensitive = bl;
        if (string != null) {
            this.commonName = string;
            this.addSection(this.commonName);
        }
        this.commentDelims = cArray;
        this.optionFormat = new OptionFormat("%s %s %s");
    }

    public void setOptionFormatString(String string) {
        this.optionFormat = new OptionFormat(string);
    }

    public String get(String string, String string2) {
        if (this.hasSection(string)) {
            Section section = this.getSection(string);
            if (section.hasOption(string2)) {
                return section.get(string2);
            }
            if (this.commonName != null) {
                return this.getSection(this.commonName).get(string2);
            }
        }
        return null;
    }

    public void set(String string, String string2, String string3) {
        if (!this.hasSection(string)) {
            throw new NoSuchSectionException(string);
        }
        this.getSection(string).set(string2, string3);
    }

    public boolean remove(String string, String string2) {
        if (this.hasSection(string)) {
            return this.getSection(string).remove(string2);
        }
        throw new NoSuchSectionException(string);
    }

    public boolean hasOption(String string, String string2) {
        return this.hasSection(string) && this.getSection(string).hasOption(string2);
    }

    public boolean hasSection(String string) {
        return this.sections.containsKey(this.normSection(string));
    }

    public boolean addSection(String string) {
        String string2 = this.normSection(string);
        if (!this.hasSection(string2)) {
            Section section = new Section(string2, this.commentDelims, this.isCaseSensitive);
            section.setOptionFormat(this.optionFormat);
            this.sections.put(string2, section);
            this.sectionOrder.add(string2);
            return true;
        }
        return false;
    }

    public boolean removeSection(String string) {
        String string2 = this.normSection(string);
        if (this.commonName != null && this.commonName.equals(string2)) {
            throw new IllegalArgumentException("Can't remove common section");
        }
        if (this.hasSection(string2)) {
            this.sections.remove(string2);
            this.sectionOrder.remove(string2);
            return true;
        }
        return false;
    }

    public List sectionNames() {
        ArrayList arrayList = new ArrayList(this.sectionOrder);
        if (this.commonName != null) {
            arrayList.remove(this.commonName);
        }
        return arrayList;
    }

    public List optionNames(String string) {
        if (this.hasSection(string)) {
            return this.getSection(string).optionNames();
        }
        throw new NoSuchSectionException(string);
    }

    public void addComment(String string, String string2) {
        if (!this.hasSection(string)) {
            throw new NoSuchSectionException(string);
        }
        this.getSection(string).addComment(string2);
    }

    public void addBlankLine(String string) {
        if (!this.hasSection(string)) {
            throw new NoSuchSectionException(string);
        }
        this.getSection(string).addBlankLine();
    }

    public void save(String string) throws IOException {
        this.save(new File(string));
    }

    public void save(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.save(fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public void save(OutputStream outputStream) throws IOException {
        this.save(new OutputStreamWriter(outputStream));
    }

    public void save(OutputStreamWriter outputStreamWriter) throws IOException {
        Iterator iterator = this.sectionOrder.iterator();
        PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, true);
        while (iterator.hasNext()) {
            Section section = this.getSection((String)iterator.next());
            printWriter.println(section.header());
            section.save(printWriter);
        }
    }

    public void load(String string) throws IOException {
        this.load(new File(string));
    }

    public void load(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.load(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(new InputStreamReader(inputStream));
    }

    public void load(InputStreamReader inputStreamReader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = null;
        String string2 = null;
        while (bufferedReader.ready()) {
            int n;
            string2 = bufferedReader.readLine().trim();
            if (string2.length() > 0 && string2.charAt(0) == '[' && (n = string2.indexOf(93)) >= 0) {
                string = string2.substring(1, n);
                this.addSection(string);
            }
            if (string == null) continue;
            Section section = this.getSection(string);
            section.load(bufferedReader);
        }
    }

    private Section getSection(String string) {
        return (Section)this.sections.get(this.normSection(string));
    }

    private String normSection(String string) {
        if (!this.isCaseSensitive) {
            string = string.toLowerCase();
        }
        return string.trim();
    }

    private static String[] toStringArray(Collection collection) {
        Object[] objectArray = collection.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public static class NoSuchSectionException
    extends RuntimeException {
        public NoSuchSectionException() {
        }

        public NoSuchSectionException(String string) {
            super(string);
        }
    }

    private static class OptionFormat {
        private static final int EXPECTED_TOKENS = 4;
        private String[] formatTokens;

        public OptionFormat(String string) {
            this.formatTokens = this.compileFormat(string);
        }

        public String format(String string, String string2, char c) {
            String[] stringArray = this.formatTokens;
            return stringArray[0] + string + stringArray[1] + c + stringArray[2] + string2 + stringArray[3];
        }

        private String[] compileFormat(String string) {
            String[] stringArray = new String[]{"", "", "", ""};
            int n = 0;
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            block4: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case '%': {
                        if (bl) {
                            stringBuffer.append("%");
                            bl = false;
                            continue block4;
                        }
                        bl = true;
                        continue block4;
                    }
                    case 's': {
                        if (bl) {
                            if (n >= 4) {
                                throw new IllegalArgumentException("Illegal option format. Too many %s placeholders.");
                            }
                            stringArray[n] = stringBuffer.toString();
                            ++n;
                            stringBuffer = new StringBuffer();
                            bl = false;
                            continue block4;
                        }
                        stringBuffer.append("s");
                        continue block4;
                    }
                    default: {
                        if (bl) {
                            throw new IllegalArgumentException("Illegal option format. Unknown format specifier.");
                        }
                        stringBuffer.append(string.charAt(i));
                    }
                }
            }
            if (n != 3) {
                throw new IllegalArgumentException("Illegal option format. Not enough %s placeholders.");
            }
            stringArray[n] = stringBuffer.toString();
            return stringArray;
        }
    }

    private static class Comment
    implements Line {
        private String comment;
        private char delimiter;
        private static final char DEFAULT_DELIMITER = '#';

        public Comment(String string) {
            this(string, '#');
        }

        public Comment(String string, char c) {
            this.comment = string.trim();
            this.delimiter = c;
        }

        public String toString() {
            return this.delimiter + " " + this.comment;
        }
    }

    private static class Option
    implements Line {
        private String name;
        private String value;
        private char separator;
        private OptionFormat format;
        private static final String ILLEGAL_VALUE_CHARS = "\n\r";

        public Option(String string, String string2, char c, OptionFormat optionFormat) {
            if (!Option.validName(string, c)) {
                throw new IllegalArgumentException("Illegal option name:" + string);
            }
            this.name = string;
            this.separator = c;
            this.format = optionFormat;
            this.set(string2);
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public void set(String string) {
            if (string == null) {
                this.value = string;
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ILLEGAL_VALUE_CHARS);
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken());
                }
                this.value = stringBuffer.toString();
            }
        }

        public String toString() {
            return this.format.format(this.name, this.value, this.separator);
        }

        private static boolean validName(String string, char c) {
            if (string.trim().equals("")) {
                return false;
            }
            return string.indexOf(c) < 0;
        }
    }

    private static interface Line {
        public String toString();
    }

    public static class Section {
        private String name;
        private Map options;
        private List lines;
        private char[] optionDelims;
        private char[] optionDelimsSorted;
        private char[] commentDelims;
        private char[] commentDelimsSorted;
        private boolean isCaseSensitive;
        private OptionFormat optionFormat;
        private static final char[] DEFAULT_OPTION_DELIMS = new char[]{'=', ':'};
        private static final char[] DEFAULT_COMMENT_DELIMS = new char[]{'#', ';'};
        private static final char[] OPTION_DELIMS_WHITESPACE = new char[]{' ', '\t'};
        private static final boolean DEFAULT_CASE_SENSITIVITY = false;
        public static final String DEFAULT_OPTION_FORMAT = "%s %s %s";
        public static final char HEADER_START = '[';
        public static final char HEADER_END = ']';
        private static final int NAME_MAXLENGTH = 1024;
        private static final char[] INVALID_NAME_CHARS = new char[]{'[', ']'};
        private static final String NEWLINE_CHARS = "\n\r";

        public Section(String string) {
            this(string, null);
        }

        public Section(String string, boolean bl) {
            this(string, null, bl);
        }

        public Section(String string, char[] cArray) {
            this(string, cArray, false);
        }

        public Section(String string, char[] cArray, boolean bl) {
            if (!Section.validName(string)) {
                throw new IllegalArgumentException("Illegal section name:" + string);
            }
            this.name = string;
            this.isCaseSensitive = bl;
            this.options = new HashMap();
            this.lines = new LinkedList();
            this.optionDelims = DEFAULT_OPTION_DELIMS;
            this.commentDelims = cArray == null ? DEFAULT_COMMENT_DELIMS : cArray;
            this.optionFormat = new OptionFormat(DEFAULT_OPTION_FORMAT);
            this.optionDelimsSorted = new char[this.optionDelims.length];
            System.arraycopy(this.optionDelims, 0, this.optionDelimsSorted, 0, this.optionDelims.length);
            this.commentDelimsSorted = new char[this.commentDelims.length];
            System.arraycopy(this.commentDelims, 0, this.commentDelimsSorted, 0, this.commentDelims.length);
            Arrays.sort(this.optionDelimsSorted);
            Arrays.sort(this.commentDelimsSorted);
        }

        public void setOptionFormatString(String string) {
            this.setOptionFormat(new OptionFormat(string));
        }

        public void setOptionFormat(OptionFormat optionFormat) {
            this.optionFormat = optionFormat;
        }

        public List optionNames() {
            LinkedList<String> linkedList = new LinkedList<String>();
            Iterator iterator = this.lines.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Option)) continue;
                linkedList.add(((Option)e).name());
            }
            return linkedList;
        }

        public boolean hasOption(String string) {
            return this.options.containsKey(this.normOption(string));
        }

        public String get(String string) {
            String string2 = this.normOption(string);
            if (this.hasOption(string2)) {
                return this.getOption(string2).value();
            }
            return null;
        }

        public void set(String string, String string2) {
            this.set(string, string2, this.optionDelims[0]);
        }

        public void set(String string, String string2, char c) {
            String string3 = this.normOption(string);
            if (this.hasOption(string3)) {
                this.getOption(string3).set(string2);
            } else {
                Option option = new Option(string3, string2, c, this.optionFormat);
                this.options.put(string3, option);
                this.lines.add(option);
            }
        }

        public boolean remove(String string) {
            String string2 = this.normOption(string);
            if (this.hasOption(string2)) {
                this.lines.remove(this.getOption(string2));
                this.options.remove(string2);
                return true;
            }
            return false;
        }

        public void addComment(String string) {
            this.addComment(string, this.commentDelims[0]);
        }

        public void addComment(String string, char c) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), NEWLINE_CHARS);
            while (stringTokenizer.hasMoreTokens()) {
                this.lines.add(new Comment(stringTokenizer.nextToken(), c));
            }
        }

        public void addBlankLine() {
            this.lines.add(BLANK_LINE);
        }

        public void load(BufferedReader bufferedReader) throws IOException {
            while (bufferedReader.ready()) {
                bufferedReader.mark(1024);
                String string = bufferedReader.readLine().trim();
                if (string.length() > 0 && string.charAt(0) == '[') {
                    bufferedReader.reset();
                    return;
                }
                int n = -1;
                if (string.equals("")) {
                    this.addBlankLine();
                    continue;
                }
                n = Arrays.binarySearch(this.commentDelimsSorted, string.charAt(0));
                if (n >= 0) {
                    this.addComment(string.substring(1), this.commentDelimsSorted[n]);
                    continue;
                }
                n = -1;
                int n2 = -1;
                int n3 = -1;
                int n4 = string.length();
                for (int i = 0; i < n4 && n < 0; ++i) {
                    boolean bl;
                    n2 = Arrays.binarySearch(this.optionDelimsSorted, string.charAt(i));
                    if (n2 >= 0) {
                        n = i;
                        continue;
                    }
                    boolean bl2 = bl = Arrays.binarySearch(OPTION_DELIMS_WHITESPACE, string.charAt(i)) >= 0;
                    if (!bl && n3 >= 0) break;
                    if (!bl) continue;
                    n3 = i;
                }
                if (n == 0) continue;
                if (n < 0) {
                    if (n3 < 0) {
                        this.set(string, "");
                        continue;
                    }
                    this.set(string.substring(0, n3), string.substring(n3 + 1));
                    continue;
                }
                this.set(string.substring(0, n), string.substring(n + 1), string.charAt(n));
            }
        }

        public void save(PrintWriter printWriter) throws IOException {
            Iterator iterator = this.lines.iterator();
            while (iterator.hasNext()) {
                printWriter.println(((Object)((Line)iterator.next())).toString());
            }
            if (printWriter.checkError()) {
                throw new IOException();
            }
        }

        private Option getOption(String string) {
            return (Option)this.options.get(string);
        }

        private String header() {
            return '[' + this.name + ']';
        }

        private static boolean validName(String string) {
            if (string.trim().equals("")) {
                return false;
            }
            for (int i = 0; i < INVALID_NAME_CHARS.length; ++i) {
                if (string.indexOf(INVALID_NAME_CHARS[i]) < 0) continue;
                return false;
            }
            return true;
        }

        private String normOption(String string) {
            if (!this.isCaseSensitive) {
                string = string.toLowerCase();
            }
            return string.trim();
        }
    }
}

