/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy.servlet.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.tidy.servlet.TidyProcessor;

public class BufferedServletOutputStream
extends ServletOutputStream {
    protected ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    protected HttpServletResponse response;
    protected boolean binary;
    private int originalContentLength = -1;
    protected TidyProcessor processor;
    private static Log log = LogFactory.getLog((Class)(class$org$w3c$tidy$servlet$filter$BufferedServletOutputStream == null ? (class$org$w3c$tidy$servlet$filter$BufferedServletOutputStream = BufferedServletOutputStream.class$("org.w3c.tidy.servlet.filter.BufferedServletOutputStream")) : class$org$w3c$tidy$servlet$filter$BufferedServletOutputStream));
    protected boolean closed;
    private ServletOutputStream origOutputStream;
    static /* synthetic */ Class class$org$w3c$tidy$servlet$filter$BufferedServletOutputStream;

    BufferedServletOutputStream(HttpServletResponse httpServletResponse, TidyProcessor tidyProcessor) {
        this.response = httpServletResponse;
        this.processor = tidyProcessor;
        this.origOutputStream = null;
    }

    BufferedServletOutputStream(HttpServletResponse httpServletResponse, TidyProcessor tidyProcessor, ServletOutputStream origOutputStream) {
        this.response = httpServletResponse;
        this.processor = tidyProcessor;
        this.origOutputStream = origOutputStream;
    }

    public void write(int b) throws IOException {
        this.buffer.write(b);
        if (this.origOutputStream != null) {
            this.origOutputStream.write(b);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("This output stream has already been closed");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this.buffer.toByteArray());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (this.binary) {
            log.debug((Object)"binary output");
            if (this.originalContentLength >= 0) {
                this.response.setContentLength(this.originalContentLength);
            }
            if (this.origOutputStream != null) {
                this.origOutputStream.write(this.buffer.toByteArray());
            }
        } else {
            boolean parseOk = this.processor.parse(in, out, this.buffer.toString());
            if (this.origOutputStream == null) {
                PrintWriter htmlOut = this.response.getWriter();
                if (parseOk) {
                    this.response.setContentLength(out.size());
                    log.debug((Object)("output Buffer Size " + out.size()));
                    htmlOut.write(out.toString());
                } else {
                    if (this.originalContentLength >= 0) {
                        this.response.setContentLength(this.originalContentLength);
                    }
                    htmlOut.write(this.buffer.toString());
                }
                htmlOut.close();
            }
        }
        super.close();
        this.closed = true;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    protected void setOriginalContentLength(int len) {
        this.originalContentLength = len;
    }

    public boolean isClosed() {
        return this.closed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

