/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import com.martiansoftware.jsap.JSAPResult;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.analyser.PageCache;
import org.makumba.analyser.engine.JspParseData;
import org.makumba.commons.ArgumentReplacer;
import org.makumba.commons.FileUtils;
import org.makumba.commons.ReadableFormatter;
import org.makumba.devel.WebappJSPAnalysisCrawler;
import org.makumba.devel.relations.JavaMDDParser;
import org.makumba.devel.relations.JspRelationsAnalyzer;
import org.makumba.devel.relations.RelationParseStatus;
import org.makumba.list.engine.ComposedQuery;

public class WebappJSPQueryCrawler {
    public static Logger logger = Logger.getLogger("org.makumba.pageAnalyser");
    public static Hashtable<String, Throwable> JSPAnalysisErrors = new Hashtable();
    public static final FileFilter jspFilter = new WebappJSPAnalysisCrawler.JSPFileFilter();
    public static final FileFilter javaFilter = new JavaFileFilter();

    public static void main(String[] args) throws FileNotFoundException {
        JSAPResult result = WebappJSPAnalysisCrawler.parseCrawlParams(args);
        String webappRoot = result.getString("webappRoot");
        Object[] skipPaths = result.getString("skipPaths") != null ? result.getString("skipPaths").split(",") : new String[]{};
        String analysisOutputFile = "queries.txt";
        if (result.getString("queryOutputFile") != null) {
            analysisOutputFile = result.getString("queryOutputFile");
        }
        System.out.println("Starting query crawler, config:");
        System.out.println("\twebappRoot: " + webappRoot);
        System.out.println("\tqueryOutputFile: " + analysisOutputFile);
        System.out.println("\tSkip: " + Arrays.toString(skipPaths));
        System.out.println("\t(from : " + Arrays.toString(args) + ")");
        Date beginDate = new Date();
        System.out.println("\nCrawling starts at " + beginDate + "\n");
        File f = new File(analysisOutputFile);
        PrintWriter pw = new PrintWriter(new FileOutputStream(f));
        String[] jspFiles = WebappJSPQueryCrawler.getFiles(webappRoot, (String[])skipPaths, jspFilter);
        for (int i = 0; i < jspFiles.length; ++i) {
            try {
                PageCache pageCache;
                Map<Object, Object> cache;
                JspParseData jpd = JspParseData.getParseData(webappRoot, jspFiles[i], JspRelationsAnalyzer.getInstance());
                Object analysisResult = jpd.getAnalysisResult(new RelationParseStatus());
                if (analysisResult == null || !(analysisResult instanceof PageCache) || (cache = (pageCache = (PageCache)analysisResult).retrieveCache("org.makumba.query")) == null) continue;
                for (Object key : cache.keySet()) {
                    ComposedQuery query = (ComposedQuery)cache.get(key);
                    String s = query.getTypeAnalyzerQuery();
                    ArgumentReplacer ar = new ArgumentReplacer(s, false);
                    HashMap<String, Object> d = new HashMap<String, Object>();
                    int j = 1;
                    Iterator<String> e = ar.getArgumentNames();
                    while (e.hasNext()) {
                        d.put(e.next(), "$" + j++);
                    }
                    pw.println(ar.replaceValues(d));
                }
                continue;
            }
            catch (Throwable t1) {
                t1.printStackTrace();
            }
        }
        pw.println();
        String[] javaFiles = WebappJSPQueryCrawler.getFiles(webappRoot, (String[])skipPaths, javaFilter);
        for (int i = 0; i < javaFiles.length; ++i) {
            JavaMDDParser jqp = new JavaMDDParser(webappRoot + File.separator + javaFiles[i]);
            Vector<String> queries = jqp.getQueries();
            for (String query : queries) {
                pw.println(query);
            }
        }
        pw.flush();
        pw.close();
        System.out.println("\n\nCrawling finished, took: " + ReadableFormatter.readableAge(System.currentTimeMillis() - beginDate.getTime()));
        System.out.println("Wrote queries to file: " + f.getAbsolutePath());
    }

    private static String[] getFiles(String webappRoot, String[] skipPaths, FileFilter fileFilter) {
        ArrayList<String> allFilesInDirectory = FileUtils.getAllFilesInDirectory(webappRoot, skipPaths, fileFilter);
        Collections.sort(allFilesInDirectory);
        String[] files = allFilesInDirectory.toArray(new String[allFilesInDirectory.size()]);
        return files;
    }

    private static final class JavaFileFilter
    implements FileFilter {
        private JavaFileFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".java") || pathname.isDirectory();
        }
    }
}

