/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.makumba.validation;

import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.ValidationDefinitionParseError;
import org.makumba.providers.datadefinition.makumba.validation.BasicValidationRule;

public abstract class SingleFieldValidationRule
extends BasicValidationRule {
    protected static String compileRule(String operator, String definition) {
        return "([a-zA-Z]\\w*(?:\\.\\w+)?)[ \\t]*%[ \\t]*(" + operator + ")" + "[ \\t]*" + "=" + "[ \\t]*" + definition;
    }

    protected SingleFieldValidationRule() {
    }

    protected SingleFieldValidationRule(FieldDefinition fd, String fieldName, String errorMessage, String ruleName, int[] allowedTypes) {
        super(fd, fieldName, errorMessage, ruleName, allowedTypes);
        this.checkApplicability();
    }

    public boolean checkApplicability() throws ValidationDefinitionParseError {
        for (int i = 0; i < this.allowedTypes.length; ++i) {
            if (this.allowedTypes[i] != this.fd.getIntegerType()) continue;
            return true;
        }
        throw new ValidationDefinitionParseError(this.fd.getName(), "Rule '" + this.ruleSyntax + "' is only applicable for " + this.getAllowedTypes() + " types, &lt;" + this.fd.getName() + "&gt; is of type '" + this.fd.getType() + "'!", "");
    }

    protected void throwException() throws InvalidValueException {
        throw new InvalidValueException(this.getFieldName(), this.getErrorMessage());
    }
}

