/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.DataDefinition;
import org.makumba.OQLParseError;
import org.makumba.commons.NameResolver;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.query.mql.HqlParser;
import org.makumba.providers.query.mql.MqlSqlGenerator;
import org.makumba.providers.query.mql.MqlSqlWalker;
import org.makumba.providers.query.mql.Node;
import org.makumba.providers.query.oql.QueryAST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MqlQueryAnalysis
implements QueryAnalysis {
    private static final String MAKUMBA_PARAM = "param";
    private String query;
    private List<String> parameterOrder = new ArrayList<String>();
    private DataDefinition proj;
    private boolean noFrom = false;
    private Hashtable<String, DataDefinition> labels;
    private Hashtable<String, String> aliases;
    private DataDefinition paramInfo;
    private NameResolver.TextList text;
    public static final String regExpInSET = "in[\\s]+set[\\s]*\\(";
    public static final Pattern patternInSet = Pattern.compile("in[\\s]+set[\\s]*\\(");

    public MqlQueryAnalysis(String query, boolean optimizeJoins, boolean autoLeftJoin) {
        Date d = new Date();
        this.query = query;
        query = MqlQueryAnalysis.preProcess(query);
        if (query.toLowerCase().indexOf("from") == -1) {
            this.noFrom = true;
            query = query + " FROM org.makumba.db.makumba.Catalog c";
        }
        HqlParser parser = null;
        try {
            parser = HqlParser.getInstance(query);
            parser.statement();
        }
        catch (Throwable t) {
            this.doThrow(t, parser.getAST());
        }
        this.doThrow(parser.error, parser.getAST());
        this.transformOQL(parser.getAST());
        MqlSqlWalker mqlAnalyzer = new MqlSqlWalker(query, this.makeParameterInfo(query), optimizeJoins, autoLeftJoin);
        try {
            mqlAnalyzer.statement(parser.getAST());
        }
        catch (Throwable e) {
            this.doThrow(e, parser.getAST());
        }
        this.doThrow(mqlAnalyzer.error, parser.getAST());
        this.labels = mqlAnalyzer.rootContext.labels;
        this.aliases = mqlAnalyzer.rootContext.aliases;
        this.paramInfo = mqlAnalyzer.paramInfo;
        this.proj = DataDefinitionProvider.getInstance().getVirtualDataDefinition("Projections for " + query);
        mqlAnalyzer.setProjectionTypes(this.proj);
        MqlSqlGenerator mg = new MqlSqlGenerator();
        try {
            mg.statement(mqlAnalyzer.getAST());
        }
        catch (Throwable e) {
            this.doThrow(e, mqlAnalyzer.getAST());
        }
        this.doThrow(mg.error, mqlAnalyzer.getAST());
        this.text = mg.text;
        long diff = new Date().getTime() - d.getTime();
        Logger.getLogger("org.makumba.db.query.compilation").fine("MQL to SQL: " + diff + " ms: " + query);
    }

    private DataDefinition makeParameterInfo(String query) {
        return DataDefinitionProvider.getInstance().getVirtualDataDefinition("Parameters for " + query);
    }

    private void doThrow(Throwable t, AST debugTree) {
        RecognitionException re;
        if (t == null) {
            return;
        }
        if (t instanceof RuntimeException) {
            t.printStackTrace();
            throw (RuntimeException)t;
        }
        String errorLocation = "";
        String errorLocationNumber = "";
        if (t instanceof RecognitionException && (re = (RecognitionException)t).getColumn() > 0) {
            errorLocationNumber = " column " + re.getColumn() + " of ";
            StringBuffer sb = new StringBuffer();
            sb.append("\r\n");
            for (int i = 0; i < re.getColumn(); ++i) {
                sb.append(' ');
            }
            sb.append('^');
            errorLocation = sb.toString();
        }
        throw new OQLParseError("\r\nin " + errorLocationNumber + " query:\r\n" + this.query + errorLocation + errorLocation + errorLocation, t);
    }

    @Override
    public String writeInSQLQuery(NameResolver nr) {
        String sql = this.text.toString(nr);
        if (this.noFrom) {
            return sql.substring(0, sql.toLowerCase().indexOf("from")).trim();
        }
        return sql;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public DataDefinition getLabelType(String labelName) {
        String s1 = this.aliases.get(labelName);
        if (s1 != null) {
            labelName = s1;
        }
        return this.labels.get(labelName);
    }

    @Override
    public Map<String, DataDefinition> getLabelTypes() {
        return this.labels;
    }

    @Override
    public DataDefinition getParameterTypes() {
        return this.paramInfo;
    }

    @Override
    public DataDefinition getProjectionType() {
        return this.proj;
    }

    private String getFrom() {
        String[] splitAtFrom = this.query.split("\\s[f|F][r|R][o|O][m|M]\\s");
        String[] splitAtWhere = splitAtFrom[1].split("\\s[w|W][h|H][e|E][r|R][e|E]\\s");
        return splitAtWhere[0];
    }

    public String getFieldOfExpr(String expr) {
        if (expr.indexOf(".") > -1) {
            return expr.substring(expr.lastIndexOf(".") + 1);
        }
        return expr;
    }

    public DataDefinition getTypeOfExprField(String expr) {
        DataDefinition result;
        if (expr.indexOf(".") == -1) {
            return this.getLabelType(expr);
        }
        int lastDot = expr.lastIndexOf(".");
        String beforeLastDot = expr.substring(0, lastDot);
        if (beforeLastDot.indexOf(".") == -1) {
            result = this.getLabelType(beforeLastDot);
        } else {
            String dummyQuery = "SELECT " + beforeLastDot + " AS projection FROM " + this.getFrom();
            try {
                result = QueryAST.parseQueryFundamental(dummyQuery).getProjectionType().getFieldDefinition("projection").getPointedType();
            }
            catch (RecognitionException e) {
                throw new RuntimeWrappedException(e);
            }
        }
        return result;
    }

    @Override
    public int parameterAt(int index) {
        String s = this.parameterOrder.get(index);
        if (!s.startsWith(MAKUMBA_PARAM)) {
            throw new IllegalArgumentException("parameter at " + index + " is not a $n parameter");
        }
        s = s.substring(MAKUMBA_PARAM.length());
        return Integer.parseInt(s) + 1;
    }

    @Override
    public int parameterNumber() {
        return this.parameterOrder.size();
    }

    void transformOQL(AST a) {
        if (a == null) {
            return;
        }
        if (a.getType() == 120 && a.getText().startsWith("$")) {
            a.setType(116);
            Node para = new Node();
            para.setType(120);
            try {
                para.setText(MAKUMBA_PARAM + (Integer.parseInt(a.getText().substring(1)) - 1));
            }
            catch (NumberFormatException e) {
                para.setText(a.getText().substring(1));
            }
            this.parameterOrder.add(para.getText());
            a.setFirstChild((AST)para);
            a.setText(":");
        } else if (a.getType() == 97 || a.getType() == 103) {
            if (MqlQueryAnalysis.isNil(a.getFirstChild())) {
                MqlQueryAnalysis.setNullTest(a);
                a.setFirstChild(a.getFirstChild().getNextSibling());
            } else if (MqlQueryAnalysis.isNil(a.getFirstChild().getNextSibling())) {
                MqlQueryAnalysis.setNullTest(a);
                a.getFirstChild().setNextSibling(null);
            }
        } else if (a.getType() == 68 && a.getText().toLowerCase().equals("avg")) {
            Node plus = new Node();
            plus.setType(110);
            plus.setText("+");
            Node zero = new Node();
            zero.setType(92);
            zero.setText("0.0");
            plus.setFirstChild((AST)zero);
            zero.setNextSibling(a.getFirstChild());
            a.setFirstChild((AST)plus);
        } else if (a.getType() == 116 && a.getFirstChild() != null && a.getFirstChild().getType() == 120) {
            this.parameterOrder.add(a.getFirstChild().getText());
        } else if (a.getType() == 17) {
            this.makeSubquery(a, a.getFirstChild());
        } else if (a.getType() == 78 && a.getFirstChild().getText().toLowerCase().equals("size")) {
            this.makeSelect(a, 12, "count");
        } else if (a.getType() == 78 && a.getFirstChild().getText().toLowerCase().endsWith("element")) {
            this.makeSelect(a, 68, a.getFirstChild().getText().substring(0, 3));
        }
        this.transformOQL(a.getFirstChild());
        this.transformOQL(a.getNextSibling());
    }

    private void makeSelect(AST a, int type, String text) {
        this.makeSubquery(a, a.getFirstChild().getNextSibling().getFirstChild());
        AST from = a.getFirstChild().getFirstChild();
        from.setNextSibling(this.makeNode(45, "select"));
        from.getNextSibling().setFirstChild(this.makeNode(type, text));
        from.getNextSibling().getFirstChild().setFirstChild(this.makeNode(120, "makElementsLabel"));
    }

    private void makeSubquery(AST a, AST type) {
        a.setType(83);
        a.setFirstChild(this.makeNode(86, "select"));
        a.getFirstChild().setFirstChild(this.makeNode(22, "from"));
        a.getFirstChild().getFirstChild().setFirstChild(this.makeNode(84, "range"));
        a.getFirstChild().getFirstChild().getFirstChild().setFirstChild(type);
        type.setNextSibling(this.makeNode(69, "makElementsLabel"));
    }

    private AST makeNode(int type, String string) {
        Node node = new Node();
        node.setType(type);
        node.setText(string);
        return node;
    }

    public static String showAst(AST ast) {
        return ast.toStringTree();
    }

    static boolean isNil(AST a) {
        return a.getType() == 120 && a.getText().toUpperCase().equals("NIL");
    }

    static void setNullTest(AST a) {
        if (a.getType() == 97) {
            a.setType(77);
            a.setText("is null");
        } else {
            a.setType(76);
            a.setText("is not null");
        }
    }

    public static String preProcess(String query) {
        query = query.replaceAll("->", "__");
        Matcher m = patternInSet.matcher(query.toLowerCase());
        while (m.find()) {
            int start = m.start();
            int beginSet = m.group().indexOf("set");
            query = query.substring(0, start + beginSet) + "   " + query.substring(start + beginSet + 3);
        }
        query = query.replaceAll("IN SET", "IN    ");
        return query;
    }
}

