/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.SemanticException;
import antlr.collections.AST;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.FieldDefinition;
import org.makumba.commons.NameResolver;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.query.mql.ASTUtil;
import org.makumba.providers.query.mql.MqlDotNode;
import org.makumba.providers.query.mql.MqlNode;
import org.makumba.providers.query.mql.MqlSqlWalker;

public class QueryContext {
    DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
    private QueryContext parent;
    MqlSqlWalker walker;
    MqlNode inTree = null;
    Hashtable<String, DataDefinition> labels = new Hashtable();
    Hashtable<String, DataDefinition> fromLabels = new Hashtable();
    Hashtable<String, String> aliases = new Hashtable();
    Vector<Join> joins = new Vector();
    Hashtable<String, String> joinNames = new Hashtable();
    Hashtable<String, MqlNode> projectionLabelSearch = new Hashtable();
    Vector<NameResolver.TextList> filters = new Vector();
    private Hashtable<String, NameResolver.TextList> labelText = new Hashtable();
    private HashSet<String> labelFields = new HashSet();
    HashSet<String> explicitLabels = new HashSet();
    private HashSet<String> leftJoinedImplicit = new HashSet();
    private boolean wroteRange;

    public QueryContext(MqlSqlWalker mqlSqlWalker) {
        this.walker = mqlSqlWalker;
    }

    public void setParent(QueryContext currentContext) {
        this.parent = currentContext;
    }

    public QueryContext getParent() {
        return this.parent;
    }

    public AST createFromElement(String path, AST alias, int joinType) throws SemanticException {
        this.addFrom(path, alias, joinType);
        if (this.inTree == null) {
            this.inTree = (MqlNode)ASTUtil.create(this.walker.fact, 128, "fromFragment");
            return this.inTree;
        }
        return null;
    }

    public void close() {
        if (this.inTree != null) {
            this.inTree.setTextList(this.getFrom());
        }
    }

    private NameResolver.TextList getFrom() {
        NameResolver.TextList tl = new NameResolver.TextList();
        this.writeFrom(tl);
        this.writeJoins(tl);
        return tl;
    }

    String addJoin(String l1, String f1, String name, String f2, DataDefinition type, int joinType, AST location) throws SemanticException {
        this.addLabelField(l1);
        this.joins.addElement(new Join(l1, f1, name, f2, joinType));
        this.joinNames.put(l1 + "." + f1, name);
        this.setLabelType(name, type, location);
        if (this.leftJoinedImplicit.contains(l1) && joinType == 132) {
            this.leftJoinedImplicit.add(name);
        }
        return name;
    }

    private void addLabelField(String label) {
        if (this.labels.get(label) != null) {
            this.labelFields.add(label);
        } else {
            this.parent.addLabelField(label);
        }
    }

    String join(String label, String field, String labelf, int joinType, AST location) throws SemanticException {
        String s = this.joinNames.get(label + "." + field);
        if (s != null) {
            return s;
        }
        DataDefinition foreign = null;
        DataDefinition sub = null;
        DataDefinition type = this.findLabelType(label);
        String index = type.getIndexPointerFieldName();
        FieldDefinition fi = type.getFieldDefinition(field);
        if (fi == null) {
            throw new SemanticException("no such field \"" + field + "\" in makumba type \"" + type.getName() + "\"", "", location.getLine(), location.getColumn());
        }
        if (fi.getType().startsWith("ptr") && this.labels.get(label) == null && this.parent != null) {
            return this.parent.join(label, field, labelf, joinType, location);
        }
        try {
            foreign = fi.getForeignTable();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            sub = fi.getSubtable();
        }
        catch (Exception e) {
            // empty catch block
        }
        String label2 = label;
        if (labelf != null) {
            label2 = labelf;
        }
        while (this.findLabelType(label2) != null) {
            label2 = label2 + "x";
        }
        if (joinType == -1 && this.leftJoinedImplicit.contains(label)) {
            joinType = 132;
        }
        if (joinType == -1) {
            joinType = 28;
            if (this.walker.autoLeftJoin && fi.getType().startsWith("ptr") && !fi.isNotNull()) {
                DataDefinition joinTable = fi.getType().equals("ptrOne") ? sub : foreign;
                joinType = 132;
                String ret = this.addJoin(label, field, label2, joinTable.getIndexPointerFieldName(), joinTable, joinType, location);
                this.leftJoinedImplicit.add(ret);
                return ret;
            }
        }
        if (fi.getType().equals("ptr")) {
            return this.addJoin(label, field, label2, foreign.getIndexPointerFieldName(), foreign, joinType, location);
        }
        if (fi.getType().equals("ptrOne")) {
            return this.addJoin(label, field, label2, sub.getIndexPointerFieldName(), sub, joinType, location);
        }
        if (fi.getType().equals("setComplex") || fi.getType().equals("setintEnum") || fi.getType().equals("setcharEnum")) {
            return this.addJoin(label, index, label2, index, sub, joinType, location);
        }
        if (fi.getType().equals("set")) {
            label2 = label + "x";
            while (this.findLabelType(label2) != null) {
                label2 = label2 + "x";
            }
            this.addJoin(label, index, label2, index, sub, joinType, location);
            this.labels.put(label2, sub);
            if (joinType == 132 && this.leftJoinedImplicit.contains(label)) {
                this.leftJoinedImplicit.add(label2);
            }
            String label3 = label;
            if (labelf != null) {
                label3 = labelf;
            }
            while (this.findLabelType(label3) != null) {
                label3 = label3 + "x";
            }
            return this.addJoin(label2, sub.getSetMemberFieldName(), label3, foreign.getIndexPointerFieldName(), foreign, joinType, location);
        }
        throw new SemanticException("\"" + field + "\" is not a set or pointer in makumba type \"" + type.getName() + "\"", "", location.getLine(), location.getColumn());
    }

    public void addFrom(String frm, AST labelAST, int joinType) throws SemanticException {
        block9: {
            String label = labelAST.getText();
            String iterator = frm;
            this.explicitLabels.add(label);
            DataDefinition type = null;
            try {
                type = this.ddp.getDataDefinition(iterator);
            }
            catch (DataDefinitionNotFoundError e) {
            }
            catch (DataDefinitionParseError p) {
                throw new SemanticException(p.getMessage(), "", labelAST.getLine(), labelAST.getColumn());
            }
            if (type != null) {
                this.setLabelType(label, type, labelAST);
                this.fromLabels.put(label, type);
                return;
            }
            int i = iterator.indexOf(46);
            if (i > 0) {
                String lbl = iterator.substring(0, i);
                while (true) {
                    lbl = this.findLabel(frm, lbl, labelAST);
                    String field = iterator = iterator.substring(i + 1);
                    i = iterator.indexOf(46);
                    if (i == -1) {
                        if (this.findLabelType(label) != null) {
                            throw new SemanticException("label defined twice: " + label, "", labelAST.getLine(), labelAST.getColumn());
                        }
                        this.join(lbl, field, label, joinType, labelAST);
                        break block9;
                    }
                    field = iterator.substring(0, i);
                    lbl = this.join(lbl, field, null, joinType, labelAST);
                }
            }
            if (this.findLabelType(frm) == null) {
                throw new SemanticException("could not find type \"" + frm + "\"", "", labelAST.getLine(), labelAST.getColumn());
            }
            this.aliases.put(label, frm);
        }
    }

    private String findLabel(String frm, String lbl, AST location) throws SemanticException {
        if (this.labels.get(lbl) == null) {
            String lbl1 = this.aliases.get(lbl);
            if (lbl1 == null) {
                if (this.parent != null) {
                    lbl1 = this.parent.findLabel(frm, lbl, location);
                } else {
                    throw new SemanticException("could not find type \"" + frm + "\" or label \"" + lbl + "\"", "", location.getLine(), location.getColumn());
                }
            }
            lbl = lbl1;
        }
        return lbl;
    }

    private void setLabelType(String label, DataDefinition type, AST location) throws SemanticException {
        if (this.findLabelType(label) != null) {
            throw new SemanticException("label defined twice: " + label, "", location.getLine(), location.getColumn());
        }
        this.labels.put(label, type);
    }

    DataDefinition findLabelType(String label) {
        DataDefinition d = this.labels.get(label);
        if (d == null && this.parent != null) {
            return this.parent.findLabelType(label);
        }
        return d;
    }

    protected void writeFrom(NameResolver.TextList ret) {
        boolean comma = false;
        this.wroteRange = false;
        Enumeration<String> e = this.fromLabels.keys();
        while (e.hasMoreElements()) {
            String label = e.nextElement();
            if (comma) {
                ret.append(" JOIN ");
            }
            comma = true;
            ret.append(this.getTableName(label)).append(" ").append(label);
            this.wroteRange = true;
        }
    }

    DataDefinition getTableName(String label) {
        return this.findLabelType(label);
    }

    String getFieldName(String label, String field, NameResolver nr) {
        DataDefinition ri = this.findLabelType(label);
        try {
            return nr.resolveFieldName(ri, field);
        }
        catch (NullPointerException e) {
            return field;
        }
    }

    protected void writeJoins(NameResolver.TextList ret) {
        Enumeration<Join> e = this.joins.elements();
        while (e.hasMoreElements()) {
            Join j = e.nextElement();
            if (this.walker.optimizeJoins && !this.isFieldUsed(j)) {
                this.rewriteProjections(j);
                continue;
            }
            if (this.wroteRange) {
                switch (j.joinType) {
                    case 132: {
                        ret.append(" LEFT");
                        break;
                    }
                    case 133: {
                        ret.append(" RIGHT");
                        break;
                    }
                    case 23: {
                        ret.append(" FULL");
                    }
                }
                ret.append(" JOIN ");
            }
            this.wroteRange = true;
            ret.append(this.getTableName(j.label2)).append(" ").append(j.label2);
            NameResolver.TextList cond = ret;
            if (!this.isCorrelated(j)) {
                ret.append(" ON ");
            } else {
                cond = new NameResolver.TextList();
                this.filters.add(cond);
            }
            this.joinCondition(cond, j);
        }
    }

    private void rewriteProjections(Join j) {
        NameResolver.TextList text = this.labelText.get(j.label2);
        if (text == null) {
            if (!this.walker.isAnalysisQuery()) {
                Logger.getLogger("org.makumba.db.query.compilation").warning("unused label: " + j.label2 + " in query " + this.walker.query);
            }
            return;
        }
        text.clear();
        text.append(this.makeTextList(j.label1, j.field1));
    }

    private NameResolver.TextList findLabelText(String label) {
        if (this.labels.get(label) == null) {
            return this.parent.findLabelText(label);
        }
        return this.addLabelText(label, this.labels.get(label).getIndexPointerFieldName());
    }

    private boolean isFieldUsed(Join j) {
        return this.labelFields.contains(j.label2);
    }

    private boolean isCorrelated(Join j) {
        return this.labels.get(j.label1) == null;
    }

    private void joinCondition(NameResolver.TextList ret, Join j) {
        ret.append(j.label1).append(".").append(this.getTableName(j.label1), j.field1).append("= ").append(j.label2).append(".").append(this.getTableName(j.label2), j.field2);
    }

    public NameResolver.TextList selectLabel(String label, MqlNode node) {
        DataDefinition dd = this.labels.get(label);
        if (dd == null) {
            return this.parent.selectLabel(label, node);
        }
        String field = null;
        if (dd.getParentField() != null) {
            String stp = dd.getParentField().getType();
            if (stp.equals("setintEnum") || stp.equals("setcharEnum")) {
                field = "enum";
                this.labelFields.add(label);
                node.setMakType(dd.getFieldDefinition(dd.getSetMemberFieldName()));
            }
            if (stp.equals("setComplex")) {
                this.labelFields.add(label);
            }
        }
        if (field == null) {
            field = dd.getIndexPointerFieldName();
            node.setMakType(this.walker.currentContext.ddp.makeFieldDefinition("x", "ptr " + dd.getName()));
        }
        return this.addLabelText(label, field);
    }

    private NameResolver.TextList addLabelText(String label, String field) {
        NameResolver.TextList text = this.labelText.get(label);
        if (text == null) {
            text = this.makeTextList(label, field);
            this.labelText.put(label, text);
        }
        return text;
    }

    private NameResolver.TextList makeTextList(String label, String field) {
        NameResolver.TextList text = new NameResolver.TextList();
        text.append(label).append(".").append(this.labels.get(label), field);
        return text;
    }

    public void selectField(String label, String field, MqlDotNode mqlDotNode) throws SemanticException {
        DataDefinition labelType = this.labels.get(label);
        if (labelType == null) {
            this.parent.selectField(label, field, mqlDotNode);
            return;
        }
        if (field.equals("id") && labelType.getFieldDefinition("id") == null) {
            mqlDotNode.setTextList(this.selectLabel(label, mqlDotNode));
            return;
        }
        if (labelType.getFieldDefinition(field) == null) {
            throw new SemanticException("No such field " + field + " in " + labelType, "", mqlDotNode.getLine(), mqlDotNode.getColumn());
        }
        this.labelFields.add(label);
        mqlDotNode.setTextList(this.makeTextList(label, field));
        mqlDotNode.setMakType(labelType.getFieldDefinition(field));
    }

    class Join {
        String label1;
        String field1;
        String label2;
        String field2;
        int joinType;

        public Join(String l1, String f1, String l2, String f2, int joinType) {
            this.label1 = l1;
            this.label2 = l2;
            this.field1 = f1;
            this.field2 = f2;
            this.joinType = joinType;
        }

        public String toString() {
            return this.label1 + "." + this.field1 + " JOIN " + this.label2 + "." + this.field2;
        }
    }
}

