/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy.servlet.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.tidy.servlet.RepositoryFactory;
import org.w3c.tidy.servlet.ResponseRecordRepository;
import org.w3c.tidy.servlet.data.DefaultRepositoryFactory;

public class JTidyServletProperties {
    public static final String DEFAULT_FILENAME = "JTidyServlet.properties";
    public static final String PROPERTY_CLASS_REPOSITORYFACTORY = "repositoryFactory.class";
    public static final String PROPERTY_STRING_IMAGENAMEPREFIX = "imageNamePrefix";
    public static final String PROPERTY_STRING_IMAGENAMEEXTENSION = "imageNameExtension";
    public static final String PROPERTY_STRING_IMAGE_WIDTH = "imageWidth";
    public static final String PROPERTY_STRING_IMAGE_HEIGHT = "imageHeight";
    public static final String PROPERTY_INT_IMAGEGETTIMEOUT = "imageGetTimeout";
    public static final String JTIDYSERVLET_URI = "JTidyServletURI";
    public static final String PROPERTY_BOOLEAN_XHTML = "xhtml";
    private static Log log = LogFactory.getLog((Class)(class$org$w3c$tidy$servlet$properties$JTidyServletProperties == null ? (class$org$w3c$tidy$servlet$properties$JTidyServletProperties = JTidyServletProperties.class$("org.w3c.tidy.servlet.properties.JTidyServletProperties")) : class$org$w3c$tidy$servlet$properties$JTidyServletProperties));
    private Properties properties = new Properties();
    private static JTidyServletProperties instance;
    static /* synthetic */ Class class$org$w3c$tidy$servlet$properties$JTidyServletProperties;

    private JTidyServletProperties() {
        this.loadFile(DEFAULT_FILENAME);
    }

    public void loadFile(String fileName) {
        if (fileName == null) {
            return;
        }
        Properties tmpProperties = new Properties();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);
        if (in != null) {
            try {
                tmpProperties.load(in);
                this.properties.putAll((Map<?, ?>)tmpProperties);
                log.info((Object)("property file " + fileName + " loaded"));
            }
            catch (IOException e) {
                log.error((Object)("Error loading JTidy property file " + fileName), (Throwable)e);
            }
        } else {
            log.error((Object)("Properties file [" + fileName + "] not found in class path"));
        }
    }

    public static JTidyServletProperties getInstance() {
        if (instance == null) {
            instance = new JTidyServletProperties();
        }
        return instance;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }

    public int getIntProperty(String key, int defaultValue) {
        int intValue = defaultValue;
        try {
            String sValue = this.getProperty(key);
            if (sValue == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Value " + key + " does not exists"));
                }
            } else {
                intValue = Integer.parseInt(sValue);
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Invalid value for \"" + key + "\" property: value=\"" + this.getProperty(key) + "\"; using default \"" + defaultValue + "\""));
        }
        return intValue;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        boolean intValue = defaultValue;
        String sValue = this.getProperty(key);
        if (sValue == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Value " + key + " does not exists"));
            }
        } else {
            intValue = "true".equalsIgnoreCase(sValue);
        }
        return intValue;
    }

    public RepositoryFactory getRepositoryFactoryInstance() {
        String className = this.getProperty(PROPERTY_CLASS_REPOSITORYFACTORY);
        if (className != null) {
            try {
                Class<?> classProperty = Class.forName(className);
                return (RepositoryFactory)classProperty.newInstance();
            }
            catch (Throwable e) {
                log.error((Object)("Error creating RepositoryFactory " + className), e);
            }
        }
        return new DefaultRepositoryFactory();
    }

    public ResponseRecordRepository getRepositoryInstance(HttpSession httpSession) {
        return this.getRepositoryFactoryInstance().getRepositoryInstance(httpSession);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

