/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.PrintWriter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.commons.ControllerHandler;
import org.makumba.commons.MakumbaResourceServlet;
import org.makumba.commons.ServletObjects;
import org.makumba.db.makumba.UniquenessServlet;
import org.makumba.devel.DevelUtils;
import org.makumba.devel.relations.RelationCrawlerTool;
import org.makumba.forms.responder.ValueEditor;
import org.makumba.list.MakumbaDownloadServlet;
import org.makumba.providers.Configuration;

public class MakumbaToolsControllerHandler
extends ControllerHandler {
    public boolean beforeFilter(ServletRequest req, ServletResponse res, FilterConfig conf, ServletObjects httpServletObjects) throws Exception {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String path = request.getRequestURI().replace(request.getContextPath(), "");
        if (path.startsWith(Configuration.getMakumbaUniqueLocation())) {
            new UniquenessServlet().doGet(request, response);
            return false;
        }
        if (path.startsWith(Configuration.getMakumbaResourcesLocation())) {
            new MakumbaResourceServlet().doGet(request, response);
            return false;
        }
        if (path.startsWith(Configuration.getMakumbaDownloadLocation())) {
            new MakumbaDownloadServlet().doGet(request, response);
            return false;
        }
        if (path.startsWith(Configuration.getMakumbaValueEditorLocation())) {
            new ValueEditor().doPost(request, response);
            return false;
        }
        if (path.startsWith(Configuration.getMakumbaRelationCrawlerLocation())) {
            new RelationCrawlerTool().doPost(request, response);
            return false;
        }
        if (path.startsWith(Configuration.getMakumbaToolsLocation())) {
            if (!path.equals(Configuration.getMakumbaToolsLocation() + "/")) {
                response.sendRedirect(request.getContextPath() + Configuration.getMakumbaToolsLocation() + "/");
                return false;
            }
            PrintWriter w = res.getWriter();
            res.setContentType("text/html");
            DevelUtils.writePageBegin(w);
            DevelUtils.writeStyles(w, request.getContextPath());
            DevelUtils.writeTitleAndHeaderEnd(w, "Makumba Configuration");
            DevelUtils.printPageHeader(w, "Makumba Configuration");
            w.println("</table>");
            w.println("<h3>Welcome to the Makumba Configuration page!</h3>");
            w.println("<p>This page gives you a short overview on the configuration of this Makumba installation and basic information on the tools available.</p>");
            w.println("<h4>Makumbat Tools</h4>");
            w.println("<table border=\"1\" _width=\"100%\">");
            w.println("  <tr>");
            w.println("    <th>Name</th>");
            w.println("    <th>Description</th>");
            w.println("    <th>Config file key</th>");
            w.println("    <th>Location</th>");
            w.println("  </tr>");
            this.writeDescr(w, "Download", "Download of file-type data", "makumbaDownload", Configuration.getMakumbaDownloadLocation(), request.getContextPath());
            this.writeDescr(w, "Resources", "Resources (javaScript, images,...) needed for calendar editor, live-validation, ...", "makumbaResources", Configuration.getMakumbaResourcesLocation(), request.getContextPath());
            this.writeDescr(w, "Uniqueness", "AJAX uniqueness check", "makumbaUniquenessValidator", Configuration.getMakumbaUniqueLocation(), request.getContextPath());
            this.writeDescr(w, "Value Editor", "Tool for edit-in-place", "makumbaValueEditor", Configuration.getMakumbaValueEditorLocation(), request.getContextPath());
            this.writeDescr(w, "DataDefinition viewer", "View data definitions", "mddViewer", Configuration.getMddViewerLocation(), request.getContextPath());
            this.writeDescr(w, "Java Viewer", "View Java Business Logics", "javaViewer", Configuration.getJavaViewerLocation(), request.getContextPath());
            this.writeDescr(w, "Logic Discover", "View Business Logics associated with a certain page", "logicDiscovery", Configuration.getLogicDiscoveryViewerLocation(), request.getContextPath());
            this.writeDescr(w, "Data lister", "List data from a certain type", "dataLister", Configuration.getDataListerLocation(), request.getContextPath());
            this.writeDescr(w, "Object viewer", "View a specific object", "dataObjectViewer", Configuration.getDataViewerLocation(), request.getContextPath());
            this.writeDescr(w, "Data query", "Free-form OQL queries", "dataQueryTool", Configuration.getDataQueryLocation(), request.getContextPath());
            this.writeDescr(w, "Pointer value converter", "Convert pointer values between internal/external/DB form", "objectIdConverter", Configuration.getObjectIdConverterLocation(), request.getContextPath());
            this.writeDescr(w, "Code generator", "Generate forms & lists from data definitions", "codeGenerator", Configuration.getCodeGeneratorLocation(), request.getContextPath());
            this.writeDescr(w, "Reference Checker", "Check for broken references and show status of foreign key creation", "referenceChecker", Configuration.getReferenceCheckerLocation(), request.getContextPath());
            w.println("</table>");
            w.println("<h4>Controller settings</h4>");
            w.println("<table border=\"1\" _width=\"100%\">");
            w.println("  <tr>");
            w.println("    <th>Name</th>");
            w.println("    <th>Description</th>");
            w.println("    <th>Config file key</th>");
            w.println("    <th>Value</th>");
            w.println("  </tr>");
            this.writeDescr(w, "Transaction Provider", "", "defaultTransactionProvider", "");
            this.writeDescr(w, "Form reaload", "Wether forms shall be reloaded on validation errors", "reloadFormOnError", Configuration.getReloadFormOnErrorDefault());
            this.writeDescr(w, "Clientside validation", "Wether client-side validation is enabled, and if it is live or on form submission", "clientSideValidation", Configuration.getClientSideValidationDefault());
            w.println("</table>");
            w.println("<h4>Input style settings</h4>");
            DevelUtils.writePageEnd(w);
            return false;
        }
        return true;
    }

    private void writeDescr(PrintWriter w, String name, String desc, String key, Object value) {
        w.println("  <tr>");
        w.println("    <td>" + name + "</td> <td>" + desc + "</td> <td>" + key + "</td> <td>" + value + "</td>");
        w.println("  </tr>");
    }

    private void writeDescr(PrintWriter w, String name, String desc, String key, String loc, String contextPath) {
        w.println("  <tr>");
        w.println("    <td>" + name + "</td> <td>" + desc + "</td> <td>" + key + "</td> <td> <a href=\"" + contextPath + loc + "\">" + contextPath + loc + "</a> </td>");
        w.println("  </tr>");
    }
}

