/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.makumba.DataDefinition;
import org.makumba.commons.ReservedKeywords;
import org.makumba.db.makumba.sql.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameResolver {
    private Properties config;
    protected HashMap<String, HashMap<String, String>> fieldDBNames = new HashMap();

    public NameResolver() {
        this(null);
    }

    public NameResolver(Properties configurationProperties) {
        this.config = configurationProperties;
        if (this.config == null) {
            this.config = new Properties();
        }
    }

    public String getKey() {
        return this.getClass().getName() + this.config;
    }

    public String resolveTypeName(DataDefinition dd) {
        return this.getTableNameFromConfig(this.config, dd);
    }

    public String resolveFieldName(DataDefinition dd, String fieldName) {
        HashMap<String, String> resolvedCache = this.fieldDBNames.get(dd.getName());
        if (resolvedCache == null) {
            resolvedCache = this.makeTypeCache(dd);
        }
        return resolvedCache.get(fieldName);
    }

    private String getTypeNameInSource(String name) {
        boolean addUnderscore = true;
        String s = this.config.getProperty("addUnderscore");
        if (s != null) {
            addUnderscore = s.equals("true");
        }
        if (!addUnderscore) {
            name = "." + name.toLowerCase();
        }
        name = name.replace('.', '_').replace('(', '_').replace(')', '_').replace('>', '_').replace('-', '_');
        if ((name = name + (addUnderscore ? "_" : "")).length() <= this.getMaxTableNameLength()) {
            return name;
        }
        String hash = Integer.toString(name.hashCode(), 36).replace('-', '_');
        String shortname = name.substring(0, this.getMaxTableNameLength() - 3 - hash.length());
        return shortname + "___" + hash;
    }

    public String getTableNameFromConfig(Properties config, DataDefinition dd) {
        String tbname = config.getProperty(dd.getName());
        if (tbname == null) {
            String key = Database.findConfig(config, dd.getName());
            String shortname = dd.getName();
            if (key != null) {
                shortname = config.getProperty(key) + dd.getName().substring(key.length());
            }
            tbname = this.getTypeNameInSource(shortname);
        } else if (tbname.indexOf(46) != -1) {
            tbname = this.getTypeNameInSource(tbname);
        }
        return tbname;
    }

    private String getFieldNameInSource(String field) {
        boolean addUnderscore = true;
        String s = this.config.getProperty("addUnderscore");
        if (s != null) {
            addUnderscore = s.equals("true");
        }
        String name = field;
        if (!addUnderscore && !s.startsWith("TS_")) {
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        name = name.replace('.', '_');
        if ((name = name + (addUnderscore ? "_" : "")).length() <= this.getMaxFieldNameLength()) {
            return name;
        }
        String hash = Integer.toString(name.hashCode(), 36).replace('-', '_');
        String shortname = name.substring(0, this.getMaxFieldNameLength() - 3 - hash.length());
        return shortname + "___" + hash;
    }

    private boolean checkDuplicateFieldName(String name, DataDefinition dd) {
        Enumeration<String> e = dd.getFieldNames().elements();
        while (e.hasMoreElements()) {
            String fieldName = e.nextElement();
            if (dd.getFieldDefinition(fieldName).getType().startsWith("set") || this.fieldDBNames.get(dd.getName()).get(fieldName) == null || !this.fieldDBNames.get(dd.getName()).get(fieldName).toLowerCase().equals(name.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private HashMap<String, String> makeTypeCache(DataDefinition dd) {
        HashMap<String, String> resolvedCache = new HashMap<String, String>();
        this.fieldDBNames.put(dd.getName(), resolvedCache);
        Enumeration<String> e = dd.getFieldNames().elements();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            if (dd.getFieldDefinition(name).getType().startsWith("set")) continue;
            String resolved = this.config.getProperty(this.getTableNameFromConfig(this.config, dd) + "#" + name);
            if (resolved == null) {
                resolved = this.checkReserved(this.getFieldNameInSource(name));
                while (this.checkDuplicateFieldName(resolved, dd)) {
                    resolved = resolved + "_";
                }
            }
            resolvedCache.put(name, resolved);
        }
        return resolvedCache;
    }

    private int getMaxTableNameLength() {
        return 64;
    }

    private int getMaxFieldNameLength() {
        return 64;
    }

    public String dotToUnderscore(String name) {
        return name.replaceAll("\\.", "_");
    }

    public String arrowToDot(String name) {
        return name.replaceAll("->", ".");
    }

    public String arrowToDoubleDot(String name) {
        return name.replaceAll("->", "..");
    }

    public String arrowToDoubleUnderscore(String name) {
        return name.replaceAll("->", "__");
    }

    public String checkReserved(String name) {
        if (ReservedKeywords.getReservedKeywords().contains(name)) {
            return this.arrowToDoubleUnderscore(name + "_");
        }
        return this.arrowToDoubleUnderscore(name);
    }

    public String mddToSQLName(String name) {
        name = this.dotToUnderscore(name);
        name = this.arrowToDoubleUnderscore(name);
        return name + "_";
    }

    public static class Resolvable {
        DataDefinition dd;
        String field;

        public String resolve(NameResolver nr) {
            if (this.field != null) {
                return nr.resolveFieldName(this.dd, this.field);
            }
            return nr.resolveTypeName(this.dd);
        }
    }

    public static class TextList {
        ArrayList<Object> content = new ArrayList();
        StringBuffer lastBuffer;
        private static NameResolver defaultNameResolver = new NameResolver();

        public TextList append(Object o) {
            if (o instanceof String) {
                if (this.lastBuffer != null) {
                    this.lastBuffer.append(o);
                } else {
                    this.lastBuffer = new StringBuffer();
                    this.lastBuffer.append(o);
                    this.content.add(this.lastBuffer);
                }
                return this;
            }
            this.lastBuffer = null;
            if (o instanceof DataDefinition) {
                Resolvable r = new Resolvable();
                r.dd = (DataDefinition)o;
                o = r;
            }
            this.content.add(o);
            return this;
        }

        public TextList append(DataDefinition dd, String field) {
            Resolvable r = new Resolvable();
            r.dd = dd;
            r.field = field;
            return this.append(r);
        }

        public void clear() {
            this.content.clear();
        }

        public String toString() {
            return this.toString(defaultNameResolver);
        }

        public String toString(NameResolver nr) {
            StringBuffer ret = new StringBuffer();
            for (Object o : this.content) {
                if (o instanceof StringBuffer) {
                    ret.append(o);
                    continue;
                }
                if (o instanceof Resolvable) {
                    Resolvable rs = (Resolvable)o;
                    ret.append(rs.resolve(nr));
                    continue;
                }
                if (!(o instanceof TextList)) continue;
                ret.append(((TextList)o).toString(nr));
            }
            return ret.toString();
        }
    }
}

