/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.ProgrammerError;
import org.makumba.providers.query.FunctionInliner;

public class QuerySectionProcessor {
    StringBuffer query;
    ArrayList<SubqueryData> subqueries = new ArrayList();
    private String initialFrom;
    boolean closed = false;
    public static final String PATTERN_ALL_FUNCTION_CALL_BEGIN = "((" + FunctionInliner.NAME + ")" + "(" + "[\\s]*" + "\\." + "[\\s]*" + FunctionInliner.NAME + ")*)" + "[\\s]*" + "\\(";
    public static final Pattern allFunctionBegin = Pattern.compile(PATTERN_ALL_FUNCTION_CALL_BEGIN);
    public static final Pattern ident = Pattern.compile(FunctionInliner.NAME);

    public QuerySectionProcessor(String query, int startPoint) {
        int i;
        int[] levels = new int[query.length()];
        this.query = new StringBuffer(query);
        String lowerQuery = query.toLowerCase();
        int parLevel = 0;
        for (int i2 = 0; i2 < query.length(); ++i2) {
            if (query.charAt(i2) == '(') {
                // empty if block
            }
            levels[i2] = ++parLevel;
            if (query.charAt(i2) != ')') continue;
            --parLevel;
        }
        if (parLevel != 0) {
            throw new ProgrammerError("Unbalanced parantheses in query " + query);
        }
        int myLevel = levels[startPoint];
        int min = startPoint;
        int max = startPoint + 1;
        for (int lev = myLevel; lev >= 0; --lev) {
            SubqueryData sd = new SubqueryData();
            this.subqueries.add(0, sd);
            for (i = min; i >= 0; --i) {
                if (sd.start == -1) {
                    if (levels[i] > lev) {
                        levels[i] = -1;
                        continue;
                    }
                    if (levels[i] >= lev || levels[i] == -1) continue;
                    min = i + 1;
                    sd.setStart(min);
                    if (!lowerQuery.substring(min).trim().startsWith("select ")) continue;
                    sd.setProjectionStart(lowerQuery.substring(min).indexOf("select") + 7);
                    continue;
                }
                if (levels[i] < lev) continue;
                levels[i] = -1;
            }
            if (sd.start == -1) {
                sd.setStart(0);
                if (lowerQuery.trim().startsWith("select ")) {
                    sd.setProjectionStart(lowerQuery.indexOf("select") + 7);
                }
            }
            for (i = max; i < query.length(); ++i) {
                if (sd.end == -1) {
                    if (levels[i] > lev) {
                        levels[i] = -1;
                        continue;
                    }
                    if (levels[i] >= lev || levels[i] == -1) continue;
                    max = i;
                    sd.setEnd(max);
                    continue;
                }
                if (levels[i] < lev) continue;
                levels[i] = -1;
            }
            if (sd.end != -1) continue;
            sd.setEnd(query.length());
        }
        int findIndex = 0;
        while ((findIndex = lowerQuery.indexOf("from ", findIndex)) != -1) {
            if (levels[findIndex] != -1) {
                this.subqueries.get(levels[findIndex]).setFromStart(findIndex + 5);
            }
            ++findIndex;
        }
        for (int lev = 1; lev <= myLevel; ++lev) {
            if (this.subqueries.get(lev).fromStart != -1) continue;
            for (i = 0; i < levels.length; ++i) {
                if (levels[i] < lev) continue;
                int n = i;
                levels[n] = levels[n] - 1;
            }
            this.subqueries.remove(lev);
            --lev;
            --myLevel;
        }
        findIndex = 0;
        while ((findIndex = lowerQuery.indexOf(" where ", findIndex)) != -1) {
            if (levels[findIndex] != -1) {
                this.subqueries.get(levels[findIndex]).setWhereStart(findIndex + 7);
            }
            ++findIndex;
        }
        findIndex = 0;
        while ((findIndex = lowerQuery.indexOf(" order by ", findIndex)) != -1) {
            if (levels[findIndex] != -1) {
                this.subqueries.get(levels[findIndex]).checkWhereEnd(findIndex);
                this.subqueries.get(levels[findIndex]).checkFromEnd(findIndex);
            }
            ++findIndex;
        }
        findIndex = 0;
        while ((findIndex = lowerQuery.indexOf(" group by ", findIndex)) != -1) {
            if (levels[findIndex] != -1) {
                this.subqueries.get(levels[findIndex]).checkWhereEnd(findIndex);
                this.subqueries.get(levels[findIndex]).checkFromEnd(findIndex);
            }
            ++findIndex;
        }
        StringBuffer from = new StringBuffer();
        String separator = "";
        for (SubqueryData sd : this.subqueries) {
            sd.pack();
            if (sd.fromStart == -1) continue;
            from.append(separator).append(sd.getFrom());
            separator = ",";
        }
        this.initialFrom = from.toString();
    }

    public String getInitialFrom() {
        return this.initialFrom;
    }

    public String getProjectionText() {
        return this.subqueries.get(0).getProjection();
    }

    public void replaceParameter(String name, String parameterInline) {
        int index = 0;
        while ((index = this.query.indexOf(name, index)) != -1) {
            if (this.query.substring(0, index).trim().endsWith(".") || this.query.substring(index + name.length()).trim().startsWith("(")) {
                ++index;
                continue;
            }
            this.replaceExpr(index, name.length(), parameterInline);
            index += parameterInline.length();
        }
    }

    void replaceThis(String thisExpr) {
        int index = 0;
        while ((index = this.query.indexOf("this", index)) != -1) {
            this.replace(index, "this".length(), thisExpr);
        }
    }

    public void replaceExpr(int regionStart, int regionLength, String text) {
        this.replace(regionStart, regionLength, QuerySectionProcessor.paranthesize(this.query.substring(0, regionStart).trim(), this.query.substring(regionStart + regionLength).trim(), text));
    }

    private void replace(int regionStart, int regionLength, String text) {
        if (this.closed) {
            throw new IllegalStateException("Cannot add text after getText() was called");
        }
        for (SubqueryData dt : this.subqueries) {
            dt.shift(regionStart, text.length() - regionLength);
        }
        this.query.delete(regionStart, regionStart + regionLength);
        this.query.insert(regionStart, text);
    }

    public void addFromWhere(QuerySectionProcessor func, String thisExpr) {
        func.replaceThis(thisExpr);
    }

    public void addFromWhere(String from, String where) {
        if (this.closed) {
            throw new IllegalStateException("Cannot add text after getText() was called");
        }
        Insertion ins = new Insertion();
        ins.from = from;
        ins.where = where;
        this.subqueries.get(0).addInsertion(ins);
    }

    public String getText() {
        for (SubqueryData dt : this.subqueries) {
            dt.addFromWhere();
        }
        this.closed = true;
        return this.query.toString();
    }

    public String getWhere() {
        return this.subqueries.get(0).getWhere();
    }

    public String getFrom() {
        return this.subqueries.get(0).getFrom();
    }

    static String paranthesize(String before, String after, String expr) {
        String trimExpr = expr.trim();
        if (trimExpr.startsWith("(") && trimExpr.trim().endsWith(")")) {
            return trimExpr;
        }
        if (ident.matcher(trimExpr).matches() || (trimExpr.startsWith("$") || trimExpr.startsWith(":")) && ident.matcher(trimExpr.substring(1)).matches()) {
            return trimExpr;
        }
        try {
            Double.parseDouble(trimExpr);
            return trimExpr;
        }
        catch (NumberFormatException nfe) {
            if (trimExpr.startsWith("'") && trimExpr.endsWith("'")) {
                return trimExpr;
            }
            Matcher func = allFunctionBegin.matcher(trimExpr);
            if (func.find() && func.start() == 0 && trimExpr.endsWith(")")) {
                int level = 1;
                for (int i = func.group().length(); i < trimExpr.length() - 1; ++i) {
                    if (trimExpr.charAt(i) == '(') {
                        ++level;
                    }
                    if (trimExpr.charAt(i) == ')') {
                        --level;
                    }
                    if (level == 0) break;
                }
                if (level == 1) {
                    return trimExpr;
                }
            }
            if (before.endsWith("(") && after.startsWith(")")) {
                return trimExpr;
            }
            if ((before.toLowerCase().endsWith("select") || before.endsWith(",")) && (after.toLowerCase().startsWith("as") || after.startsWith(",") || after.toLowerCase().startsWith("from"))) {
                return trimExpr;
            }
            return "(" + trimExpr + ")";
        }
    }

    public static void main(String[] argv) {
        String[] queries = new String[]{"SELECT m.id AS col1,it.project.color AS col2,m.TS_create AS col3,it.project.id AS col4,it.subject AS col5 FROM projman.Message m JOIN m.item it WHERE (not exists(FROM projman.Item i join i.events  e WHERE  i=m.item AND e.who=:principal AND e.type IN (0, 2,3) )) AND m.ofMyBusiness() ORDER BY m.TS_create desc "};
        for (int i = 0; i < queries.length; ++i) {
            Matcher m = FunctionInliner.functionBegin.matcher(queries[i]);
            if (!m.find()) continue;
            new QuerySectionProcessor(queries[i], 0);
        }
    }

    static class Insertion {
        String from;
        String where;

        Insertion() {
        }

        public boolean contains(Insertion ins) {
            return this.from != null && this.from.indexOf(ins.from) != -1 && (ins.where == null && this.where == null || this.where != null && this.where.indexOf(ins.where) != -1);
        }
    }

    class SubqueryData {
        private int start = -1;
        private int end = -1;
        private int fromStart = -1;
        private int fromEnd = -1;
        private int whereStart = -1;
        private int whereEnd = -1;
        private int projectionStart = -1;
        private int projectionEnd = -1;
        ArrayList<Insertion> insertions = new ArrayList();
        Insertion myFromWhere = new Insertion();

        SubqueryData() {
        }

        public void setWhereStart(int index) {
            this.whereStart = index;
            this.whereEnd = this.end;
            this.checkFromEnd(index - 7);
        }

        public void checkFromEnd(int index) {
            if (this.fromStart != -1 && (this.fromEnd == -1 || this.fromEnd >= index)) {
                this.fromEnd = index;
            }
            if (this.projectionEnd >= index) {
                this.projectionEnd = index;
            }
        }

        public void checkWhereEnd(int index) {
            if (this.whereStart != -1 && (this.whereEnd == -1 || this.whereEnd >= index)) {
                this.whereEnd = index;
            }
        }

        public void setFromStart(int index) {
            this.projectionEnd = index - 5;
            this.fromStart = index;
            this.fromEnd = this.end;
        }

        public void setStart(int i) {
            this.start = i;
            this.projectionStart = i;
        }

        public void setProjectionStart(int i) {
            this.projectionStart = i;
        }

        public void setEnd(int i) {
            this.end = i;
            this.projectionEnd = i;
        }

        public void shift(int index, int delta) {
            this.end += delta;
            if (this.projectionStart > index) {
                this.projectionStart += delta;
            }
            if (this.fromStart > index) {
                this.fromStart += delta;
            }
            if (this.fromEnd > index) {
                this.fromEnd += delta;
            }
            if (this.whereStart > index) {
                this.whereStart += delta;
            }
            if (this.whereEnd > index) {
                this.whereEnd += delta;
            }
            if (this.projectionEnd > index) {
                this.projectionEnd += delta;
            }
        }

        public void addFromWhere() {
            for (Insertion ins : this.insertions) {
                this.addFromWhere(ins.from, ins.where);
            }
        }

        public void addFromWhere(String from, String where) {
            if (this.fromEnd == -1) {
                this.fromStart = this.end;
                this.fromEnd = this.end;
                QuerySectionProcessor.this.replace(this.fromEnd, 0, " FROM " + from);
                this.fromEnd = this.end;
            } else {
                QuerySectionProcessor.this.replace(this.fromEnd, 0, ", " + from);
            }
            if (where == null) {
                return;
            }
            if (this.whereStart == -1) {
                int x = this.fromEnd;
                QuerySectionProcessor.this.replace(this.fromEnd, 0, " WHERE " + where);
                this.whereEnd = this.fromEnd;
                this.fromEnd = x;
                this.whereStart = this.fromEnd + 7;
            } else {
                String wh;
                if (!where.trim().startsWith("(") || !where.trim().endsWith(")")) {
                    where = "(" + where + ")";
                }
                boolean para = (wh = this.getWhere().trim()).startsWith("(") && wh.endsWith(")");
                QuerySectionProcessor.this.replace(this.whereStart, 0, where + " AND " + (para ? "" : "("));
                if (!para) {
                    QuerySectionProcessor.this.replace(this.whereEnd, 0, ")");
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(QuerySectionProcessor.this.query, this.projectionStart, this.projectionEnd);
            if (this.fromStart != -1) {
                sb.append(" FROM ").append(QuerySectionProcessor.this.query, this.fromStart, this.fromEnd);
            }
            if (this.whereStart != -1) {
                sb.append(" WHERE ").append(QuerySectionProcessor.this.query, this.whereStart, this.whereEnd);
            }
            return sb.toString();
        }

        public String getWhere() {
            if (this.whereStart == -1) {
                return null;
            }
            return QuerySectionProcessor.this.query.substring(this.whereStart, this.whereEnd);
        }

        public String getFrom() {
            if (this.fromStart == -1) {
                return null;
            }
            return QuerySectionProcessor.this.query.substring(this.fromStart, this.fromEnd);
        }

        public String getProjection() {
            return QuerySectionProcessor.this.query.substring(this.projectionStart, this.projectionEnd);
        }

        public void addInsertion(Insertion ins) {
            if (this.myFromWhere.contains(ins)) {
                return;
            }
            for (Insertion in : this.insertions) {
                if (!in.contains(ins)) continue;
                return;
            }
            this.insertions.add(ins);
        }

        public void pack() {
            this.myFromWhere.from = this.getFrom();
            this.myFromWhere.where = this.getWhere();
        }
    }
}

