/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy.servlet.reports;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.tidy.TidyMessage;
import org.w3c.tidy.servlet.ResponseRecord;
import org.w3c.tidy.servlet.ResponseRecordRepository;
import org.w3c.tidy.servlet.properties.JTidyServletProperties;
import org.w3c.tidy.servlet.util.HTMLEncode;

public class Report {
    private boolean completePage = true;
    private boolean view;
    private boolean printSource;
    private boolean wrapSource = true;
    private boolean printHtmlResult = false;
    private int wrapLen = 0;
    private boolean xhtml;
    private static final String RESOURCE_JAVASCRIPT = "JTidyServletReport.js";
    private static final String RESOURCE_STYLESHEET = "JTidyServletReport.css";
    private Log log = LogFactory.getLog((Class)(class$org$w3c$tidy$servlet$reports$Report == null ? (class$org$w3c$tidy$servlet$reports$Report = Report.class$("org.w3c.tidy.servlet.reports.Report")) : class$org$w3c$tidy$servlet$reports$Report));
    StringBuffer out = new StringBuffer(1024);
    ResponseRecordRepository responseRecordRepository;
    static /* synthetic */ Class class$org$w3c$tidy$servlet$reports$Report;

    public Report(ResponseRecordRepository responseRecordRepository) {
        this.responseRecordRepository = responseRecordRepository;
        this.init();
    }

    public Report(HttpSession httpSession) {
        this.responseRecordRepository = JTidyServletProperties.getInstance().getRepositoryInstance(httpSession);
        this.init();
    }

    private void init() {
        JTidyServletProperties properties = JTidyServletProperties.getInstance();
        this.xhtml = properties.getBooleanProperty("xhtml", true);
    }

    public void print(Writer writer, String key) throws IOException {
        this.format(key);
        writer.write(this.out.toString());
    }

    void td(String str1, String str2) {
        this.td(str1);
        this.td(str2);
    }

    void td(String str) {
        this.out.append("<td>").append(str).append("</td>\n");
    }

    void tr() {
        this.out.append("</tr><tr>\n");
    }

    void identSpace(int ln) {
        if (ln < 10) {
            this.out.append("   ");
        } else if (ln < 100) {
            this.out.append("  ");
        } else if (ln < 1000) {
            this.out.append(" ");
        }
    }

    void format(String keyString) throws IOException {
        ResponseRecord record = null;
        if (this.responseRecordRepository == null) {
            this.log.info((Object)"No ResponseRecordRepository");
        } else {
            Object key = this.responseRecordRepository.getResponseID(keyString);
            record = this.responseRecordRepository.getRecord(key);
        }
        if (record == null) {
            this.out.append("No data for ").append(keyString);
            return;
        }
        if (this.view) {
            this.formatView(record);
        } else {
            this.formatReport(record);
        }
    }

    void formatView(ResponseRecord record) {
        if (this.printHtmlResult) {
            this.out.append(record.getHtmlOutput());
        } else {
            this.out.append(record.getHtmlInput());
        }
    }

    void printScript() {
        this.appendResource(RESOURCE_JAVASCRIPT);
    }

    void printStylesheet() {
        this.out.append("<style type=\"text/css\">\n");
        this.appendResource(RESOURCE_STYLESHEET);
        this.out.append("</style>\n");
    }

    void appendResource(String resourceName) {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        if (in == null) {
            this.log.warn((Object)("resource not found:" + resourceName));
            return;
        }
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(in));
        try {
            String strSource;
            while ((strSource = lnr.readLine()) != null) {
                this.out.append(strSource).append("\n");
            }
            lnr.close();
        }
        catch (IOException e) {
            this.log.error((Object)("Error Reading resource " + resourceName), (Throwable)e);
        }
    }

    void formatReport(ResponseRecord record) throws IOException {
        String strSource;
        if (this.completePage) {
            if (this.xhtml) {
                this.out.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
                this.out.append(" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
            } else {
                this.out.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"");
                this.out.append(" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
            }
            this.out.append("<html><head><title>JTidy Messages</title>");
            this.printStylesheet();
            this.out.append("</head><body>\n");
        }
        this.printScript();
        this.out.append("<table id=\"JTidyMessagesTable\" summary=\"\"><tr>");
        this.out.append("<td colspan=\"4\">JTidy Messages for request:" + record.getRequestID());
        this.out.append(" processed in " + record.getParsTime() + " milliseconds</td>");
        this.tr();
        this.out.append("<td colspan=\"4\">Validation Errors " + record.getParseErrors() + "</td>\n");
        this.tr();
        this.out.append("<td colspan=\"4\">Validation Warnings " + record.getParseWarnings() + "</td>\n");
        HashMap<Integer, TidyMessage> map = new HashMap<Integer, TidyMessage>();
        Vector<String> source = new Vector<String>();
        LineNumberReader lnr = new LineNumberReader(new StringReader(record.getHtmlInput()));
        while ((strSource = lnr.readLine()) != null) {
            source.add(strSource);
        }
        Iterator i = record.getMessages().iterator();
        while (i.hasNext()) {
            TidyMessage message = (TidyMessage)i.next();
            this.tr();
            Integer ln = new Integer(message.getLine());
            StringBuffer lineStr = new StringBuffer(300);
            lineStr.append("Line ");
            if (this.printSource) {
                lineStr.append("<a href=\"#line").append(ln).append("\" ");
                lineStr.append(" onclick=\"jTidyReportHighlight('").append(ln).append("')\" ");
                lineStr.append(">").append(ln).append("</a>");
            } else {
                lineStr.append(ln);
            }
            if (map.get(ln) == null) {
                lineStr.append("<a name=\"errline").append(ln).append("\"></a>");
            }
            lineStr.append(", ");
            this.td(lineStr.toString());
            this.td("column " + message.getColumn());
            this.td(message.getLevel().toString() + ":");
            StringBuffer messageStr = new StringBuffer(300);
            messageStr.append("<a title=\"");
            messageStr.append(HTMLEncode.encode((String)source.get(message.getLine() - 1)));
            messageStr.append("\">");
            messageStr.append(HTMLEncode.encode(message.getMessage()));
            messageStr.append("</a>");
            this.td(messageStr.toString());
            map.put(ln, message);
        }
        this.out.append("</tr>\n");
        this.out.append("</table>\n");
        if (this.printSource) {
            this.out.append("<div>");
            if (this.xhtml) {
                this.out.append("<br/>");
            } else {
                this.out.append("<br>");
            }
            this.out.append("Below is the source used for this validation:");
            this.out.append("<pre>");
            this.out.append("<a name=\"JTidyOriginalSource\"></a>");
            int ln = 0;
            for (int lnIdx = 0; lnIdx < source.size(); ++lnIdx) {
                ln = lnIdx + 1;
                String str = (String)source.get(lnIdx);
                TidyMessage message = (TidyMessage)map.get(new Integer(ln));
                this.out.append("<span id=\"srcline").append(ln).append("\"");
                if (message != null) {
                    this.out.append("class = \"JTidyReportSrcLineError\" ");
                }
                this.out.append(">");
                this.identSpace(ln);
                this.out.append("<a name=\"line");
                this.out.append(ln);
                this.out.append("\"></a><strong>");
                if (message == null) {
                    this.out.append(ln);
                } else {
                    this.out.append("<a href=\"#errline" + ln + "\">");
                    this.out.append(ln);
                    this.out.append("</a>");
                }
                this.out.append("</strong>");
                if (this.wrapSource || this.wrapLen != 0) {
                    int useWrapLen = this.wrapLen;
                    if (useWrapLen == 0) {
                        useWrapLen = 100;
                    }
                    str = this.wrap(str, useWrapLen);
                }
                if (message != null) {
                    this.out.append("<a title=\"");
                    this.out.append(message.getLevel().toString() + " :");
                    this.out.append(HTMLEncode.encode(message.getMessage()));
                    this.out.append("\">");
                }
                if (str.length() > 0) {
                    this.out.append("<code class=\"html\">&nbsp;");
                    this.out.append(HTMLEncode.encode(str));
                    this.out.append("</code>");
                }
                if (message != null) {
                    this.out.append("</a>");
                }
                this.out.append("</span>");
                this.out.append("\n");
            }
            this.out.append("<a name=\"line");
            this.out.append(ln + 1);
            this.out.append("\"></a>");
            this.out.append("EOF");
            this.out.append("</pre>");
            this.out.append("</div>");
        }
        if (this.printHtmlResult) {
            String str;
            this.out.append("<div>");
            if (this.xhtml) {
                this.out.append("<br/>");
            } else {
                this.out.append("<br>");
            }
            this.out.append("Below is the generated html code:");
            LineNumberReader lnrr = new LineNumberReader(new StringReader(record.getHtmlOutput()));
            this.out.append("<pre>");
            this.out.append("<a name=\"JTidyHtmlResult\"></a>");
            int ln = 0;
            while ((str = lnrr.readLine()) != null) {
                ln = lnrr.getLineNumber();
                this.identSpace(ln);
                this.out.append("<a name=\"resultLine");
                this.out.append(ln);
                this.out.append("\"></a><strong>");
                this.out.append(ln);
                this.out.append("</strong>");
                if (this.wrapSource || this.wrapLen != 0) {
                    int useWrapLen = this.wrapLen;
                    if (useWrapLen == 0) {
                        useWrapLen = 100;
                    }
                    str = this.wrap(str, useWrapLen);
                }
                if (str.length() > 0) {
                    this.out.append("<code>&nbsp;");
                    this.out.append(HTMLEncode.encode(str));
                    this.out.append("</code>");
                }
                this.out.append("\n");
            }
            this.out.append("<a name=\"resultLine");
            this.out.append(ln + 1);
            this.out.append("\"></a>");
            this.out.append("EOF");
            this.out.append("</pre>");
            this.out.append("</div>");
        }
        if (this.completePage) {
            this.out.append("</body></html>");
        }
    }

    private String wrap(String str, int wrapLen) {
        String identLine = "    ";
        int strLen = str.length();
        StringBuffer buffer = new StringBuffer(strLen + strLen / wrapLen + 3);
        char[] charAry = str.toCharArray();
        int idx = 0;
        int lineLen = 0;
        boolean inString = false;
        while (idx < charAry.length) {
            char c = charAry[idx];
            ++idx;
            buffer.append(c);
            if (++lineLen >= wrapLen && c == '>') {
                buffer.append('\n').append("    ");
                lineLen = 0;
            }
            if (c != '\"') continue;
            if (inString && lineLen >= wrapLen + 10) {
                buffer.append('\n').append("    ");
                lineLen = 0;
            }
            inString = !inString;
        }
        return buffer.toString();
    }

    public void setCompletePage(boolean completePage) {
        this.completePage = completePage;
    }

    public void setView(boolean view) {
        this.view = view;
    }

    public void setPrintSource(boolean printSource) {
        this.printSource = printSource;
    }

    public void setWrapSource(boolean wrapSource) {
        this.wrapSource = wrapSource;
    }

    public void setPrintHtmlResult(boolean printHtmlResult) {
        this.printHtmlResult = printHtmlResult;
    }

    public void setWrapLen(int wrapLen) {
        this.wrapLen = wrapLen;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

