/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.ArrayUtils;
import org.makumba.commons.ClassResource;
import org.makumba.providers.MakumbaINIFileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Serializable {
    public static final String PROPERTY_NOT_SET = "PROPERTY_NOT_SET";
    public static final String KEY_CLIENT_SIDE_VALIDATION = "clientSideValidation";
    public static final String KEY_RELOAD_FORM_ON_ERROR = "reloadFormOnError";
    public static final String KEY_DEFAULT_TRANSACTION_PROVIDER = "defaultTransactionProvider";
    public static final String MAKUMBA_CONF = "Makumba.conf";
    private static final String MAKUMBA_CONF_DEFAULT = "Makumba.conf.default";
    public static final String PLACEHOLDER_CONTEXT_PATH = "_CONTEXT_PATH_";
    private static String defaultClientSideValidation = "live";
    private static boolean defaultReloadFormOnError = true;
    private static final long serialVersionUID = 1L;
    private static final String defaultDataDefinitionProvider = "org.makumba.providers.datadefinition.makumba.MakumbaDataDefinitionFactory";
    public static final String KEY_CALENDAR_EDITOR = "calendarEditor";
    public static final String KEY_CALENDAR_EDITOR_LINK = "calendarEditorLink";
    public static final String KEY_MAKUMBA_TOOLS = "path";
    public static final String KEY_MDD_VIEWER = "mddViewer";
    public static final String KEY_JAVA_VIEWER = "javaViewer";
    public static final String KEY_LOGIC_DISCOVERY = "logicDiscovery";
    public static final String KEY_CODE_GENERATOR = "codeGenerator";
    public static final String KEY_DATA_QUERY_TOOL = "dataQueryTool";
    public static final String KEY_DATA_OBJECT_VIEWER = "dataObjectViewer";
    public static final String KEY_DATA_LISTER = "dataLister";
    public static final String KEY_OBJECT_ID_CONVERTER = "objectIdConverter";
    public static final String KEY_REFERENCE_CHECKER = "referenceChecker";
    public static final String KEY_RELATION_CRAWLER = "relationCrawler";
    public static final String KEY_REPOSITORY_URL = "repositoryURL";
    public static final String KEY_REPOSITORY_LINK_TEXT = "repositoryLinkText";
    public static final String KEY_MAKUMBA_VALUE_EDITOR = "makumbaValueEditor";
    public static final String KEY_MAKUMBA_UNIQUENESS_VALIDATOR = "makumbaUniquenessValidator";
    public static final String KEY_MAKUMBA_RESOURCES = "makumbaResources";
    public static final String KEY_MAKUMBA_DOWNLOAD = "makumbaDownload";
    private static final Map<String, String> allGenericDeveloperToolsMap = ArrayUtils.toMap((Object[])new String[][]{{"mddViewer", "Mdd viewer"}, {"javaViewer", "Business logics viewer"}, {"dataLister", "Data browser"}, {"dataQueryTool", "Data query"}, {"objectIdConverter", "Pointer value converter"}, {"referenceChecker", "Reference checker"}, {"relationCrawler", "Relation crawler"}});
    private static MakumbaINIFileReader defaultConfig;
    private static MakumbaINIFileReader applicationConfig;

    public static Map<String, String> getAllGenericDeveloperToolsMap() {
        return allGenericDeveloperToolsMap;
    }

    public static String getDataDefinitionProviderClass() {
        return defaultDataDefinitionProvider;
    }

    public static String getDefaultTransactionProviderClass() {
        return applicationConfig.getStringProperty("controllerConfig", KEY_DEFAULT_TRANSACTION_PROVIDER, defaultConfig);
    }

    public static String getClientSideValidationDefault() {
        return defaultClientSideValidation;
    }

    public static boolean getReloadFormOnErrorDefault() {
        return defaultReloadFormOnError;
    }

    public static boolean getCalendarEditorDefault() {
        return applicationConfig.getBooleanProperty("inputStyleConfig", KEY_CALENDAR_EDITOR, defaultConfig);
    }

    public static String getDefaultCalendarEditorLink(String contextPath) {
        return applicationConfig.getStringProperty("inputStyleConfig", KEY_CALENDAR_EDITOR_LINK, defaultConfig).replaceAll(PLACEHOLDER_CONTEXT_PATH, contextPath);
    }

    public static String getRepositoryURL() {
        return applicationConfig.getProperty("makumbaToolConfig", KEY_REPOSITORY_URL);
    }

    public static String getRepositoryLinkText() {
        return applicationConfig.getProperty("makumbaToolConfig", KEY_REPOSITORY_LINK_TEXT);
    }

    public static String getMakumbaToolsLocation() {
        String property = applicationConfig.getProperty("makumbaToolPaths", KEY_MAKUMBA_TOOLS);
        return property.endsWith("/") ? property.substring(0, property.length() - 1) : property;
    }

    public static String getMddViewerLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_MDD_VIEWER);
    }

    public static String getJavaViewerLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_JAVA_VIEWER);
    }

    public static String getLogicDiscoveryViewerLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_LOGIC_DISCOVERY);
    }

    public static String getDataViewerLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_DATA_OBJECT_VIEWER);
    }

    public static String getDataListerLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_DATA_LISTER);
    }

    public static String getDataQueryLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_DATA_QUERY_TOOL);
    }

    public static String getObjectIdConverterLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_OBJECT_ID_CONVERTER);
    }

    public static String getReferenceCheckerLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_REFERENCE_CHECKER);
    }

    public static String getCodeGeneratorLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_CODE_GENERATOR);
    }

    public static String getMakumbaValueEditorLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_MAKUMBA_VALUE_EDITOR);
    }

    public static String getMakumbaRelationCrawlerLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_RELATION_CRAWLER);
    }

    public static String getMakumbaUniqueLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_MAKUMBA_UNIQUENESS_VALIDATOR);
    }

    public static String getMakumbaResourcesLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_MAKUMBA_RESOURCES);
    }

    public static String getMakumbaDownloadLocation() {
        return Configuration.getMakumbaToolsLocation() + applicationConfig.getProperty("makumbaToolPaths", KEY_MAKUMBA_DOWNLOAD);
    }

    public static String getConfigProperty(String key) {
        return applicationConfig.getProperty("makumbaToolPaths", key);
    }

    public static Map<String, String> getLogicPackages() {
        return applicationConfig.getProperties("businessLogicPackages");
    }

    public static Map<String, String> getAuthorizationDefinitions() {
        return applicationConfig.getProperties("authorization");
    }

    public static String getApplicationConfigurationSource() {
        return applicationConfig != null ? applicationConfig.getSource() : null;
    }

    static {
        try {
            URL path = ClassResource.get(MAKUMBA_CONF_DEFAULT);
            Logger.getLogger("org.makumba.config").info("Loading internal default configuration from " + path);
            defaultConfig = new MakumbaINIFileReader(path);
            URL url = ClassResource.get(MAKUMBA_CONF);
            if (url != null) {
                Logger.getLogger("org.makumba.config").info("Loading application configuration from " + url);
                applicationConfig = new MakumbaINIFileReader(url);
            } else {
                Logger.getLogger("org.makumba.config").severe("No application configuration found -> using internal default configuration!");
                applicationConfig = defaultConfig;
                System.out.println(applicationConfig.sectionNames());
                System.out.println(applicationConfig.optionNames("controllerConfig"));
            }
            defaultClientSideValidation = applicationConfig.getStringProperty("controllerConfig", KEY_CLIENT_SIDE_VALIDATION, defaultConfig);
            defaultReloadFormOnError = applicationConfig.getBooleanProperty("controllerConfig", KEY_RELOAD_FORM_ON_ERROR, defaultConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

