/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list.tags;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import org.makumba.LogicException;
import org.makumba.ProgrammerError;
import org.makumba.analyser.PageCache;
import org.makumba.commons.MakumbaJspAnalyzer;
import org.makumba.list.engine.valuecomputer.ValueComputer;
import org.makumba.list.tags.GenericListTag;
import org.makumba.list.tags.MakumbaJspException;
import org.makumba.list.tags.QueryTag;

public class IfTag
extends GenericListTag
implements BodyTag {
    private static final long serialVersionUID = 1L;
    String testExpr;
    private static final Integer TRUE_INT = new Integer(1);

    public void setTest(String s) {
        this.testExpr = s;
    }

    public void setBodyContent(BodyContent bc) {
    }

    public void doInitBody() {
    }

    public void setTagKey(PageCache pageCache) {
        this.addToParentListKey(this.testExpr.trim());
    }

    public void doStartAnalyze(PageCache pageCache) {
        String te = this.testExpr;
        if (MakumbaJspAnalyzer.getQueryLanguage(pageCache).equals("hql")) {
            te = "case when " + this.testExpr + " then 1 else 0 end";
        }
        pageCache.cache("org.makumba.valueComputers", this.tagKey, ValueComputer.getValueComputerAtAnalysis(this, QueryTag.getParentListKey(this, pageCache), te, pageCache));
    }

    public void doEndAnalyze(PageCache pageCache) {
        ValueComputer vc = (ValueComputer)pageCache.retrieve("org.makumba.valueComputers", this.tagKey);
        vc.doEndAnalyze(pageCache);
        String type = vc.getType().getDataType();
        if (!"int".equals(type) && !"boolean".equals(type)) {
            throw new ProgrammerError("mak:if test expression must be of type 'int' or 'boolean'. In this case [" + (Object)((Object)this) + "], type is " + type);
        }
    }

    public int doAnalyzedStartTag(PageCache pageCache) throws JspException, LogicException {
        Object exprvalue = ((ValueComputer)pageCache.retrieve("org.makumba.valueComputers", this.tagKey)).getValue(this.getPageContext());
        if (exprvalue instanceof Integer) {
            int i = (Integer)exprvalue;
            if (i == 1) {
                return 1;
            }
            if (i == 0) {
                return 0;
            }
            throw new MakumbaJspException(this, "test expression in mak:if should result in 0 or 1; result is " + exprvalue);
        }
        if (exprvalue instanceof Boolean) {
            boolean b = (Boolean)exprvalue;
            if (b) {
                return 1;
            }
            return 0;
        }
        if (exprvalue == null) {
            return 0;
        }
        throw new MakumbaJspException(this, "test expression in mak:if should result in an Integer, result is " + exprvalue);
    }

    public String toString() {
        return "IF test=" + this.testExpr + " parameters: " + this.params;
    }
}

