/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy.servlet.filter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.tidy.servlet.TidyProcessor;
import org.w3c.tidy.servlet.filter.BufferedServletOutputStream;

public class BufferedServletResponse
extends HttpServletResponseWrapper {
    private HttpServletResponse response;
    protected BufferedServletOutputStream stream = null;
    protected PrintWriter writer = null;
    private boolean tee = false;
    protected boolean binary = false;
    private int originalContentLength = -1;
    protected TidyProcessor processor;
    private static Log log = LogFactory.getLog((Class)(class$org$w3c$tidy$servlet$filter$BufferedServletResponse == null ? (class$org$w3c$tidy$servlet$filter$BufferedServletResponse = BufferedServletResponse.class$("org.w3c.tidy.servlet.filter.BufferedServletResponse")) : class$org$w3c$tidy$servlet$filter$BufferedServletResponse));
    static /* synthetic */ Class class$org$w3c$tidy$servlet$filter$BufferedServletResponse;

    public BufferedServletResponse(HttpServletResponse httpServletResponse, TidyProcessor tidyProcessor) {
        super(httpServletResponse);
        this.response = httpServletResponse;
        this.processor = tidyProcessor;
    }

    public BufferedServletOutputStream createOutputStream() throws IOException {
        BufferedServletOutputStream stream = this.tee ? new BufferedServletOutputStream(this.response, this.processor, this.response.getOutputStream()) : new BufferedServletOutputStream(this.response, this.processor);
        stream.setBinary(this.binary);
        stream.setOriginalContentLength(this.originalContentLength);
        return stream;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        log.debug((Object)"getOutputStream");
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        if (!type.startsWith("text/html")) {
            this.binary = true;
            log.warn((Object)"JTidyFiler assigned to binary resource");
        }
    }

    public void setContentLength(int len) {
        log.debug((Object)("setContentLength " + len));
        if (this.tee || this.binary) {
            super.setContentLength(len);
        } else if (this.stream != null) {
            this.stream.setOriginalContentLength(len);
        } else {
            this.originalContentLength = len;
        }
    }

    public PrintWriter getWriter() throws IOException {
        log.debug((Object)"getWriter");
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this.stream = this.createOutputStream();
        String charEnc = this.response.getCharacterEncoding();
        this.writer = charEnc != null ? new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.stream), charEnc)) : new PrintWriter((OutputStream)((Object)this.stream));
        return this.writer;
    }

    public void finishResponse() {
        try {
            log.debug((Object)"finishResponse");
            if (this.writer != null) {
                log.debug((Object)"close writer");
                this.writer.close();
            } else if (this.stream != null) {
                log.debug((Object)"close stream");
                this.stream.close();
            }
        }
        catch (IOException e) {
            log.warn((Object)"Buffer close", (Throwable)e);
        }
    }

    public void setTee(boolean tee) {
        this.tee = tee;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

