/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.scanner;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DefaultDeploymentSorter;
import org.jboss.deployment.IncompleteDeploymentException;
import org.jboss.deployment.scanner.AbstractDeploymentScanner;
import org.jboss.deployment.scanner.DeploymentScanner;
import org.jboss.deployment.scanner.URLDeploymentScannerMBean;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.net.protocol.URLLister;
import org.jboss.net.protocol.URLListerFactory;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.NullArgumentException;
import org.jboss.util.StringPropertyReplacer;

public class URLDeploymentScanner
extends AbstractDeploymentScanner
implements DeploymentScanner,
URLDeploymentScannerMBean {
    protected List urlList = Collections.synchronizedList(new ArrayList());
    protected Set deployedSet = Collections.synchronizedSet(new HashSet());
    protected File serverHome;
    protected URL serverHomeURL;
    protected Comparator sorter;
    protected URLLister.URLFilter filter;
    protected IncompleteDeploymentException lastIncompleteDeploymentException;
    protected boolean doRecursiveSearch = true;
    static /* synthetic */ Class class$java$net$URL;

    public void setRecursiveSearch(boolean recurse) {
        this.doRecursiveSearch = recurse;
    }

    public boolean getRecursiveSearch() {
        return this.doRecursiveSearch;
    }

    public void setURLList(List list) {
        if (list == null) {
            throw new NullArgumentException("list");
        }
        boolean debug = this.log.isDebugEnabled();
        this.urlList.clear();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            if (url == null) {
                throw new NullArgumentException("list element");
            }
            this.addURL(url);
        }
        if (debug) {
            this.log.debug((Object)("URL list: " + this.urlList));
        }
    }

    public void setURLComparator(String classname) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.sorter = (Comparator)Thread.currentThread().getContextClassLoader().loadClass(classname).newInstance();
    }

    public String getURLComparator() {
        if (this.sorter == null) {
            return null;
        }
        return this.sorter.getClass().getName();
    }

    public void setFilter(String classname) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> filterClass = Thread.currentThread().getContextClassLoader().loadClass(classname);
        this.filter = (URLLister.URLFilter)filterClass.newInstance();
    }

    public String getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getClass().getName();
    }

    public List getURLList() {
        return new ArrayList(this.urlList);
    }

    public void addURL(URL url) {
        if (url == null) {
            throw new NullArgumentException("url");
        }
        this.urlList.add(url);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Added url: " + url));
        }
    }

    public void removeURL(URL url) {
        if (url == null) {
            throw new NullArgumentException("url");
        }
        boolean success = this.urlList.remove(url);
        if (success && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removed url: " + url));
        }
    }

    public boolean hasURL(URL url) {
        if (url == null) {
            throw new NullArgumentException("url");
        }
        return this.urlList.contains(url);
    }

    public void setURLs(String listspec) throws MalformedURLException {
        if (listspec == null) {
            throw new NullArgumentException("listspec");
        }
        boolean debug = this.log.isDebugEnabled();
        LinkedList<URL> list = new LinkedList<URL>();
        StringTokenizer stok = new StringTokenizer(listspec, ",");
        while (stok.hasMoreTokens()) {
            String urlspec = stok.nextToken().trim();
            if (debug) {
                this.log.debug((Object)("Adding URL from spec: " + urlspec));
            }
            URL url = this.makeURL(urlspec);
            if (debug) {
                this.log.debug((Object)("URL: " + url));
            }
            list.add(url);
        }
        this.setURLList(list);
    }

    protected URL makeURL(String urlspec) throws MalformedURLException {
        urlspec = StringPropertyReplacer.replaceProperties((String)urlspec);
        return new URL(this.serverHomeURL, urlspec);
    }

    public void addURL(String urlspec) throws MalformedURLException {
        this.addURL(this.makeURL(urlspec));
    }

    public void removeURL(String urlspec) throws MalformedURLException {
        this.removeURL(this.makeURL(urlspec));
    }

    public boolean hasURL(String urlspec) throws MalformedURLException {
        return this.hasURL(this.makeURL(urlspec));
    }

    protected void deploy(DeployedURL du) {
        if (this.deployer == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Deploying: " + du));
        }
        try {
            this.deployer.deploy(du.url);
        }
        catch (IncompleteDeploymentException e) {
            this.lastIncompleteDeploymentException = e;
        }
        catch (Exception e) {
            this.log.debug((Object)("Failed to deploy: " + du), (Throwable)e);
        }
        du.deployed();
        if (!this.deployedSet.contains(du)) {
            this.deployedSet.add(du);
        }
    }

    protected void undeploy(DeployedURL du) {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Undeploying: " + du));
            }
            this.deployer.undeploy(du.url);
            this.deployedSet.remove(du);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to undeploy: " + du), (Throwable)e);
        }
    }

    protected boolean isDeployed(URL url) {
        DeployedURL du = new DeployedURL(url);
        return this.deployedSet.contains(du);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scan() throws Exception {
        int i;
        DeployedURL deployedURL;
        Iterator i2;
        Object url;
        this.lastIncompleteDeploymentException = null;
        if (this.urlList == null) {
            throw new IllegalStateException("not initialized");
        }
        this.updateSorter();
        boolean trace = this.log.isTraceEnabled();
        URLListerFactory factory = new URLListerFactory();
        LinkedList<URL> urlsToDeploy = new LinkedList<URL>();
        if (trace) {
            this.log.trace((Object)"Scanning for new deployments");
        }
        List list = this.urlList;
        synchronized (list) {
            Iterator i3 = this.urlList.iterator();
            while (i3.hasNext()) {
                url = (URL)i3.next();
                if (((URL)url).toString().endsWith("/")) {
                    URLLister lister = factory.createURLLister((URL)url);
                    urlsToDeploy.addAll(lister.listMembers((URL)url, this.filter, this.doRecursiveSearch));
                    continue;
                }
                urlsToDeploy.add((URL)url);
            }
        }
        if (trace) {
            this.log.trace((Object)"Updating existing deployments");
        }
        LinkedList<DeployedURL> urlsToRemove = new LinkedList<DeployedURL>();
        LinkedList<DeployedURL> urlsToCheckForUpdate = new LinkedList<DeployedURL>();
        url = this.deployedSet;
        synchronized (url) {
            i2 = this.deployedSet.iterator();
            while (i2.hasNext()) {
                deployedURL = (DeployedURL)i2.next();
                if (urlsToDeploy.contains(deployedURL.url)) {
                    urlsToCheckForUpdate.add(deployedURL);
                    continue;
                }
                urlsToRemove.add(deployedURL);
            }
        }
        Iterator i4 = urlsToRemove.iterator();
        while (i4.hasNext()) {
            DeployedURL deployedURL2 = (DeployedURL)i4.next();
            if (trace) {
                this.log.trace((Object)("Removing " + deployedURL2.url));
            }
            this.undeploy(deployedURL2);
        }
        ArrayList<DeployedURL> urlsToUpdate = new ArrayList<DeployedURL>(urlsToCheckForUpdate.size());
        i2 = urlsToCheckForUpdate.iterator();
        while (i2.hasNext()) {
            deployedURL = (DeployedURL)i2.next();
            if (!deployedURL.isModified()) continue;
            if (trace) {
                this.log.trace((Object)("Re-deploying " + deployedURL.url));
            }
            urlsToUpdate.add(deployedURL);
        }
        Collections.sort(urlsToUpdate, new Comparator(){

            public int compare(Object o1, Object o2) {
                return URLDeploymentScanner.this.sorter.compare(((DeployedURL)o1).url, ((DeployedURL)o2).url);
            }
        });
        for (i = urlsToUpdate.size() - 1; i >= 0; --i) {
            this.undeploy((DeployedURL)urlsToUpdate.get(i));
        }
        for (i = 0; i < urlsToUpdate.size(); ++i) {
            this.deploy((DeployedURL)urlsToUpdate.get(i));
        }
        Collections.sort(urlsToDeploy, this.sorter);
        Iterator i5 = urlsToDeploy.iterator();
        while (i5.hasNext()) {
            URL url2 = (URL)i5.next();
            DeployedURL deployedURL3 = new DeployedURL(url2);
            if (!this.deployedSet.contains(deployedURL3)) {
                if (trace) {
                    this.log.trace((Object)("Deploying " + deployedURL3.url));
                }
                this.deploy(deployedURL3);
            }
            i5.remove();
            if (!i5.hasNext() || !this.updateSorter()) continue;
            Collections.sort(urlsToDeploy, this.sorter);
            i5 = urlsToDeploy.iterator();
        }
        if (this.lastIncompleteDeploymentException != null) {
            try {
                Object[] args = new Object[]{};
                String[] sig = new String[]{};
                this.getServer().invoke(this.getDeployer(), "checkIncompleteDeployments", args, sig);
            }
            catch (Exception e) {
                Throwable t = JMXExceptionDecoder.decode((Throwable)e);
                this.log.error((Object)t);
            }
        }
    }

    protected boolean updateSorter() {
        DefaultDeploymentSorter defaultSorter;
        if (this.sorter instanceof DefaultDeploymentSorter && (defaultSorter = (DefaultDeploymentSorter)((Object)this.sorter)).getSuffixOrder() != this.mainDeployer.getSuffixOrder()) {
            defaultSorter.setSuffixOrder(this.mainDeployer.getSuffixOrder());
            return true;
        }
        return false;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        ServerConfig serverConfig = ServerConfigLocator.locate();
        this.serverHome = serverConfig.getServerHomeDir();
        this.serverHomeURL = serverConfig.getServerHomeURL();
        return super.preRegister(server, name);
    }

    protected class DeployedURL {
        public URL url;
        public URL watchUrl;
        public long deployedLastModified;

        public DeployedURL(URL url) {
            this.url = url;
        }

        public void deployed() {
            this.deployedLastModified = this.getLastModified();
        }

        public boolean isFile() {
            return this.url.getProtocol().equals("file");
        }

        public File getFile() {
            return new File(this.url.getFile());
        }

        public boolean isRemoved() {
            if (this.isFile()) {
                File file = this.getFile();
                return !file.exists();
            }
            return false;
        }

        public long getLastModified() {
            if (this.watchUrl == null) {
                try {
                    Object o = URLDeploymentScanner.this.getServer().invoke(URLDeploymentScanner.this.getDeployer(), "getWatchUrl", new Object[]{this.url}, new String[]{(class$java$net$URL == null ? (class$java$net$URL = URLDeploymentScanner.class$("java.net.URL")) : class$java$net$URL).getName()});
                    this.watchUrl = o == null ? this.url : (URL)o;
                    URLDeploymentScanner.this.getLog().debug((Object)("Watch URL for: " + this.url + " -> " + this.watchUrl));
                }
                catch (Exception e) {
                    this.watchUrl = this.url;
                    URLDeploymentScanner.this.getLog().debug((Object)("Unable to obtain watchUrl from deployer. Use url: " + this.url), (Throwable)e);
                }
            }
            try {
                URLConnection connection = this.watchUrl != null ? this.watchUrl.openConnection() : this.url.openConnection();
                long lastModified = connection.getLastModified();
                return lastModified;
            }
            catch (IOException e) {
                URLDeploymentScanner.this.log.warn((Object)("Failed to check modfication of deployed url: " + this.url), (Throwable)e);
                return -1L;
            }
        }

        public boolean isModified() {
            long lastModified = this.getLastModified();
            if (lastModified == -1L) {
                return false;
            }
            return this.deployedLastModified != lastModified;
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof DeployedURL) {
                return ((DeployedURL)other).url.equals(this.url);
            }
            return false;
        }

        public String toString() {
            return super.toString() + "{ url=" + this.url + ", deployedLastModified=" + this.deployedLastModified + " }";
        }
    }
}

