/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import org.makumba.ConfigFileError;
import org.makumba.MakumbaError;
import org.makumba.Transaction;
import org.makumba.commons.ClassResource;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.providers.CRUDOperationProvider;
import org.makumba.providers.Configuration;
import org.makumba.providers.TransactionProviderInterface;

public class TransactionProvider
implements TransactionProviderInterface {
    private TransactionProviderInterface transactionProviderImplementation;
    public static int dbsel = NamedResources.makeStaticCache("Database selection files", new NamedResourceFactory(){
        private static final long serialVersionUID = 1L;

        protected Object makeResource(Object nm) {
            Properties p = new Properties();
            try {
                InputStream input = ClassResource.get((String)nm).openStream();
                p.load(input);
                input.close();
            }
            catch (Exception e) {
                throw new ConfigFileError((String)nm);
            }
            return p;
        }
    });

    private TransactionProvider() {
        this(new Configuration());
    }

    public static TransactionProvider getInstance() {
        return SingletonHolder.singleton;
    }

    public TransactionProvider(TransactionProviderInterface tpi) {
        this.transactionProviderImplementation = tpi;
    }

    public TransactionProvider(Configuration config) {
        try {
            Logger.getLogger("org.makumba.providers").info("Instantiating TransactionProvider '" + config.getDefaultTransactionProviderClass() + "'");
            this.transactionProviderImplementation = (TransactionProviderInterface)Class.forName(config.getDefaultTransactionProviderClass()).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Transaction getConnectionTo(String name) {
        return this.transactionProviderImplementation.getConnectionTo(name);
    }

    public String getDefaultDataSourceName() {
        return this.transactionProviderImplementation.getDefaultDataSourceName();
    }

    public String getDatabaseProperty(String name, String propName) {
        return this.transactionProviderImplementation.getDatabaseProperty(name, propName);
    }

    public void _copy(String sourceDB, String destinationDB, String[] typeNames, boolean ignoreDbsv) {
        this.transactionProviderImplementation._copy(sourceDB, destinationDB, typeNames, ignoreDbsv);
    }

    public void _delete(String whereDB, String provenienceDB, String[] typeNames, boolean ignoreDbsv) {
        this.transactionProviderImplementation._delete(whereDB, provenienceDB, typeNames, ignoreDbsv);
    }

    public String getDataSourceName(String lookupFile) {
        return this.transactionProviderImplementation.getDataSourceName(lookupFile);
    }

    public boolean supportsUTF8() {
        return this.transactionProviderImplementation.supportsUTF8();
    }

    public CRUDOperationProvider getCRUD() {
        return this.transactionProviderImplementation.getCRUD();
    }

    public String getQueryLanguage() {
        return this.transactionProviderImplementation.getQueryLanguage();
    }

    public static String findInHostProperties(Properties p, String str) {
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            int i = s.indexOf(35);
            try {
                if (i != -1 && !InetAddress.getByName(s.substring(0, i)).equals(InetAddress.getLocalHost()) || !str.endsWith(s.substring(i + 1))) continue;
                return p.getProperty(s);
            }
            catch (UnknownHostException uhe) {
            }
        }
        return null;
    }

    public static String findDatabaseName(Properties p) {
        String userDir = System.getProperty("user.dir");
        URL u = ClassResource.get("/");
        String wbp = u != null ? u.toString() : null;
        String n = TransactionProvider.findInHostProperties(p, userDir);
        if (n != null || wbp != null && (n = TransactionProvider.findInHostProperties(p, wbp)) != null || (n = TransactionProvider.findInHostProperties(p, "default")) != null) {
            return n;
        }
        return p.getProperty("default");
    }

    public static String findDatabaseName(String s) {
        try {
            return TransactionProvider.findDatabaseName((Properties)NamedResources.getStaticCache(dbsel).getResource(s));
        }
        catch (RuntimeWrappedException e) {
            if (e.getCause() instanceof MakumbaError) {
                throw (MakumbaError)e.getCause();
            }
            throw e;
        }
    }

    private static class SingletonHolder {
        private static final TransactionProvider singleton = new TransactionProvider();

        private SingletonHolder() {
        }
    }
}

