/*
 * Decompiled with CFR 0.152.
 */
package net.mark_malakanov.sdg2;

import antlr.collections.AST;
import edu.usfca.syndiag.ANTLRTreePrinter;
import edu.usfca.syndiag.GrammarAST;
import java.awt.Cursor;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.ProgressMonitor;
import net.mark_malakanov.sdg2.SdgBody;
import net.mark_malakanov.sdg2.SwingForm;

public class Main {
    static boolean isBlind;
    static boolean toWrap;
    static boolean isStandardInput;
    static boolean isStandardOutput;
    static String diagramWidth;
    static String diagramAltWidth;
    static int diagramWidthInt;
    static int diagramAltWidthInt;
    static String saveToFileName;
    static String saveToImageType;
    static String saveToHtmlName;
    static String saveToHtmlDirName;
    static String saveToHtmlTitle;
    static String saveToHtmlHeader;
    static String saveToHtmlImgBorder;
    static String inputFileName;
    static String grammarName;
    static String uniformName;
    static String diagramStyle;
    SdgBody sdgBody;

    public static void print(GrammarAST t) {
        System.out.println(Main.toString(t));
    }

    public static String toString(GrammarAST t) {
        String s = null;
        try {
            s = new ANTLRTreePrinter().toString((AST)t);
        }
        catch (Exception e) {
            System.err.println("Problems printing tree: " + (Object)((Object)t));
            e.printStackTrace(System.err);
        }
        return s;
    }

    public static void parseArgs(String[] args) {
        String[] s2;
        saveToImageType = "png";
        diagramStyle = "Canonical";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-width")) {
                toWrap = true;
                diagramWidth = args[++i];
                continue;
            }
            if (args[i].equals("-altwidth")) {
                diagramAltWidth = args[++i];
                continue;
            }
            if (args[i].equals("-diagramstyle")) {
                diagramStyle = args[++i];
                continue;
            }
            if (args[i].equals("-save")) {
                saveToFileName = args[++i];
                continue;
            }
            if (args[i].equals("-savehtml")) {
                saveToHtmlName = args[++i];
                continue;
            }
            if (args[i].equals("-savehtmltitle")) {
                saveToHtmlTitle = args[++i];
                continue;
            }
            if (args[i].equals("-savehtmlheader")) {
                saveToHtmlHeader = args[++i];
                continue;
            }
            if (args[i].equals("-savehtmldir")) {
                saveToHtmlDirName = args[++i];
                continue;
            }
            if (args[i].equals("-saveimgtype")) {
                saveToImageType = args[++i];
                continue;
            }
            if (args[i].equals("-saveimgborder")) {
                saveToHtmlImgBorder = args[++i];
                continue;
            }
            if (args[i].equals("-blind")) {
                isBlind = true;
                continue;
            }
            if (args[i].equals("-i")) {
                isStandardInput = true;
                continue;
            }
            if (args[i].equals("-o")) {
                isStandardOutput = true;
                continue;
            }
            if (args[i].equals("-help")) {
                Main.printUsage();
                continue;
            }
            if (args[i].equals("--help")) {
                Main.printUsage();
                continue;
            }
            if (args[i].equals("-?")) {
                Main.printUsage();
                continue;
            }
            inputFileName = args[i];
        }
        if (!(inputFileName != null || isStandardInput || saveToFileName == null && saveToHtmlName == null && saveToHtmlDirName == null && saveToHtmlTitle == null && saveToHtmlHeader == null)) {
            System.err.println("Error: Input is not specified when -save, -savehtmldir, -savehtmltitle or -savehtmlheader are.");
            Main.printUsage();
        }
        if (inputFileName != null) {
            isStandardInput = false;
            String[] s1 = inputFileName.split("([\\/\\\\])");
            s2 = s1[s1.length - 1].split("\\.");
            grammarName = s2[0];
        }
        if (isStandardInput) {
            grammarName = "std input";
        }
        if (saveToFileName != null) {
            isStandardOutput = false;
        }
        if (saveToHtmlName != null) {
            isStandardOutput = false;
            String[] s1 = saveToHtmlName.split("([\\/\\\\])");
            s2 = s1[s1.length - 1].split("\\.");
            uniformName = s2[0];
        }
        if (saveToHtmlName != null && saveToHtmlDirName == null) {
            saveToHtmlDirName = uniformName.replace(' ', '_');
        }
        if (saveToHtmlName != null && saveToHtmlTitle == null) {
            saveToHtmlTitle = uniformName;
        }
        if (saveToHtmlTitle != null && saveToHtmlHeader == null) {
            saveToHtmlHeader = saveToHtmlTitle;
        }
        if (saveToHtmlName == null && (saveToHtmlDirName != null || saveToHtmlTitle != null || saveToHtmlHeader != null)) {
            System.err.println("Error: -savehtml is not specified when -savehtmldir, -savehtmltitle or -savehtmlheader are.");
            Main.printUsage();
        }
        if (diagramWidth != null) {
            diagramWidthInt = new Integer(diagramWidth);
        }
        if (diagramAltWidth != null) {
            diagramAltWidthInt = new Integer(diagramAltWidth);
        }
        if (diagramWidth != null && diagramAltWidth == null) {
            diagramAltWidthInt = diagramWidthInt - 300;
        }
        if (toWrap && (diagramWidthInt < 600 || diagramAltWidthInt < 300)) {
            System.err.println("Error: -width must be more 599; -altwidth must be more 299.");
            Main.printUsage();
        }
        if (diagramWidth == null && diagramAltWidth != null) {
            System.err.println("Error: -width is not specified when -altwidth is.");
            Main.printUsage();
        }
        if ((diagramStyle = diagramStyle.toLowerCase()).startsWith("c")) {
            diagramStyle = "Canonical";
        } else if (diagramStyle.startsWith("h")) {
            diagramStyle = "Heretical";
        } else {
            System.err.println("Error: -diagramstyle must be \"c[anonical]\" or \"h[eretical]\".");
            Main.printUsage();
        }
    }

    public static void printUsage() {
        System.out.println("Usage: java edu.usfca.syndiag.Main [-wrap] [-blind] \\");
        System.out.println("[-save image.ext] [-savehtml file.html [-savehtmldir dir] [-savehtmltitle \"html Title\"] \\");
        System.out.println("[-savehtmlheader \"html Header\"] [-saveimgborder 0] [-saveimgtype ext] [-i] [-diagramstyle style] [input.g]");
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        SwingForm swing = null;
        SdgBody sdgBody = new SdgBody();
        Main.parseArgs(args);
        sdgBody.diagramWidth = diagramWidthInt;
        sdgBody.diagramAltWidth = diagramAltWidthInt;
        sdgBody.diagramStyle = diagramStyle;
        InputStream inStr = null;
        if (inputFileName != null) {
            inStr = new FileInputStream(inputFileName);
        } else if (isStandardInput) {
            inStr = System.in;
        }
        if (!isBlind) {
            swing = new SwingForm(sdgBody);
            swing.createForm();
            swing.frm.setTitle("SDG2");
        }
        if (inStr != null) {
            if (isBlind) {
                sdgBody.load(inStr);
            } else {
                swing.frm.setCursor(new Cursor(3));
                sdgBody.load(inStr);
                swing.menuItemSaveAs.setEnabled(true);
                swing.menuItemSaveAsHTML.setEnabled(true);
                swing.menuItemSetWidth.setEnabled(true);
                swing.menuItemDiagStyle.setEnabled(true);
                swing.draw(sdgBody.grammarTree);
                swing.frm.setCursor(new Cursor(0));
                swing.frm.setTitle("SDG2: " + grammarName);
            }
            if (saveToFileName != null) {
                sdgBody.saveAsFile(sdgBody.grammarTree, saveToFileName);
            }
            if (saveToHtmlName != null) {
                if (!isBlind) {
                    ProgressMonitor progressMonitor = new ProgressMonitor(swing.frm, "Saving multiple files", "", 0, 0);
                    progressMonitor.setMillisToDecideToPopup(10);
                    progressMonitor.setMillisToPopup(0);
                    sdgBody.saveAsHTMLandFilesInBkg(saveToHtmlDirName, saveToHtmlName, saveToImageType, saveToHtmlTitle, saveToHtmlHeader, saveToHtmlImgBorder, progressMonitor);
                } else {
                    sdgBody.saveAsHTMLandFiles(saveToHtmlDirName, saveToHtmlName, saveToImageType, saveToHtmlTitle, saveToHtmlHeader, saveToHtmlImgBorder, null);
                }
            }
            if (isBlind) {
                System.exit(0);
            }
        }
    }
}

