/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.TestEngine;
import com.ecyrd.jspwiki.TranslatorReader;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import org.makumba.commons.WikiFormatter;

public class JspWikiFormatter
implements WikiFormatter {
    protected static TestEngine testEngine;
    protected static Properties props;
    protected static WikiContext context;

    public static JspWikiFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    public String wiki2html(String s) {
        if (context == null) {
            JspWikiFormatter.getInstance();
        }
        TranslatorReader r = new TranslatorReader(context, (Reader)new BufferedReader(new StringReader(s)));
        try {
            String result = FileUtil.readContents((Reader)r);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return s;
        }
    }

    static {
        props = new Properties();
    }

    private static final class SingletonHolder {
        static JspWikiFormatter singleton;

        private SingletonHolder() {
        }

        static {
            props.put("jspwiki.workDir", ".");
            props.put("jspwiki.pageProvider", "com.ecyrd.jspwiki.providers.FileSystemProvider");
            props.put("jspwiki.fileSystemProvider.pageDir", "@tests.pagedir@");
            try {
                testEngine = new TestEngine(props);
            }
            catch (WikiException e) {
                e.printStackTrace();
            }
            context = new WikiContext((WikiEngine)testEngine, new WikiPage("TestPage"));
            singleton = new JspWikiFormatter();
        }
    }
}

