/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class MakumbaTLDGenerator {
    private static final String TAGLIB_MAK = "taglib.tld";
    private static final String TAGLIB_HIBERNATE = "taglib-hibernate.tld";
    private static final String HIBERNATE_TLD_URI = "http://www.makumba.org/view-hql";
    private static final String TAGLIB_DOCUMENTED_XML = "taglib-documented.xml";

    public static void main(String[] args) {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(new File(args[0]) + File.separator + TAGLIB_DOCUMENTED_XML);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element root = document.getRootElement();
        for (Element tag : root.elements()) {
            if (!tag.getName().equals("tag")) continue;
            Element name = tag.element("name");
            String tagName = name.getText();
            for (Element tagContent : tag.elements()) {
                if (tagContent.getName().equals("web-description")) {
                    tagContent.getParent().remove(tagContent);
                }
                if (!tagContent.getName().equals("attribute")) continue;
                for (Element attributeContent : tagContent.elements()) {
                    if (!attributeContent.getName().equals("description") && !attributeContent.getName().equals("comments")) continue;
                    attributeContent.getParent().remove(attributeContent);
                }
            }
        }
        String tldPath = args[0] + File.separator + TAGLIB_MAK;
        System.out.println("Writing general Makumba TLD at path " + tldPath);
        try {
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(tldPath)), new OutputFormat("", false));
            output.write(document);
            output.close();
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
        Document hibernateTLD = document;
        hibernateTLD.getRootElement().element("uri").setText(HIBERNATE_TLD_URI);
        String hibernateTldPath = args[0] + File.separator + TAGLIB_HIBERNATE;
        System.out.println("Writing hibernate Makumba TLD at path " + hibernateTldPath);
        try {
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(hibernateTldPath)), new OutputFormat("", false));
            output.write(document);
            output.close();
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
    }
}

