/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.makumba.commons.ControllerHandler;
import org.makumba.commons.MakumbaResourceServlet;
import org.makumba.commons.NamedResources;
import org.makumba.commons.ServletObjects;
import org.makumba.db.makumba.UniquenessServlet;
import org.makumba.devel.DevelUtils;
import org.makumba.devel.relations.RelationCrawlerTool;
import org.makumba.forms.responder.ValueEditor;
import org.makumba.list.MakumbaDownloadServlet;
import org.makumba.providers.Configuration;

public class MakumbaToolsControllerHandler
extends ControllerHandler {
    public boolean beforeFilter(ServletRequest req, ServletResponse res, FilterConfig conf, ServletObjects httpServletObjects) throws Exception {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String path = request.getRequestURI().replace(request.getContextPath(), "");
        if (path.startsWith(Configuration.getMakumbaUniqueLocation())) {
            new UniquenessServlet().doGet(request, response);
            return false;
        }
        if (path.startsWith(Configuration.getMakumbaResourcesLocation())) {
            new MakumbaResourceServlet().doGet(request, response);
            return false;
        }
        if (path.startsWith(Configuration.getMakumbaDownloadLocation())) {
            new MakumbaDownloadServlet().doGet(request, response);
            return false;
        }
        if (path.startsWith(Configuration.getMakumbaValueEditorLocation())) {
            new ValueEditor().doPost(request, response);
            return false;
        }
        if (path.startsWith(Configuration.getMakumbaRelationCrawlerLocation())) {
            new RelationCrawlerTool().doPost(request, response);
            return false;
        }
        if (path.startsWith(Configuration.getMakumbaCacheCleanerLocation())) {
            Logger.getLogger("org.makumba.system").info("Cleaning makumba caches, triggered from Makumba Tools");
            NamedResources.cleanCaches();
            DevelUtils.printResponseMessage(res, "Makumba Cache Cleaner", "<br/><br/>Cleaned Makumba caches.");
            return false;
        }
        if (path.startsWith(Configuration.getMakumbaToolsLocation())) {
            if (!path.equals(Configuration.getMakumbaToolsLocation() + "/")) {
                response.sendRedirect(request.getContextPath() + Configuration.getMakumbaToolsLocation() + "/");
                return false;
            }
            PrintWriter w = res.getWriter();
            res.setContentType("text/html");
            DevelUtils.writePageBegin(w);
            DevelUtils.writeStyles(w, request.getContextPath());
            DevelUtils.writeTitleAndHeaderEnd(w, "Makumba Configuration");
            DevelUtils.printPageHeader(w, "Makumba Configuration");
            w.println("</table>");
            w.println("<h3>Welcome to the Makumba Configuration page!</h3>");
            w.println("<p>This page gives you a short overview on the configuration of this Makumba installation and basic information on the tools available.</p>");
            this.writeSectionHeader(w, "Location", "Makumba Tools");
            this.writeDescr(w, "Download", "Download of file-type data", "makumbaDownload", Configuration.getMakumbaDownloadLocation(), request.getContextPath());
            this.writeDescr(w, "Resources", "Resources (javaScript, images,...) needed for calendar editor, live-validation, ...", "makumbaResources", Configuration.getMakumbaResourcesLocation(), request.getContextPath());
            this.writeDescr(w, "Uniqueness", "AJAX uniqueness check", "makumbaUniquenessValidator", Configuration.getMakumbaUniqueLocation(), request.getContextPath());
            this.writeDescr(w, "Value Editor", "Tool for edit-in-place", "makumbaValueEditor", Configuration.getMakumbaValueEditorLocation(), request.getContextPath());
            this.writeDescr(w, "DataDefinition viewer", "View data definitions", "mddViewer", Configuration.getMddViewerLocation(), request.getContextPath());
            this.writeDescr(w, "Java Viewer", "View Java Business Logics", "javaViewer", Configuration.getJavaViewerLocation(), request.getContextPath());
            this.writeDescr(w, "Logic Discover", "View Business Logics associated with a certain page", "logicDiscovery", Configuration.getLogicDiscoveryViewerLocation(), request.getContextPath());
            this.writeDescr(w, "Data lister", "List data from a certain type", "dataLister", Configuration.getDataListerLocation(), request.getContextPath());
            this.writeDescr(w, "Object viewer", "View a specific object", "dataObjectViewer", Configuration.getDataViewerLocation(), request.getContextPath());
            this.writeDescr(w, "Data query", "Free-form OQL queries", "dataQueryTool", Configuration.getDataQueryLocation(), request.getContextPath());
            this.writeDescr(w, "Pointer value converter", "Convert pointer values between internal/external/DB form", "objectIdConverter", Configuration.getObjectIdConverterLocation(), request.getContextPath());
            this.writeDescr(w, "Code generator", "Generate forms & lists from data definitions", "codeGenerator", Configuration.getCodeGeneratorLocation(), request.getContextPath());
            this.writeDescr(w, "Reference Checker", "Check for broken references and show status of foreign key creation", "referenceChecker", Configuration.getReferenceCheckerLocation(), request.getContextPath());
            this.writeDescr(w, "Relation Crawler", "Runs a detection of file relations", "relationCrawler", Configuration.getMakumbaRelationCrawlerLocation(), request.getContextPath());
            this.writeDescr(w, "Makumba Cache Cleaner", "Cleans all internal Makumba caches, like queries, data-definitions.<br/>Useful during development, to avoid having to restart the servlet container.", "makumbaCacheCleaner", Configuration.getMakumbaCacheCleanerLocation(), request.getContextPath());
            w.println("</table>");
            this.writeSectionHeader(w, "Value", "Controller settings");
            this.writeDescr(w, "Transaction Provider", "", "defaultTransactionProvider", "");
            this.writeDescr(w, "Form reload", "Whether forms shall be reloaded on validation errors", "reloadFormOnError", Configuration.getReloadFormOnErrorDefault());
            this.writeDescr(w, "Clientside validation", "Whether client-side validation is enabled, and if it is live or on form submission", "clientSideValidation", Configuration.getClientSideValidationDefault());
            w.println("</table>");
            this.writeSectionHeader(w, "Value", "Input style settings");
            this.writeDescr(w, "Calendar editor", "Whether the calendar-editor will be displayed by default for mak:input on date types", "calendarEditor", Configuration.getCalendarEditorDefault());
            this.writeDescr(w, "Calendar editor link", "The default link created for the calendar editor", "calendarEditorLink", StringEscapeUtils.escapeHtml((String)Configuration.getDefaultCalendarEditorLink(request.getContextPath())));
            w.println("</table>");
            this.writeSectionHeader(w, "Value", "Other settings");
            this.writeDescr(w, "Repository URL", "The URL prefix to compose links from the source code viewers to the source code repository", "repositoryURL", Configuration.getRepositoryURL());
            this.writeDescr(w, "Repository Link Text", "The text displayed on the repository URL link", "repositoryLinkText", Configuration.getRepositoryLinkText());
            w.println("</table>");
            DevelUtils.writePageEnd(w);
            w.close();
            return false;
        }
        return true;
    }

    private void writeSectionHeader(PrintWriter w, String columnName, String sectionName) {
        w.println("<h4>" + sectionName + "</h4>");
        w.println("<table border=\"1\" _width=\"100%\">");
        w.println("  <tr>");
        w.println("    <th>Name</th>");
        w.println("    <th>Description</th>");
        w.println("    <th>Config file key</th>");
        w.println("    <th>" + columnName + "</th>");
        w.println("  </tr>");
    }

    private void writeDescr(PrintWriter w, String name, String desc, String key, Object value) {
        w.println("  <tr>");
        w.println("    <td>" + name + "</td> <td>" + desc + "</td> <td>" + key + "</td> <td>" + value + "</td>");
        w.println("  </tr>");
    }

    private void writeDescr(PrintWriter w, String name, String desc, String key, String loc, String contextPath) {
        w.println("  <tr>");
        String link = loc.equals("PROPERTY_NOT_SET") ? "-- disabled --" : "<a href=\"" + contextPath + loc + "\">" + contextPath + loc + "</a>";
        w.println("    <td>" + name + "</td> <td>" + desc + "</td> <td>" + key + "</td> <td> " + link + " </td>");
        w.println("  </tr>");
    }
}

