/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.Pointer;
import org.makumba.devel.DevelUtils;
import org.makumba.providers.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final int MODE_LIST = 10;
    public static final int MODE_QUERY = 30;
    public static final int MODE_VIEW = 20;
    public static final int MODE_CONVERTOR = 40;
    protected String browsePath;
    protected String contextPath;
    protected Pointer dataPointer;
    protected String type;
    protected String virtualPath;
    static final Logger logger = Logger.getLogger("org.makumba.devel.codeGenerator");
    protected String toolLocation = null;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        this.contextPath = request.getContextPath();
        this.virtualPath = DevelUtils.getVirtualPath(request, this.toolLocation);
        if (this.virtualPath == null) {
            this.virtualPath = "/";
        }
        this.type = this.virtualPath;
        if (this.type.startsWith("/")) {
            this.type = this.type.substring(1);
        }
        this.browsePath = this.type.replace('.', '/').substring(0, this.type.lastIndexOf(46) + 1);
    }

    protected void writePageContentHeader(String type, PrintWriter w, String dataBaseName, int mode) {
        w.println("<body bgcolor=\"white\">");
        w.println("<table width=\"100%\" bgcolor=\"lightblue\">");
        w.println("  <tr>");
        w.println("    <td>");
        String toolKey = null;
        if (mode == 20 || mode == 10) {
            if (type != null && !type.equals("")) {
                w.println("      <a href=\"" + this.contextPath + Configuration.getMddViewerLocation() + "/" + type + "\"><span style=\"font-size: x-large\"><span style=\"color: darkblue;\">" + type + "</span></a> data</span>");
            } else {
                w.println("      <span style=\"font-size: large; color: darkblue;\">Browse to select type for data listing</span>");
            }
            if (this.dataPointer != null) {
                w.println(" <i>for Pointer " + this.dataPointer.toExternalForm() + " (<span title=\"DBSV:UID\" style=\"border-bottom:thin dotted;\">" + this.dataPointer + "</span> | <span title=\"Database value\" style=\"border-bottom:thin dotted;\">" + this.dataPointer.longValue() + "</span>)</i>");
            }
            w.println("<br>in Makumba database: " + dataBaseName);
            toolKey = "dataLister";
        } else if (mode == 30) {
            w.println("      <span style=\"font-size: x-large\">Query translater & executer</span><br>");
            w.println("      <span style=\"font-size: small\">Insert your query in OQl here, and get the created SQL and the results of the query.</span>");
            toolKey = "dataQueryTool";
        } else if (mode == 40) {
            w.println("      <span style=\"font-size: x-large\">Makumba Pointer value convertor</span>");
            w.println("<br>in Makumba database: " + dataBaseName);
            toolKey = "objectIdConverter";
        }
        w.println("    </td>");
        w.println("    <td align=\"right\" valign=\"top\" style=\"padding: 5px; padding-top: 10px\">");
        if (mode == 40) {
            w.println("      <span class=\"active\">Pointer value converter</span>");
        }
        w.println("      &nbsp;&nbsp;&nbsp;");
        if (mode == 10 && !type.equals("") || mode == 20) {
            w.println("      <a href=\"" + this.browsePath + "\">browse</a>");
            w.println("      &nbsp;&nbsp;&nbsp;");
            w.println("      <span class=\"active\">data</span>");
        } else if (mode == 40 || mode == 30) {
            w.println("      <a href=\"" + this.browsePath + "\">browse</a>");
        } else {
            w.println("      <span class=\"active\">browse</span>");
        }
        w.println("&nbsp;&nbsp;&nbsp;");
        DevelUtils.writeDevelUtilLinks(w, toolKey, this.contextPath);
        w.println("    </td>");
        w.println("  </tr>");
        w.println("</table>");
    }

    public static Vector<FieldDefinition>[] extractFields(DataDefinition dd, boolean skipDefaultFields) {
        Vector<FieldDefinition> fields = new Vector<FieldDefinition>();
        Vector<FieldDefinition> sets = new Vector<FieldDefinition>();
        for (int i = 0; i < dd.getFieldNames().size(); ++i) {
            FieldDefinition fd = dd.getFieldDefinition(i);
            logger.finer("DEBUG INFO: Extracting fields: field name " + fd.getName() + " of type " + fd.getType());
            if (skipDefaultFields && fd.isDefaultField()) continue;
            if (fd.shouldEditBySingleInput()) {
                fields.add(fd);
                continue;
            }
            sets.add(fd);
        }
        return new Vector[]{fields, sets};
    }
}

