/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.tags;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.makumba.FieldDefinition;
import org.makumba.LogicException;
import org.makumba.ProgrammerError;
import org.makumba.analyser.PageCache;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.StringUtils;
import org.makumba.commons.tags.GenericMakumbaTag;
import org.makumba.forms.tags.FormTagBase;
import org.makumba.forms.tags.MatchModeTag;
import org.makumba.providers.FormDataProvider;

public class CriterionTag
extends GenericMakumbaTag
implements BodyTag {
    private static final long serialVersionUID = 1L;
    private static final String[] allowedRanges = ATTRIBUTE_VALUES_TRUE_FALSE;
    private String isRange;
    private String fields;
    private FieldDefinition fieldDef;
    private BodyContent bodyContent;
    private FormDataProvider fdp;
    private String matchMode;
    private boolean hasMatchModeTag = false;

    public CriterionTag() {
        try {
            this.fdp = (FormDataProvider)Class.forName("org.makumba.list.ListFormDataProvider").newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public FormTagBase getForm() {
        return (FormTagBase)TagSupport.findAncestorWithClass((Tag)this, FormTagBase.class);
    }

    public void doStartAnalyze(PageCache pageCache) {
        if (this.fields == null) {
            throw new ProgrammerError("fields attribute is required");
        }
        this.parseFieldList(pageCache);
        super.doStartAnalyze(pageCache);
    }

    private void parseFieldList(PageCache pageCache) throws ProgrammerError {
        String[] fieldsSplit = this.getFieldsSplit();
        for (int i = 0; i < fieldsSplit.length; ++i) {
            String element = fieldsSplit[i];
            FieldDefinition fd = this.getForm().fdp.getInputTypeAtAnalysis(this, this.getForm().getDataTypeAtAnalysis(pageCache), element, pageCache);
            if (fd == null) {
                throw new ProgrammerError("Field '" + element + "' in field list '" + this.fields + "' is not known.");
            }
            if (this.fieldDef != null) {
                if (!(this.fieldDef.getIntegerType() == fd.getIntegerType() || this.fieldDef.isStringType() && fd.isStringType())) {
                    throw new ProgrammerError("All fields in the field list must be of the same type! Field '" + element + "' with type '" + fd.getType() + "' differs from the previous field '" + this.fieldDef + "' of type '" + this.fieldDef.getType() + "'!");
                }
            } else {
                this.fieldDef = fd;
            }
            if (fieldsSplit.length <= 1 || fd.isStringType() || fd.isNumberType() || fd.isDateType()) continue;
            throw new ProgrammerError("Multi-field search is only possible for 'char'/'text', 'int'/'real' and 'date' types, given field '" + element + "' is of type '" + fd.getType() + "'!");
        }
    }

    public int doAnalyzedEndTag(PageCache pageCache) throws JspException, LogicException {
        this.getForm().responder.addMultiFieldSearchMapping(this.getInputName(), this.getFieldsSplit());
        if (this.matchMode == null && !this.hasMatchModeTag) {
            this.matchMode = this.isRange() ? "betweenInclusive" : "equals";
            this.getForm().responder.setDefaultMatchMode(this.getInputName(), this.matchMode);
        }
        if (this.bodyContent != null) {
            try {
                this.bodyContent.getEnclosingWriter().print(this.bodyContent.getString());
            }
            catch (IOException e) {
                throw new JspException(e.toString());
            }
        }
        return super.doAnalyzedEndTag(pageCache);
    }

    public int doAnalyzedStartTag(PageCache pageCache) {
        if (this.fieldDef == null) {
            this.parseFieldList(pageCache);
            if (this.matchMode != null) {
                Hashtable<String, String> matchModes = MatchModeTag.getValidMatchmodes(false, this.getFieldDefinition(pageCache));
                if (!matchModes.containsKey(this.matchMode)) {
                    throw new ProgrammerError("Unknown match mode '" + this.matchMode + "'. Valid options are: " + StringUtils.toString(matchModes.keySet()));
                }
                this.getForm().responder.setDefaultMatchMode(this.getInputName(), this.matchMode);
            }
        }
        return 2;
    }

    public void setHasMatchMode(boolean hasMatchMode) {
        this.hasMatchModeTag = hasMatchMode;
    }

    public void doEndAnalyze(PageCache pageCache) {
        super.doEndAnalyze(pageCache);
    }

    public void setFields(String s) {
        this.fields = s;
    }

    public String[] getFieldsSplit() {
        String[] split = this.fields.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
        }
        return split;
    }

    public void doInitBody() throws JspException {
    }

    public void setBodyContent(BodyContent b) {
        this.bodyContent = b;
    }

    public FieldDefinition getTypeFromContext(PageCache pageCache) {
        if (this.fieldDef == null) {
            this.parseFieldList(pageCache);
        }
        return this.fdp.getInputTypeAtAnalysis(this, this.getForm().getDataTypeAtAnalysis(pageCache), this.getInputName(), pageCache);
    }

    public void setTagKey(PageCache pageCache) {
        this.tagKey = new MultipleKey(new Object[]{this.getForm().tagKey, this.id, this.fields});
    }

    public boolean allowsIdenticalKey() {
        return false;
    }

    public String getInputName() {
        if (this.fields.indexOf(",") == -1) {
            return this.fields.trim();
        }
        return this.fields.substring(0, this.fields.indexOf(",")).trim();
    }

    public FieldDefinition getFieldDefinition(PageCache pageCache) {
        this.parseFieldList(pageCache);
        return this.fieldDef;
    }

    public boolean isRange() {
        return org.apache.commons.lang.StringUtils.equals((String)this.isRange, (String)"true");
    }

    public void setIsRange(String isRange) {
        this.checkValidAttributeValues("isRange", isRange, allowedRanges);
        this.isRange = isRange;
    }

    public void setMatchMode(String matchMode) {
        this.matchMode = matchMode;
    }

    protected void doAnalyzedCleanup() {
        super.doAnalyzedCleanup();
        this.bodyContent = null;
        this.fieldDef = null;
        this.matchMode = null;
        this.hasMatchModeTag = false;
    }

    public String getMatchMode() {
        return this.matchMode;
    }
}

