/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.oql;

import antlr.RecognitionException;
import antlr.SemanticException;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.Pointer;
import org.makumba.providers.query.oql.AnalysisTree;

public class ComparisonTree
extends AnalysisTree {
    public ComparisonTree(Object left, int op, Object right) {
        super(left, op, right);
    }

    public Object guessParameterType(Object otherOperandType) {
        return otherOperandType;
    }

    public void negociateOperandTypes(Object t1, Object t2) throws RecognitionException {
        if (t1.equals("timestamp") && t2.equals("datetime") || t2.equals("timestamp") && t1.equals("datetime")) {
            return;
        }
        if (t1.equals("int") && t2.equals("real") || t2.equals("int") && t1.equals("real")) {
            return;
        }
        if (this.right.makumbaType != null && this.right.makumbaType.equals("nil")) {
            return;
        }
        if (this.checkAssign(this.left, this.right) || this.checkAssign(this.right, this.left)) {
            return;
        }
        super.negociateOperandTypes(t1, t2);
    }

    boolean checkAssign(AnalysisTree a1, AnalysisTree a2) throws RecognitionException {
        if (!(a1.makumbaType instanceof FieldDefinition)) {
            return false;
        }
        if (a2.leaf == null) {
            return false;
        }
        String s = a2.leaf.getText();
        if (a2.leaf.makumbaType.equals("char") || a2.leaf.makumbaType.equals("date")) {
            s = s.substring(1, s.length() - 1);
        }
        Object o = null;
        try {
            o = ((FieldDefinition)a1.makumbaType).checkValue(s);
        }
        catch (InvalidValueException e) {
            throw new SemanticException(e.getMessage());
        }
        if (o instanceof Pointer) {
            o = new Long(((Pointer)o).longValue());
        }
        if (o instanceof Number) {
            a2.leaf.setText(o.toString());
            a2.leaf.makumbaType = "int";
        } else {
            a2.leaf.setText("\"" + o + "\"");
        }
        return true;
    }
}

