/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.makumba.commons.NameValue;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;

public class SoftNamedResources
extends NamedResources {
    private static final long serialVersionUID = 1L;
    private ReferenceQueue<NameValue> queue = new ReferenceQueue();
    private int diff = 0;

    public SoftNamedResources(String name, NamedResourceFactory f) {
        super(name, f);
    }

    protected NameValue getNameValue(Object name, Object hash) {
        NameValue nv = null;
        SoftReference sr = (SoftReference)this.values.get(hash);
        if (sr == null || (nv = (NameValue)sr.get()) == null) {
            if (sr != null && nv == null) {
                --this.diff;
            }
            nv = new NameValue(name, hash, this.f);
            this.values.put(hash, new SoftReference<NameValue>(nv, this.queue));
            ++this.misses;
        } else {
            ++this.hits;
        }
        return nv;
    }

    public String getName() {
        return this.name + " (soft cache)";
    }

    public synchronized int size() {
        while (this.queue.poll() != null) {
            try {
                this.queue.remove();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++this.diff;
        }
        return super.size() - this.diff;
    }
}

