/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list.engine;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.jsp.PageContext;
import org.makumba.AttributeNotFoundException;
import org.makumba.InvalidValueException;
import org.makumba.LogicException;
import org.makumba.commons.ArrayMap;
import org.makumba.commons.MakumbaJspAnalyzer;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.attributes.PageAttributes;
import org.makumba.list.engine.ComposedQuery;
import org.makumba.list.engine.Evaluator;
import org.makumba.list.engine.Grouper;
import org.makumba.list.tags.GenericListTag;
import org.makumba.list.tags.QueryTag;
import org.makumba.providers.QueryProvider;

public class QueryExecution {
    Grouper listData;
    Vector iterationGroupData;
    public int iteration;
    Stack<Dictionary<String, Object>> currentDataSet;
    public HashMap<MultipleKey, Object> valueQueryData = new HashMap();
    private static final String EXECUTIONS = "org.makumba.taglibQueryExecutions";
    private static final String CURRENT_DATA_SET = "org.makumba.currentDataSet";
    private static final Dictionary<String, Object> NOTHING = new ArrayMap();

    public static void startListGroup(PageContext pageContext) {
        pageContext.setAttribute(EXECUTIONS, new HashMap());
        Stack<Dictionary<String, Object>> currentDataSet = new Stack<Dictionary<String, Object>>();
        currentDataSet.push(NOTHING);
        pageContext.setAttribute(CURRENT_DATA_SET, currentDataSet);
    }

    public static void endListGroup(PageContext pageContext) {
        pageContext.removeAttribute(EXECUTIONS);
        pageContext.removeAttribute(CURRENT_DATA_SET);
    }

    public static QueryExecution getFor(MultipleKey key, PageContext pageContext, String offset, String limit) throws LogicException {
        HashMap executions = (HashMap)pageContext.getAttribute(EXECUTIONS);
        QueryExecution lqe = (QueryExecution)executions.get(key);
        if (lqe == null) {
            lqe = new QueryExecution(key, pageContext, offset, limit);
            executions.put(key, lqe);
        }
        return lqe;
    }

    public static QueryExecution getFor(MultipleKey key, PageContext pageContext, String offset, String limit, String defaultLimit) throws LogicException {
        HashMap executions = (HashMap)pageContext.getAttribute(EXECUTIONS);
        QueryExecution lqe = (QueryExecution)executions.get(key);
        if (lqe == null) {
            lqe = new QueryExecution(key, pageContext, offset, limit, defaultLimit);
            executions.put(key, lqe);
        }
        return lqe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryExecution(MultipleKey key, PageContext pageContext, String offset, String limit) throws LogicException {
        this.currentDataSet = (Stack)pageContext.getAttribute(CURRENT_DATA_SET);
        ComposedQuery cq = QueryTag.getQuery(GenericListTag.getPageCache(pageContext, MakumbaJspAnalyzer.getInstance()), key);
        QueryProvider qep = QueryProvider.makeQueryRunner(GenericListTag.getDataSourceName(pageContext), MakumbaJspAnalyzer.getQueryLanguage(GenericListTag.getPageCache(pageContext, MakumbaJspAnalyzer.getInstance())), PageAttributes.getAttributes(pageContext));
        try {
            this.listData = cq.execute(qep, null, new Evaluator(pageContext), QueryExecution.computeLimit(pageContext, offset, 0), QueryExecution.computeLimit(pageContext, limit, -1));
        }
        finally {
            qep.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryExecution(MultipleKey key, PageContext pageContext, String offset, String limit, String defaultLimit) throws LogicException {
        this.currentDataSet = (Stack)pageContext.getAttribute(CURRENT_DATA_SET);
        ComposedQuery cq = QueryTag.getQuery(GenericListTag.getPageCache(pageContext, MakumbaJspAnalyzer.getInstance()), key);
        QueryProvider qep = QueryProvider.makeQueryRunner(GenericListTag.getDataSourceName(pageContext), MakumbaJspAnalyzer.getQueryLanguage(GenericListTag.getPageCache(pageContext, MakumbaJspAnalyzer.getInstance())), PageAttributes.getAttributes(pageContext));
        try {
            int defaultLimitInt = QueryExecution.computeLimit(pageContext, defaultLimit, -1, -1);
            this.listData = cq.execute(qep, null, new Evaluator(pageContext), QueryExecution.computeLimit(pageContext, offset, 0, 0), QueryExecution.computeLimit(pageContext, limit, defaultLimitInt, -1));
        }
        finally {
            qep.close();
        }
    }

    public static int computeLimit(PageContext pc, String s, int defaultValue, int defaultNonSpecified) throws LogicException {
        if (s == null) {
            return defaultNonSpecified;
        }
        s = s.trim();
        Object o = s;
        if (s.startsWith("$")) {
            try {
                o = PageAttributes.getAttributes(pc).getAttribute(s.substring(1));
            }
            catch (AttributeNotFoundException e) {
                if (defaultValue != Integer.MIN_VALUE) {
                    return defaultValue;
                }
                throw e;
            }
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidValueException("Integer expected for OFFSET and LIMIT: " + s + ", value: " + o + ", type: " + o.getClass().getName());
            }
        }
        if (!(o instanceof Number) || (double)((Number)o).intValue() != ((Number)o).doubleValue()) {
            throw new InvalidValueException("Integer expected for OFFSET and LIMIT: " + s + ", value: " + o + ", type: " + o.getClass().getName());
        }
        return ((Number)o).intValue();
    }

    private static int computeLimit(PageContext pc, String s, int defaultNonSpecified) throws LogicException {
        return QueryExecution.computeLimit(pc, s, Integer.MIN_VALUE, defaultNonSpecified);
    }

    public int getIterationGroupData() {
        this.iteration = 0;
        this.iterationGroupData = this.listData.getData(this.currentDataSet);
        return this.dataSize();
    }

    public int dataSize() {
        if (this.iterationGroupData == null || this.iterationGroupData.size() == 0) {
            return 0;
        }
        return this.iterationGroupData.size();
    }

    public int onParentIteration() {
        this.getIterationGroupData();
        int n = this.dataSize();
        if (n != 0) {
            this.currentDataSet.push(this.currentListData());
        }
        return n;
    }

    public int nextGroupIteration() {
        this.valueQueryData.clear();
        this.currentDataSet.pop();
        ++this.iteration;
        if (this.iteration == this.iterationGroupData.size()) {
            this.currentDataSet.push(NOTHING);
            return -1;
        }
        this.currentDataSet.push(this.currentListData());
        return this.iteration;
    }

    public void endIterationGroup() {
        if (this.dataSize() > 0) {
            this.currentDataSet.pop();
        }
    }

    public ArrayMap currentListData() {
        return (ArrayMap)this.iterationGroupData.elementAt(this.iteration);
    }
}

