/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.tidy.servlet.TidyProcessor;
import org.w3c.tidy.servlet.filter.BufferedServletResponse;
import org.w3c.tidy.servlet.properties.JTidyServletProperties;

public class JTidyFilter
implements Filter {
    public static final String CONFIG_PROPERTIES_FILE_NAME = "properties.filename";
    public static final String CONFIG_CONFIG = "config";
    public static final String CONFIG_TEE = "tee";
    public static final String CONFIG_VALIDATE_ONLY = "validateOnly";
    public static final String CONFIG_DOUBLE_VALIDATION = "doubleValidation";
    public static final String CONFIG_COMMENTS_SUBST = "commentsSubst";
    private Log log;
    private String config;
    private boolean validateOnly;
    private boolean tee;
    private boolean doubleValidation;
    private boolean commentsSubst;
    static /* synthetic */ Class class$org$w3c$tidy$servlet$filter$JTidyFilter;

    private boolean getBoolean(String value, boolean defaultValue) {
        if (value != null) {
            return value.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public void init(FilterConfig filterConfig) {
        this.log = LogFactory.getLog((Class)(class$org$w3c$tidy$servlet$filter$JTidyFilter == null ? (class$org$w3c$tidy$servlet$filter$JTidyFilter = JTidyFilter.class$("org.w3c.tidy.servlet.filter.JTidyFilter")) : class$org$w3c$tidy$servlet$filter$JTidyFilter));
        JTidyServletProperties.getInstance().loadFile(filterConfig.getInitParameter(CONFIG_PROPERTIES_FILE_NAME));
        this.tee = this.getBoolean(filterConfig.getInitParameter(CONFIG_TEE), false);
        this.doubleValidation = this.getBoolean(filterConfig.getInitParameter(CONFIG_DOUBLE_VALIDATION), false);
        this.validateOnly = this.getBoolean(filterConfig.getInitParameter(CONFIG_VALIDATE_ONLY), false);
        this.config = filterConfig.getInitParameter(CONFIG_CONFIG);
        this.commentsSubst = this.getBoolean(filterConfig.getInitParameter(CONFIG_COMMENTS_SUBST), false);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            this.log.debug((Object)"Filter has been called, Request is not HTML");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        TidyProcessor tidyProcessor = new TidyProcessor(((HttpServletRequest)servletRequest).getSession(), (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
        tidyProcessor.setValidateOnly(this.validateOnly);
        tidyProcessor.setDoubleValidation(this.doubleValidation);
        tidyProcessor.setConfig(this.config);
        tidyProcessor.setCommentsSubst(this.commentsSubst);
        this.log.debug((Object)((HttpServletRequest)servletRequest).getRequestURI());
        BufferedServletResponse wrappedResponse = new BufferedServletResponse((HttpServletResponse)servletResponse, tidyProcessor);
        wrappedResponse.setTee(this.tee);
        try {
            filterChain.doFilter(servletRequest, (ServletResponse)wrappedResponse);
            this.log.debug((Object)"Filter finished");
        }
        finally {
            wrappedResponse.finishResponse();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

