/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.commands;

import java.util.List;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.commands.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumCoreCommand
extends Command {
    public static final String CAPTURE_ENTIRE_PAGE_SCREENSHOT_ID = "captureEntirePageScreenshot";
    private static final Log LOGGER = LogFactory.getLog(SeleniumCoreCommand.class);
    private final String id;
    private final List<String> values;
    private final String sessionId;

    public SeleniumCoreCommand(String id, List<String> values, String sessionId) {
        this.id = id;
        this.values = values;
        this.sessionId = sessionId;
    }

    @Override
    public String execute() {
        LOGGER.debug("Executing '" + this.id + "' selenium core command on session " + this.sessionId);
        try {
            LOGGER.debug("Session " + this.sessionId + " going to doCommand(" + this.id + ',' + this.values.get(0) + ',' + this.values.get(1) + ")");
            FrameGroupCommandQueueSet queue = FrameGroupCommandQueueSet.getQueueSet(this.sessionId);
            String response = queue.doCommand(this.id, this.values.get(0), this.values.get(1));
            LOGGER.debug("Got result: " + response + " on session " + this.sessionId);
            return response;
        }
        catch (Exception e) {
            LOGGER.error("Exception running '" + this.id + " 'command on session " + this.sessionId, e);
            return "ERROR Server Exception: " + e.getMessage();
        }
    }
}

